/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.fbp;

import com.philips.lighting.hue.sdk.clip.PHBridgeConfigurationSerializer;
import com.philips.lighting.hue.sdk.clip.PHGroupSerializer;
import com.philips.lighting.hue.sdk.clip.PHLightSerializer;
import com.philips.lighting.hue.sdk.clip.PHRuleSerializer;
import com.philips.lighting.hue.sdk.clip.PHSceneSerializer;
import com.philips.lighting.hue.sdk.clip.PHScheduleSerializer;
import com.philips.lighting.hue.sdk.clip.PHSensorSerializer;
import com.philips.lighting.hue.sdk.clip.PHSerializer;
import com.philips.lighting.hue.sdk.clip.PHTimeZoneSerializer;
import com.philips.lighting.hue.sdk.clip.serialisation.PHBridgeConfigurationSerializer1;
import com.philips.lighting.hue.sdk.utilities.impl.PHLog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.hue.JSONArray;
import org.json.hue.JSONObject;

public class PHBridgeVersionManager {
    private static final String TAG = PHBridgeVersionManager.class.getSimpleName();
    private static final String BRIDGE_SOFTWARE = "swversion";
    private static final String BRIDGE_API_LEVEL = "api_level";
    private static final String BRIDGE_FEATURES = "features";
    private static final String SERIALIZER_PACKAGE_NAME = "com.philips.lighting.hue.sdk.clip.serialisation";
    private static JSONArray bridgeList;
    private String currentBridgeVersion;
    private String currentAPILevel;
    private JSONObject currentBridge;
    private List<PHSerializer> serializers;
    private static PHBridgeVersionManager bvManager;

    public static synchronized PHBridgeVersionManager getInstance() {
        if (bvManager == null) {
            bvManager = new PHBridgeVersionManager();
            bvManager.loadBridgeList();
            bvManager.setBridgeVersion("01003542", "1.0.0");
        }
        return bvManager;
    }

    public void setFallbackBridgeVersion(String bridgeVersion, String apiVersion) {
        if (apiVersion != null) {
            PHLog.d(TAG, "Trying fallback with api version");
            ArrayList<String> bridgeApiVersions = new ArrayList<String>();
            for (int i = 0; i < bridgeList.length(); ++i) {
                JSONObject bridgeVersionEntry = bridgeList.getJSONObject(i);
                String api = bridgeVersionEntry.optString(BRIDGE_API_LEVEL);
                if (api == null || bridgeApiVersions.contains(api)) continue;
                bridgeApiVersions.add(api);
            }
            bridgeApiVersions.add(apiVersion);
            Collections.sort(bridgeApiVersions);
            int pos = bridgeApiVersions.indexOf(apiVersion);
            if (--pos < 0) {
                PHLog.d(TAG, "Fallback with api version not found, retry with bridge version alone");
                this.setFallbackBridgeVersion(bridgeVersion, null);
                return;
            }
            String fallbackApi = (String)bridgeApiVersions.get(pos);
            PHLog.d(TAG, "Fallback api found: " + fallbackApi);
            this.setBridgeVersion(bridgeVersion, fallbackApi);
        } else {
            PHLog.d(TAG, "Trying fallback with swversion");
            ArrayList<String> swVersions = new ArrayList<String>();
            for (int i = 0; i < bridgeList.length(); ++i) {
                JSONObject bridgeVersionEntry = bridgeList.getJSONObject(i);
                String swversion = bridgeVersionEntry.optString(BRIDGE_SOFTWARE);
                if (swversion == null) continue;
                swVersions.add(swversion);
            }
            swVersions.add(bridgeVersion);
            Collections.sort(swVersions);
            int pos = swVersions.indexOf(bridgeVersion);
            if (--pos < 0) {
                PHLog.d(TAG, "Fallback failed, taking core api 1.0.0");
                this.setBridgeVersion("01003542", "1.0.0");
                return;
            }
            String fallbackSwVersion = (String)swVersions.get(pos);
            PHLog.d(TAG, "Fallback swversion found: " + fallbackSwVersion);
            this.setBridgeVersion(fallbackSwVersion, null);
        }
    }

    private void loadBridgeList() {
        String fName = "/featureResources.json";
        String jsonString = null;
        try {
            jsonString = PHBridgeVersionManager.loadConfiguration(fName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONObject fullFeatureList = new JSONObject(jsonString);
        bridgeList = fullFeatureList.getJSONArray("bridgeversions");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadConfiguration(String fileName) throws IOException {
        InputStream is = PHBridgeVersionManager.class.getResourceAsStream(fileName);
        if (is == null) {
            PHLog.e(TAG, "Resource stream is null: " + fileName);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        try {
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append('\n');
                line = br.readLine();
            }
        }
        finally {
            br.close();
        }
        return sb.toString();
    }

    public String getBridgeVersion() {
        return this.currentBridgeVersion;
    }

    public void setBridgeVersion(String bridgeVersion, String apiVersion) {
        JSONObject bridge;
        int i;
        boolean bridgeVersionMatched = false;
        PHLog.d(TAG, "Trying to match bridge version " + bridgeVersion + " and api version " + apiVersion);
        if (this.currentBridgeVersion != null && bridgeVersion != null && this.currentBridgeVersion.equals(bridgeVersion)) {
            return;
        }
        if (this.currentAPILevel != null && apiVersion != null && this.currentAPILevel.equals(apiVersion) && this.currentBridgeVersion != null && bridgeVersion != null && this.currentBridgeVersion.equals(bridgeVersion)) {
            return;
        }
        if (bridgeVersion != null) {
            for (i = 0; i < bridgeList.length(); ++i) {
                bridge = bridgeList.getJSONObject(i);
                String bridgeSw = bridge.optString(BRIDGE_SOFTWARE);
                if (bridgeSw == null || !bridgeSw.equals(bridgeVersion)) continue;
                this.currentBridge = bridge;
                this.currentBridgeVersion = bridgeVersion;
                bridgeVersionMatched = true;
                this.currentAPILevel = bridge.optString(BRIDGE_API_LEVEL);
                PHLog.d(TAG, "Matched bridge version " + bridgeVersion + ", API level " + this.currentAPILevel);
                ArrayList<PHSerializer> serializerList = new ArrayList<PHSerializer>();
                JSONArray features = bridge.getJSONArray(BRIDGE_FEATURES);
                for (int f = 0; f < features.length(); ++f) {
                    String feature = features.getString(f);
                    String[] featureParts = feature.split("API");
                    String serializerName = "com.philips.lighting.hue.sdk.clip.serialisation.PH" + featureParts[0] + "Serializer" + featureParts[1];
                    try {
                        PHSerializer serializer = (PHSerializer)Class.forName(serializerName).newInstance();
                        serializerList.add(serializer);
                        continue;
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
                this.serializers = serializerList;
            }
        }
        if (apiVersion != null && !bridgeVersionMatched) {
            for (i = 0; i < bridgeList.length(); ++i) {
                bridge = bridgeList.getJSONObject(i);
                String apiV = bridge.optString(BRIDGE_API_LEVEL);
                String bridgeSw = bridge.optString(BRIDGE_SOFTWARE);
                if (bridgeSw != null && !bridgeSw.isEmpty() || !apiV.equals(apiVersion)) continue;
                this.currentBridge = bridge;
                this.currentBridgeVersion = bridgeVersion != null ? bridgeVersion : bridgeSw;
                this.currentAPILevel = apiV;
                bridgeVersionMatched = true;
                PHLog.d(TAG, "Matched bridge version " + bridgeVersion + ", API level " + this.currentAPILevel);
                ArrayList<PHSerializer> serializerList = new ArrayList<PHSerializer>();
                JSONArray features = bridge.getJSONArray(BRIDGE_FEATURES);
                for (int f = 0; f < features.length(); ++f) {
                    String feature = features.getString(f);
                    String[] featureParts = feature.split("API");
                    String serializerName = "com.philips.lighting.hue.sdk.clip.serialisation.PH" + featureParts[0] + "Serializer" + featureParts[1];
                    try {
                        PHSerializer serializer = (PHSerializer)Class.forName(serializerName).newInstance();
                        serializerList.add(serializer);
                        continue;
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
                this.serializers = serializerList;
            }
        }
        if (!bridgeVersionMatched) {
            PHLog.d(TAG, "Unsupported Bridge Software version sent: " + bridgeVersion);
            this.setFallbackBridgeVersion(bridgeVersion, apiVersion);
        }
    }

    public String getApiLevel() {
        return this.currentAPILevel;
    }

    public PHLightSerializer getLightSerializer() {
        for (PHSerializer serializer : this.serializers) {
            if (!PHLightSerializer.class.isAssignableFrom(serializer.getClass())) continue;
            return (PHLightSerializer)serializer;
        }
        return null;
    }

    public PHSensorSerializer getSensorSerializer() {
        for (PHSerializer serializer : this.serializers) {
            if (!PHSensorSerializer.class.isAssignableFrom(serializer.getClass())) continue;
            return (PHSensorSerializer)serializer;
        }
        return null;
    }

    public PHGroupSerializer getGroupSerializer() {
        for (PHSerializer serializer : this.serializers) {
            if (!PHGroupSerializer.class.isAssignableFrom(serializer.getClass())) continue;
            return (PHGroupSerializer)serializer;
        }
        return null;
    }

    public PHBridgeConfigurationSerializer getBridgeConfigurationSerializer() {
        if (this.serializers != null) {
            for (PHSerializer serializer : this.serializers) {
                if (!PHBridgeConfigurationSerializer.class.isAssignableFrom(serializer.getClass())) continue;
                return (PHBridgeConfigurationSerializer)serializer;
            }
        }
        return new PHBridgeConfigurationSerializer1();
    }

    public PHScheduleSerializer getSchedulesSerializer() {
        for (PHSerializer serializer : this.serializers) {
            if (!PHScheduleSerializer.class.isAssignableFrom(serializer.getClass())) continue;
            return (PHScheduleSerializer)serializer;
        }
        return null;
    }

    public PHSceneSerializer getScenesSerializer() {
        for (PHSerializer serializer : this.serializers) {
            if (!PHSceneSerializer.class.isAssignableFrom(serializer.getClass())) continue;
            return (PHSceneSerializer)serializer;
        }
        return null;
    }

    public PHRuleSerializer getRulesSerializer() {
        for (PHSerializer serializer : this.serializers) {
            if (!PHRuleSerializer.class.isAssignableFrom(serializer.getClass())) continue;
            return (PHRuleSerializer)serializer;
        }
        return null;
    }

    public PHTimeZoneSerializer getTimeZoneSerializer() {
        for (PHSerializer serializer : this.serializers) {
            if (!PHTimeZoneSerializer.class.isAssignableFrom(serializer.getClass())) continue;
            return (PHTimeZoneSerializer)serializer;
        }
        return null;
    }
}

