/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip.serialisation.sensors;

import com.philips.lighting.hue.sdk.clip.serialisation.sensors.PHSensorSerializerBase1;
import com.philips.lighting.model.sensor.PHOpenCloseSensor;
import com.philips.lighting.model.sensor.PHOpenCloseSensorConfiguration;
import com.philips.lighting.model.sensor.PHOpenCloseSensorState;
import org.json.hue.JSONObject;

public class PHOpenCloseSensorSerializer1
extends PHSensorSerializerBase1 {
    public static PHOpenCloseSensor createFromJSON(JSONObject json, String identifier) {
        PHOpenCloseSensor.Type type = PHOpenCloseSensor.Type.CLIP;
        String sType = json.optString("type");
        if (sType != null && sType.equals(PHOpenCloseSensor.Type.ZLL.getValue())) {
            type = PHOpenCloseSensor.Type.ZLL;
        }
        PHOpenCloseSensor sensor = new PHOpenCloseSensor("", identifier, type);
        sensor = (PHOpenCloseSensor)PHOpenCloseSensorSerializer1.fillBasicSensor(sensor, json);
        sensor = PHOpenCloseSensorSerializer1.createConfigurationFromJSON(json, sensor);
        sensor = PHOpenCloseSensorSerializer1.createStateFromJSON(json, sensor);
        return sensor;
    }

    private static PHOpenCloseSensor createStateFromJSON(JSONObject json, PHOpenCloseSensor sensor) {
        JSONObject sensorStateObject = json.optJSONObject("state");
        if (sensorStateObject != null) {
            PHOpenCloseSensorState state = new PHOpenCloseSensorState();
            state = (PHOpenCloseSensorState)PHOpenCloseSensorSerializer1.fillBasicSensorState(state, sensorStateObject);
            if (sensorStateObject.has("open")) {
                Boolean parsedOpen = sensorStateObject.optBoolean("open");
                state.setOpen(parsedOpen);
            } else {
                state.setOpen(null);
            }
            sensor.setState(state);
        }
        return sensor;
    }

    private static PHOpenCloseSensor createConfigurationFromJSON(JSONObject json, PHOpenCloseSensor sensor) {
        JSONObject sensorConfigObject = json.optJSONObject("config");
        if (sensorConfigObject != null) {
            PHOpenCloseSensorConfiguration config = new PHOpenCloseSensorConfiguration();
            config = (PHOpenCloseSensorConfiguration)PHOpenCloseSensorSerializer1.fillBasicSensorConfiguration(config, sensorConfigObject);
            sensor.setConfiguration(config);
        }
        return sensor;
    }

    public static JSONObject getJSON(PHOpenCloseSensor sensor) {
        JSONObject json = PHOpenCloseSensorSerializer1.getJSONSensorBase(sensor);
        json.putOpt("type", sensor.getTypeAsString());
        json = PHOpenCloseSensorSerializer1.addSensorStateJSON(json, sensor.getState());
        json = PHOpenCloseSensorSerializer1.addSensorConfigurationJSON(json, sensor.getConfiguration());
        return json;
    }

    private static JSONObject addSensorStateJSON(JSONObject sensorObj, PHOpenCloseSensorState state) {
        if (state != null) {
            JSONObject json = PHOpenCloseSensorSerializer1.getJSONSensorStateBase(state);
            String type = sensorObj.getString("type");
            if (!type.equals(PHOpenCloseSensor.Type.ZLL.getValue())) {
                json.putOpt("open", state.getOpen());
            }
            sensorObj.put("state", json);
        }
        return sensorObj;
    }

    private static JSONObject addSensorConfigurationJSON(JSONObject sensorObj, PHOpenCloseSensorConfiguration config) {
        if (config != null) {
            JSONObject json = PHOpenCloseSensorSerializer1.getJSONSensorConfigurationBase(config);
            String type = sensorObj.getString("type");
            if (type.equals(PHOpenCloseSensor.Type.ZLL.getValue())) {
                json.remove("battery");
            }
            sensorObj.put("config", json);
        }
        return sensorObj;
    }

    public static JSONObject getStateJSON(PHOpenCloseSensor sensor) {
        JSONObject sensorObj = PHOpenCloseSensorSerializer1.getJSON(sensor);
        return sensorObj.getJSONObject("state");
    }

    public static JSONObject getConfigurationJSON(PHOpenCloseSensor sensor) {
        JSONObject sensorObj = PHOpenCloseSensorSerializer1.getJSON(sensor);
        return sensorObj.getJSONObject("config");
    }
}

