/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip.serialisation.sensors;

import com.philips.lighting.hue.sdk.clip.serialisation.sensors.PHSensorSerializerBase1;
import com.philips.lighting.model.sensor.PHGeofenceSensor;
import com.philips.lighting.model.sensor.PHGeofenceSensorConfiguration;
import com.philips.lighting.model.sensor.PHGeofenceSensorState;
import org.json.hue.JSONObject;

public class PHGeofenceSensorSerializer1
extends PHSensorSerializerBase1 {
    public static PHGeofenceSensor createFromJSON(JSONObject json, String identifier) {
        PHGeofenceSensor sensor = new PHGeofenceSensor("", identifier);
        sensor = (PHGeofenceSensor)PHGeofenceSensorSerializer1.fillBasicSensor(sensor, json);
        sensor = PHGeofenceSensorSerializer1.createConfigurationFromJSON(json, sensor);
        sensor = PHGeofenceSensorSerializer1.createStateFromJSON(json, sensor);
        return sensor;
    }

    private static PHGeofenceSensor createStateFromJSON(JSONObject json, PHGeofenceSensor sensor) {
        JSONObject sensorStateObject = json.optJSONObject("state");
        if (sensorStateObject != null) {
            PHGeofenceSensorState state = new PHGeofenceSensorState();
            state = (PHGeofenceSensorState)PHGeofenceSensorSerializer1.fillBasicSensorState(state, sensorStateObject);
            if (sensorStateObject.has("presence")) {
                Boolean parsedPresence = sensorStateObject.optBoolean("presence");
                state.setPresence(parsedPresence);
            } else {
                state.setPresence(null);
            }
            sensor.setState(state);
        }
        return sensor;
    }

    private static PHGeofenceSensor createConfigurationFromJSON(JSONObject json, PHGeofenceSensor sensor) {
        JSONObject sensorConfigObject = json.optJSONObject("config");
        if (sensorConfigObject != null) {
            PHGeofenceSensorConfiguration config = new PHGeofenceSensorConfiguration();
            config = (PHGeofenceSensorConfiguration)PHGeofenceSensorSerializer1.fillBasicSensorConfiguration(config, sensorConfigObject);
            if (sensorConfigObject.has("radius")) {
                Integer parsedRadius = sensorConfigObject.optInt("radius");
                config.setRadius(parsedRadius);
            } else {
                config.setRadius(null);
            }
            if (sensorConfigObject.has("device")) {
                String parsedDevice = sensorConfigObject.optString("device");
                config.setDevice(parsedDevice);
            } else {
                config.setDevice(null);
            }
            sensor.setConfiguration(config);
        }
        return sensor;
    }

    public static JSONObject getJSON(PHGeofenceSensor sensor) {
        JSONObject json = PHGeofenceSensorSerializer1.getJSONSensorBase(sensor);
        json.putOpt("type", sensor.getTypeAsString());
        json = PHGeofenceSensorSerializer1.addSensorStateJSON(json, sensor.getState());
        json = PHGeofenceSensorSerializer1.addSensorConfigurationJSON(json, sensor.getConfiguration());
        return json;
    }

    private static JSONObject addSensorStateJSON(JSONObject sensorObj, PHGeofenceSensorState state) {
        if (state != null) {
            JSONObject json = PHGeofenceSensorSerializer1.getJSONSensorStateBase(state);
            json.putOpt("presence", state.getPresence());
            sensorObj.put("state", json);
        }
        return sensorObj;
    }

    private static JSONObject addSensorConfigurationJSON(JSONObject sensorObj, PHGeofenceSensorConfiguration config) {
        if (config != null) {
            JSONObject json = PHGeofenceSensorSerializer1.getJSONSensorConfigurationBase(config);
            json.remove("battery");
            json.remove("url");
            json.putOpt("device", config.getDevice());
            json.putOpt("radius", config.getRadius());
            sensorObj.putOpt("config", json);
        }
        return sensorObj;
    }

    public static JSONObject getStateJSON(PHGeofenceSensor sensor) {
        JSONObject sensorObj = PHGeofenceSensorSerializer1.getJSON(sensor);
        return sensorObj.getJSONObject("state");
    }

    public static JSONObject getConfigurationJSON(PHGeofenceSensor sensor) {
        JSONObject sensorObj = PHGeofenceSensorSerializer1.getJSON(sensor);
        return sensorObj.getJSONObject("config");
    }
}

