/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip.serialisation;

import com.philips.lighting.hue.sdk.clip.serialisation.PHScheduleSerializer4;
import com.philips.lighting.model.PHSchedule;
import java.util.List;
import org.json.hue.JSONArray;
import org.json.hue.JSONObject;

public class PHScheduleSerializer5
extends PHScheduleSerializer4 {
    private static PHScheduleSerializer5 schedulesSerialisation5;

    public static synchronized PHScheduleSerializer5 getInstance() {
        if (schedulesSerialisation5 == null) {
            schedulesSerialisation5 = new PHScheduleSerializer5();
        }
        return schedulesSerialisation5;
    }

    @Override
    public JSONObject createSchedulePacket(PHSchedule schedule, String cmdAddress, String method, String timeZone, boolean autodeleteSchedule) {
        JSONObject result = super.createSchedulePacket(schedule, cmdAddress, method, timeZone);
        result.put("autodelete", autodeleteSchedule);
        return result;
    }

    @Override
    public JSONObject createSchedulePacket(PHSchedule schedule, String cmdAddress, String method, boolean autodeleteSchedule) {
        JSONObject result = super.createSchedulePacket(schedule, cmdAddress, method);
        result.put("autodelete", autodeleteSchedule);
        return result;
    }

    @Override
    public JSONObject createSchedulePacket(PHSchedule schedule, String cmdAddress, String method, String timeZone) {
        JSONObject result = super.createSchedulePacket(schedule, cmdAddress, method, timeZone);
        if (!schedule.getAutoDelete().booleanValue()) {
            result.put("autodelete", false);
        }
        return result;
    }

    @Override
    public List<PHSchedule> parseSchedules(JSONObject rootObject, String sTimeZone) {
        JSONArray schedulesArray;
        List<PHSchedule> schedulesList = super.parseSchedules(rootObject, sTimeZone);
        JSONObject schedules = rootObject.optJSONObject("schedules");
        if (schedules == null) {
            schedules = rootObject;
        }
        if (schedules != null && (schedulesArray = schedules.names()) != null) {
            for (int i = 0; i < schedulesArray.length(); ++i) {
                String scheduleIdentifier = schedulesArray.optString(i);
                JSONObject scheduleObject = schedules.optJSONObject(scheduleIdentifier);
                Boolean autoDeleteSchedule = scheduleObject.optBoolean("autodelete");
                schedulesList.get(i).setAutoDelete(autoDeleteSchedule);
            }
        }
        return schedulesList;
    }
}

