/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip.serialisation;

import com.philips.lighting.hue.sdk.clip.serialisation.PHLightSerializer6;
import com.philips.lighting.hue.sdk.utilities.impl.PHLog;
import com.philips.lighting.model.PHLight;
import java.util.List;
import org.json.hue.JSONArray;
import org.json.hue.JSONException;
import org.json.hue.JSONObject;

public class PHLightSerializer7
extends PHLightSerializer6 {
    private static final String TAG = PHLightSerializer7.class.getSimpleName();
    private static PHLightSerializer7 lightSerialisation7;

    public static synchronized PHLightSerializer7 getInstance() {
        if (lightSerialisation7 == null) {
            lightSerialisation7 = new PHLightSerializer7();
        }
        return lightSerialisation7;
    }

    @Override
    public PHLight parseLightDetails(String response, String lightIdentifier) {
        PHLight light;
        block3: {
            light = super.parseLightDetails(response, lightIdentifier);
            JSONObject jObject = null;
            try {
                jObject = new JSONObject(response);
                if (jObject != null) {
                    String luminaireUniqueId = jObject.optString("luminaireuniqueid");
                    light.setLuminaireUniqueId(luminaireUniqueId);
                }
            }
            catch (JSONException e) {
                if (!PHLog.isLoggable()) break block3;
                PHLog.e(TAG, "JSONException: " + e);
            }
        }
        return light;
    }

    @Override
    public List<PHLight> parseLights(JSONObject rootObject) {
        JSONArray lightsArray;
        List<PHLight> lightsList = super.parseLights(rootObject);
        JSONObject lights = rootObject.optJSONObject("lights");
        if (lights == null) {
            lights = rootObject;
        }
        if (lights != null && (lightsArray = lights.names()) != null) {
            for (int i = 0; i < lightsArray.length(); ++i) {
                String lightIdentifier = lightsArray.optString(i);
                JSONObject lightsObject = lights.optJSONObject(lightIdentifier);
                String luminaireUniqueId = lightsObject.optString("luminaireuniqueid");
                lightsList.get(i).setLuminaireUniqueId(luminaireUniqueId);
            }
        }
        return lightsList;
    }
}

