/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip.serialisation;

import com.philips.lighting.hue.sdk.clip.serialisation.PHLightSerializer4;
import com.philips.lighting.hue.sdk.utilities.impl.PHLog;
import com.philips.lighting.model.PHLight;
import com.philips.lighting.model.PHLightState;
import java.util.List;
import org.json.hue.JSONArray;
import org.json.hue.JSONException;
import org.json.hue.JSONObject;

public class PHLightSerializer5
extends PHLightSerializer4 {
    private static final String TAG = PHLightSerializer5.class.getSimpleName();
    private static PHLightSerializer5 lightSerialisation5;

    public static synchronized PHLightSerializer5 getInstance() {
        if (lightSerialisation5 == null) {
            lightSerialisation5 = new PHLightSerializer5();
        }
        return lightSerialisation5;
    }

    @Override
    public JSONObject createLightStatePacket(PHLightState state) throws JSONException {
        JSONObject toSend = super.createLightStatePacket(state);
        if (state.getIncrementBri() != null) {
            toSend.putOpt("bri_inc", state.getIncrementBri());
        }
        if (state.getIncrementCt() != null) {
            toSend.putOpt("ct_inc", state.getIncrementCt());
        }
        if (state.getIncrementHue() != null) {
            toSend.putOpt("hue_inc", state.getIncrementHue());
        }
        if (state.getIncrementSat() != null) {
            toSend.putOpt("sat_inc", state.getIncrementSat());
        }
        if (state.getIncrementX() != null && state.getIncrementY() != null) {
            JSONArray xyArray = new JSONArray();
            xyArray.put(state.getIncrementX());
            xyArray.put(state.getIncrementY());
            toSend.putOpt("xy_inc", xyArray);
        }
        return toSend;
    }

    @Override
    public PHLight parseLightDetails(String response, String lightIdentifier) {
        PHLight light;
        block3: {
            light = super.parseLightDetails(response, lightIdentifier);
            JSONObject jObject = null;
            try {
                jObject = new JSONObject(response);
                if (jObject != null) {
                    String manufacturerName = jObject.optString("manufacturername");
                    light.setManufacturerName(manufacturerName);
                }
            }
            catch (JSONException e) {
                if (!PHLog.isLoggable()) break block3;
                PHLog.e(TAG, "JSONException: " + e);
            }
        }
        return light;
    }

    @Override
    public List<PHLight> parseLights(JSONObject rootObject) {
        JSONArray lightsArray;
        List<PHLight> lightsList = super.parseLights(rootObject);
        JSONObject lights = rootObject.optJSONObject("lights");
        if (lights == null) {
            lights = rootObject;
        }
        if (lights != null && (lightsArray = lights.names()) != null) {
            for (int i = 0; i < lightsArray.length(); ++i) {
                String lightIdentifier = lightsArray.optString(i);
                JSONObject lightObject = lights.optJSONObject(lightIdentifier);
                String manufacturername = lightObject.optString("manufacturername");
                lightsList.get(i).setManufacturerName(manufacturername);
            }
        }
        return lightsList;
    }
}

