/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip.serialisation;

import com.philips.lighting.hue.sdk.clip.serialisation.PHLightSerializer3;
import com.philips.lighting.hue.sdk.utilities.impl.PHLog;
import com.philips.lighting.model.PHLight;
import com.philips.lighting.model.PHLightState;
import java.util.List;
import org.json.hue.JSONArray;
import org.json.hue.JSONException;
import org.json.hue.JSONObject;

public class PHLightSerializer4
extends PHLightSerializer3 {
    private static final String TAG = PHLightSerializer4.class.getSimpleName();
    private static PHLightSerializer4 lightSerialisation4;

    public static synchronized PHLightSerializer4 getInstance() {
        if (lightSerialisation4 == null) {
            lightSerialisation4 = new PHLightSerializer4();
        }
        return lightSerialisation4;
    }

    @Override
    public PHLight parseLightDetails(String response, String lightIdentifier) {
        PHLight light;
        block3: {
            light = super.parseLightDetails(response, lightIdentifier);
            JSONObject jObject = null;
            try {
                jObject = new JSONObject(response);
                if (jObject != null) {
                    String uniqueId = jObject.optString("uniqueid");
                    light.setUniqueId(uniqueId);
                }
            }
            catch (JSONException e) {
                if (!PHLog.isLoggable()) break block3;
                PHLog.e(TAG, "JSONException: " + e);
            }
        }
        return light;
    }

    @Override
    public List<PHLight> parseLights(JSONObject rootObject) {
        JSONArray lightsArray;
        List<PHLight> lightsList = super.parseLights(rootObject);
        JSONObject lights = rootObject.optJSONObject("lights");
        if (lights == null) {
            lights = rootObject;
        }
        if (lights != null && (lightsArray = lights.names()) != null) {
            for (int i = 0; i < lightsArray.length(); ++i) {
                String lightIdentifier = lightsArray.optString(i);
                JSONObject lightObject = lights.optJSONObject(lightIdentifier);
                String uniqueId = lightObject.optString("uniqueid");
                lightsList.get(i).setUniqueId(uniqueId);
            }
        }
        return lightsList;
    }

    @Override
    public boolean canCreate() {
        return true;
    }

    @Override
    public boolean validateAPI(PHLight light) {
        return true;
    }

    @Override
    public boolean validateAPI(PHLightState lightState) {
        return true;
    }

    @Override
    public boolean canLightConfigurationRead() {
        return true;
    }

    @Override
    public boolean canLightConfigurationUpdate() {
        return true;
    }
}

