/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip.serialisation;

import com.philips.lighting.hue.sdk.clip.PHCLIPParser;
import com.philips.lighting.model.PHHueError;
import com.philips.lighting.model.PHHueParsingError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.hue.JSONArray;
import org.json.hue.JSONException;
import org.json.hue.JSONObject;

public class PHCLIPParserBase
implements PHCLIPParser {
    private List<PHHueParsingError> parsingErrors = new ArrayList<PHHueParsingError>();
    private static PHCLIPParserBase clipParserBase;

    public static synchronized PHCLIPParserBase getInstance() {
        if (clipParserBase == null) {
            clipParserBase = new PHCLIPParserBase();
        }
        return clipParserBase;
    }

    @Override
    public boolean parseIsSuccess(String response) {
        JSONObject jObject = null;
        try {
            String isSucceeded;
            JSONArray jsonArray = new JSONArray(response);
            jObject = jsonArray.optJSONObject(0);
            if (jObject != null && (isSucceeded = jObject.optString("success")) != null) {
                return true;
            }
        }
        catch (JSONException e) {
            // empty catch block
        }
        return false;
    }

    @Override
    public List<PHHueError> parseError(String response) {
        ArrayList<PHHueError> errorList = new ArrayList<PHHueError>();
        try {
            JSONArray jsonArray;
            try {
                jsonArray = new JSONArray(response);
            }
            catch (JSONException je) {
                return errorList;
            }
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject errorObject;
                JSONObject jsonObject = jsonArray.optJSONObject(i);
                if (jsonObject == null || (errorObject = jsonObject.optJSONObject("error")) == null) continue;
                int type = errorObject.optInt("type");
                String description = errorObject.optString("description");
                String address = errorObject.optString("address");
                errorList.add(new PHHueError(type, description, address));
            }
        }
        catch (JSONException e) {
            // empty catch block
        }
        return errorList;
    }

    @Override
    public Map<String, String> parseSuccess(String response) {
        HashMap<String, String> successMap = new HashMap<String, String>();
        try {
            JSONArray jsonArray = new JSONArray(response);
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject successObj;
                JSONObject jsonObject = jsonArray.optJSONObject(i);
                if (jsonObject == null || (successObj = jsonObject.optJSONObject("success")) == null) continue;
                Iterator iter = successObj.keys();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = successObj.optString(key);
                    successMap.put(key, value);
                }
            }
        }
        catch (JSONException e) {
            // empty catch block
        }
        return successMap;
    }

    @Override
    public void clearErrors() {
        this.parsingErrors.clear();
    }

    protected void reportParsingError(int code, String resourceId, String message, JSONObject context) {
        PHHueParsingError error = new PHHueParsingError(code, resourceId, message, context);
        this.parsingErrors.add(error);
    }

    @Override
    public List<PHHueParsingError> getParsingErrors() {
        return this.parsingErrors;
    }
}

