/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip.serialisation;

import com.philips.lighting.hue.sdk.clip.serialisation.PHBridgeConfigurationSerializer7;
import com.philips.lighting.model.PHBackup;
import com.philips.lighting.model.PHBridgeConfiguration;
import org.json.hue.JSONException;
import org.json.hue.JSONObject;

public class PHBridgeConfigurationSerializer8
extends PHBridgeConfigurationSerializer7 {
    private static PHBridgeConfigurationSerializer8 bridgeConfigSerialisation8;

    public static synchronized PHBridgeConfigurationSerializer8 getInstance() {
        if (bridgeConfigSerialisation8 == null) {
            bridgeConfigSerialisation8 = new PHBridgeConfigurationSerializer8();
        }
        return bridgeConfigSerialisation8;
    }

    @Override
    public PHBridgeConfiguration parseBridgeConfiguration(JSONObject rootObject) {
        PHBridgeConfiguration config = super.parseBridgeConfiguration(rootObject);
        if (config != null) {
            JSONObject configObject = null;
            configObject = rootObject.has("config") ? rootObject.getJSONObject("config") : rootObject;
            if (configObject.has("factorynew")) {
                boolean factoryNew = configObject.getBoolean("factorynew");
                config.setFactoryNew(factoryNew);
            }
            if (configObject.has("replacesbridgeid")) {
                String replacesBridgeId = configObject.optString("replacesbridgeid");
                config.setReplacesBridgeId(replacesBridgeId);
            }
            if (configObject.has("backup")) {
                JSONObject backupconfig;
                PHBackup backup = config.getBackup();
                if (backup == null) {
                    backup = new PHBackup();
                }
                if ((backupconfig = configObject.getJSONObject("backup")).has("status")) {
                    backup.setStatus(PHBackup.getBackupStatus(backupconfig.optString("status")));
                }
                if (backupconfig.has("errorcode")) {
                    backup.setErrorCode(backupconfig.getInt("errorcode"));
                }
                config.setBackup(backup);
            }
        }
        return config;
    }

    @Override
    public JSONObject updateBridgeConfigurationPacket(PHBridgeConfiguration bridgeConfig) throws JSONException {
        JSONObject toSend = super.updateBridgeConfigurationPacket(bridgeConfig);
        PHBackup backup = bridgeConfig.getBackup();
        if (backup != null) {
            JSONObject backupJson = new JSONObject();
            PHBackup.PHBackupStatus status = backup.getStatus();
            if (status != null) {
                backupJson.putOpt("status", status.toString().toLowerCase());
            }
            toSend.putOpt("backup", backupJson);
        }
        return toSend;
    }
}

