/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.bridge.impl;

import com.philips.lighting.model.PHBridgeConfiguration;
import com.philips.lighting.model.PHBridgeResourcesCache;
import com.philips.lighting.model.PHGroup;
import com.philips.lighting.model.PHLight;
import com.philips.lighting.model.PHScene;
import com.philips.lighting.model.PHSchedule;
import com.philips.lighting.model.rule.PHRule;
import com.philips.lighting.model.sensor.PHSensor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PHBridgeResourcesCacheImpl
implements PHBridgeResourcesCache {
    private Map<String, PHLight> lights = new HashMap<String, PHLight>();
    private Map<String, PHGroup> groups = new HashMap<String, PHGroup>();
    private PHBridgeConfiguration bridgeConfig;
    private Map<String, PHSchedule> schedules = new HashMap<String, PHSchedule>();
    private Map<String, PHScene> scenes = new HashMap<String, PHScene>();
    private Map<String, PHSensor> sensors = new HashMap<String, PHSensor>();
    private Map<String, PHRule> rules = new HashMap<String, PHRule>();

    public void setBridgeConfiguration(PHBridgeConfiguration phBridgeConfig) {
        this.bridgeConfig = phBridgeConfig;
    }

    public void setLights(Map<String, PHLight> lights) {
        this.lights = lights;
    }

    public void setGroups(Map<String, PHGroup> groups) {
        this.groups = groups;
    }

    public void setSchedules(Map<String, PHSchedule> schedules) {
        this.schedules = schedules;
    }

    public void setScenes(Map<String, PHScene> scenes) {
        this.scenes = scenes;
    }

    public void setSensors(Map<String, PHSensor> sensors) {
        this.sensors = sensors;
    }

    @Override
    public Map<String, PHLight> getLights() {
        return this.lights;
    }

    @Override
    public Map<String, PHGroup> getGroups() {
        return this.groups;
    }

    @Override
    public PHBridgeConfiguration getBridgeConfiguration() {
        return this.bridgeConfig;
    }

    @Override
    public Map<String, PHSchedule> getSchedules() {
        return this.schedules;
    }

    @Override
    public Map<String, PHScene> getScenes() {
        return this.scenes;
    }

    @Override
    public List<PHLight> getAllLights() {
        ArrayList<PHLight> lightsList = new ArrayList<PHLight>();
        Collection<PHLight> values = this.lights.values();
        for (PHLight light : values) {
            lightsList.add(light);
        }
        return lightsList;
    }

    @Override
    public List<PHGroup> getAllGroups() {
        ArrayList<PHGroup> groupsList = new ArrayList<PHGroup>();
        Collection<PHGroup> values = this.groups.values();
        for (PHGroup group : values) {
            groupsList.add(group);
        }
        return groupsList;
    }

    @Override
    public List<PHScene> getAllScenes() {
        if (this.scenes == null) {
            return null;
        }
        Collection<PHScene> values = this.scenes.values();
        ArrayList<PHScene> list = new ArrayList<PHScene>();
        for (PHScene scene : values) {
            list.add(scene);
        }
        return list;
    }

    @Override
    public List<PHSchedule> getAllSchedules(boolean areReccurring) {
        Collection<PHSchedule> values = this.schedules.values();
        ArrayList<PHSchedule> scheduleList = new ArrayList<PHSchedule>();
        for (PHSchedule schedule : values) {
            if (areReccurring && schedule.getRecurringDays() != 0 && schedule.getDate() != null) {
                scheduleList.add(schedule);
                continue;
            }
            if (areReccurring || schedule.getRecurringDays() != 0 || schedule.getDate() == null) continue;
            scheduleList.add(schedule);
        }
        return scheduleList;
    }

    @Override
    public List<PHSchedule> getAllTimers(boolean areReccurring) {
        Collection<PHSchedule> values = this.schedules.values();
        ArrayList<PHSchedule> timersList = new ArrayList<PHSchedule>();
        for (PHSchedule timer : values) {
            if (areReccurring && timer.getTimer() != 0 && timer.getRecurringTimerInterval() != 0) {
                timersList.add(timer);
                continue;
            }
            if (areReccurring || timer.getTimer() == 0 || timer.getRecurringTimerInterval() != 0) continue;
            timersList.add(timer);
        }
        return timersList;
    }

    @Override
    public Map<String, PHSensor> getSensors() {
        return this.sensors;
    }

    @Override
    public List<PHSensor> getAllSensors() {
        ArrayList<PHSensor> sensorList = new ArrayList<PHSensor>();
        for (PHSensor sensor : this.sensors.values()) {
            sensorList.add(sensor);
        }
        return sensorList;
    }

    @Override
    public Map<String, PHRule> getRules() {
        return this.rules;
    }

    public void setRules(Map<String, PHRule> rules) {
        this.rules = rules;
    }

    @Override
    public List<PHRule> getAllRules() {
        ArrayList<PHRule> rulesList = new ArrayList<PHRule>();
        for (PHRule rule : this.rules.values()) {
            rulesList.add(rule);
        }
        return rulesList;
    }
}

