/*
 * Decompiled with CFR 0.152.
 */
package ru.org.amip.ambisync.web;

import com.philips.lighting.hue.sdk.PHAccessPoint;
import com.philips.lighting.hue.sdk.PHHueSDK;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.org.amip.ambisync.AmbiSync;
import ru.org.amip.ambisync.Controller;
import ru.org.amip.ambisync.Main;
import ru.org.amip.ambisync.Version;
import ru.org.amip.ambisync.config.Command;
import ru.org.amip.ambisync.config.CommandPreset;
import ru.org.amip.ambisync.config.Preset;
import spark.Filter;
import spark.Request;
import spark.Response;
import spark.Route;
import spark.Spark;
import spark.servlet.SparkApplication;

public class AmbiWeb
implements SparkApplication {
    private static final Logger logger = LoggerFactory.getLogger(AmbiWeb.class);
    private AmbiSync sync = AmbiSync.getInstance();
    private Controller controller = Controller.getInstance();

    private String getStatus() {
        return this.sync.isRunning() ? "1" : "0";
    }

    public void init() {
        logger.trace("Spark init");
        Spark.setPort((int)Main.conf.getInt("web.port"));
        Spark.setIpAddress((String)Main.conf.getString("web.ip"));
        AmbiWeb.enableCORS("*", "GET", "*");
        Spark.after((Filter)new Filter(){

            public void handle(Request request, Response response) {
                response.header("Content-type", "text/plain");
            }
        });
        Spark.get((Route)new Route("/"){

            public Object handle(Request request, Response response) {
                return String.format("AmbiSync v%s (built: %s)\nStatus: %s", Version.getVersion(), Version.getTimeStamp(), AmbiWeb.this.getStatus());
            }
        });
        Spark.get((Route)new Route("/status"){

            public Object handle(Request request, Response response) {
                return AmbiWeb.this.sync.isRunning() ? "1" : "0";
            }
        });
        Spark.get((Route)new Route("/stop"){

            public Object handle(Request request, Response response) {
                AmbiWeb.this.stopSync();
                return AmbiWeb.this.getStatus();
            }
        });
        Spark.get((Route)new Route("/start"){

            public Object handle(Request request, Response response) {
                AmbiWeb.this.startSync();
                return AmbiWeb.this.getStatus();
            }
        });
        Spark.get((Route)new Route("/toggle"){

            public Object handle(Request request, Response response) {
                if (AmbiWeb.this.sync.isRunning()) {
                    AmbiWeb.this.stopSync();
                } else {
                    AmbiWeb.this.startSync();
                }
                return AmbiWeb.this.getStatus();
            }
        });
        Spark.get((Route)new Route("/sync-preset/load/:config"){

            public Object handle(Request request, Response response) {
                String config = request.params(":config");
                AmbiWeb.this.sync.setLampsConfig(config);
                return config;
            }
        });
        Spark.get((Route)new Route("/on"){

            public Object handle(Request request, Response response) {
                AmbiWeb.this.sync.setLampsState(true);
                AmbiWeb.this.sync.restoreLampsState();
                return "on";
            }
        });
        Spark.get((Route)new Route("/off"){

            public Object handle(Request request, Response response) {
                AmbiWeb.this.sync.saveLampsState();
                AmbiWeb.this.sync.setLampsState(false);
                return "off";
            }
        });
        Spark.get((Route)new Route("/state/save"){

            public Object handle(Request request, Response response) {
                AmbiWeb.this.sync.saveLampsState();
                return "save";
            }
        });
        Spark.get((Route)new Route("/state/load"){

            public Object handle(Request request, Response response) {
                AmbiWeb.this.sync.restoreLampsState();
                return "load";
            }
        });
        Spark.get((Route)new Route("/preset"){

            public Object handle(Request request, Response response) {
                String preset = Preset.getInstance().getLastPreset();
                return preset == null ? "null" : preset;
            }
        });
        Spark.get((Route)new Route("/preset/list"){

            public Object handle(Request request, Response response) {
                StringBuilder sb = new StringBuilder();
                ArrayList<String> all = Preset.getInstance().getAll();
                for (String s : all) {
                    sb.append(s);
                    sb.append("\n");
                }
                return sb.toString().trim();
            }
        });
        Spark.get((Route)new Route("/preset/load/:name"){

            public Object handle(Request request, Response response) {
                String name = request.params(":name");
                if (name != null && !name.isEmpty() && Preset.getInstance().load(name)) {
                    return name;
                }
                return "error";
            }
        });
        Spark.get((Route)new Route("/preset/load/:name/:delay"){

            public Object handle(Request request, Response response) {
                String name = request.params(":name");
                long delay = Long.parseLong(request.params(":delay"));
                if (name != null && !name.isEmpty()) {
                    Preset.getInstance().load(name, delay);
                    return name + " in " + delay;
                }
                return "error";
            }
        });
        Spark.get((Route)new Route("/preset/save/:name"){

            public Object handle(Request request, Response response) {
                String name = request.params(":name");
                if (name != null && !name.isEmpty() && Preset.getInstance().save(name)) {
                    return String.format("Saved preset: '%s'", name);
                }
                return String.format("Error saving preset: %s", name);
            }
        });
        Spark.get((Route)new Route("/bridge"){

            public Object handle(Request request, Response response) {
                List<PHAccessPoint> bridges = AmbiWeb.this.controller.getBridges();
                if (bridges.size() == 0) {
                    AmbiWeb.this.controller.findBridges();
                    return "No bridges found, refresh this page to search again";
                }
                StringBuilder sb = new StringBuilder();
                for (PHAccessPoint bridge : bridges) {
                    sb.append(bridge.getIpAddress());
                    sb.append(" [");
                    sb.append(bridge.getMacAddress());
                    sb.append("]\n");
                }
                return sb.toString();
            }
        });
        Spark.get((Route)new Route("/bridge/connect/:ip"){

            public Object handle(Request request, Response response) {
                String ip = request.params(":ip");
                return AmbiWeb.this.connectToBridge(ip);
            }
        });
        Spark.get((Route)new Route("/bridge/connect"){

            public Object handle(Request request, Response response) {
                return AmbiWeb.this.connectToBridge(null);
            }
        });
        Spark.get((Route)new Route("/cc/:trigger"){

            public Object handle(Request request, Response response) {
                String trigger = request.params(":trigger");
                if (trigger != null && !trigger.isEmpty() && Command.getInstance().handleCommand(trigger, AmbiWeb.this.getQueryParamsMap(request))) {
                    return trigger;
                }
                return "error";
            }
        });
        Spark.get((Route)new Route("/cc-ctrl/reload"){

            public Object handle(Request request, Response response) {
                return Command.getInstance().loadPresets();
            }
        });
        Spark.get((Route)new Route("/cc-ctrl/list"){

            public Object handle(Request request, Response response) {
                StringBuilder sb = new StringBuilder();
                HashMap<String, CommandPreset> presets = Command.getInstance().getPresets();
                for (Map.Entry<String, CommandPreset> entry : presets.entrySet()) {
                    sb.append(entry.getKey());
                    sb.append(": ");
                    sb.append(entry.getValue().description);
                    sb.append("\n");
                }
                return sb.toString();
            }
        });
    }

    private static void enableCORS(final String origin, final String methods, final String headers) {
        Spark.options((Route)new Route("/*"){

            public Object handle(Request request, Response response) {
                String accessControlRequestMethod;
                String accessControlRequestHeaders = request.headers("Access-Control-Request-Headers");
                if (accessControlRequestHeaders != null) {
                    response.header("Access-Control-Allow-Headers", accessControlRequestHeaders);
                }
                if ((accessControlRequestMethod = request.headers("Access-Control-Request-Method")) != null) {
                    response.header("Access-Control-Allow-Methods", accessControlRequestMethod);
                }
                return "OK";
            }
        });
        Spark.before((Filter)new Filter(){

            public void handle(Request request, Response response) {
                response.header("Access-Control-Allow-Origin", origin);
                response.header("Access-Control-Request-Method", methods);
                response.header("Access-Control-Allow-Headers", headers);
            }
        });
    }

    private Map<String, String> getQueryParamsMap(Request request) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : request.queryParams()) {
            map.put(param, request.queryParams(param));
        }
        return map;
    }

    private void startSync() {
        this.controller.setSyncEnabled(true);
        this.sync.startSync(false);
    }

    private void stopSync() {
        this.controller.setSyncEnabled(false);
        this.sync.stopSync(false);
    }

    private Object connectToBridge(String ip) {
        List<PHAccessPoint> bridges = this.controller.getBridges();
        if (bridges.size() == 0) {
            this.controller.findBridges();
            return "No bridges found, refresh this page to search again";
        }
        for (PHAccessPoint bridge : bridges) {
            if (ip != null && !ip.equalsIgnoreCase(bridge.getIpAddress())) continue;
            bridge.setUsername(Main.conf.getString("bridge.username"));
            PHHueSDK.getInstance().connect(bridge);
            return String.format("Press button on the bridge '%s [%s]' within 30 seconds, refresh this page and try again if it doesn't work", bridge.getIpAddress(), bridge.getMacAddress());
        }
        return "Can't find bridge with ip: " + ip;
    }
}

