/*
 * Decompiled with CFR 0.152.
 */
package ru.org.amip.ambisync.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.philips.lighting.hue.listener.PHLightListener;
import com.philips.lighting.hue.sdk.PHHueSDK;
import com.philips.lighting.model.PHBridge;
import com.philips.lighting.model.PHBridgeResource;
import com.philips.lighting.model.PHBridgeResourcesCache;
import com.philips.lighting.model.PHHueError;
import com.philips.lighting.model.PHLight;
import com.philips.lighting.model.PHLightState;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.org.amip.ambisync.AmbiSync;
import ru.org.amip.ambisync.Controller;
import ru.org.amip.ambisync.Main;
import ru.org.amip.ambisync.config.LampPreset;

public class Preset {
    private static Preset ourInstance = new Preset();
    private static final Logger logger = LoggerFactory.getLogger(Preset.class);
    public static final String PRESETS_FOLDER = "../conf/presets/";
    private volatile Timer delayTimer;
    private String lastPreset = null;
    private Map<String, PHLight> lightStates = new HashMap<String, PHLight>();

    public static Preset getInstance() {
        return ourInstance;
    }

    private Preset() {
        this.lastPreset = Main.conf.getString("last.preset", null);
    }

    public String getLastPreset() {
        return this.lastPreset;
    }

    public ArrayList<String> getAll() {
        ArrayList<String> presets = new ArrayList<String>();
        File[] files = new File(PRESETS_FOLDER).listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile() || !file.getName().endsWith(".json")) continue;
                presets.add(file.getName().replace(".json", ""));
            }
        }
        return presets;
    }

    public void load(final String name, long delay) {
        if (this.delayTimer != null) {
            this.delayTimer.cancel();
        }
        this.delayTimer = new Timer();
        this.delayTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                Preset.this.load(name);
            }
        }, delay);
        logger.info("Preset '{}' will be applied in {}ms", (Object)name, (Object)delay);
    }

    public boolean load(String name) {
        if (AmbiSync.getInstance().isRunning()) {
            logger.info("Ambilight synchronization is in progress, preset '{}' is not applied", (Object)name);
            return false;
        }
        logger.info("Applying preset: '{}'", (Object)name);
        if (this.delayTimer != null) {
            this.delayTimer.cancel();
        }
        Gson gson = new Gson();
        try {
            LampPreset[] lamps;
            PHHueSDK phHueSDK = PHHueSDK.getInstance();
            PHBridge bridge = phHueSDK.getSelectedBridge();
            if (bridge == null) {
                return false;
            }
            for (final LampPreset lamp : lamps = (LampPreset[])gson.fromJson((Reader)new FileReader(PRESETS_FOLDER + name + ".json"), LampPreset[].class)) {
                if (lamp == null) {
                    logger.warn("Skipping invalid lamp in preset");
                    continue;
                }
                logger.trace("{}", (Object)lamp);
                PHLightState lightState = new PHLightState();
                if (lamp.colormode != null) {
                    PHLight.PHLightColorMode cm = PHLight.PHLightColorMode.COLORMODE_UNKNOWN;
                    switch (lamp.colormode) {
                        case "ct": {
                            cm = PHLight.PHLightColorMode.COLORMODE_CT;
                            break;
                        }
                        case "hs": {
                            cm = PHLight.PHLightColorMode.COLORMODE_HUE_SATURATION;
                            break;
                        }
                        case "xy": {
                            cm = PHLight.PHLightColorMode.COLORMODE_XY;
                        }
                    }
                    lightState.setColorMode(cm);
                }
                lightState.setOn(Boolean.valueOf(lamp.on));
                if (lamp.bri != -1) {
                    lightState.setBrightness(Integer.valueOf(lamp.bri));
                }
                if (lamp.sat != -1) {
                    lightState.setSaturation(Integer.valueOf(lamp.sat));
                }
                if (lamp.hue != -1) {
                    lightState.setHue(Integer.valueOf(lamp.hue));
                }
                if (lamp.ct != -1) {
                    lightState.setCt(Integer.valueOf(lamp.ct));
                }
                if (lamp.xy != null) {
                    lightState.setX(Float.valueOf(lamp.xy[0]));
                    lightState.setY(Float.valueOf(lamp.xy[1]));
                }
                PHLightListener listener = new PHLightListener(){

                    public void onReceivingLightDetails(PHLight light) {
                    }

                    public void onReceivingLights(List<PHBridgeResource> list) {
                    }

                    public void onSearchComplete() {
                    }

                    public void onSuccess() {
                    }

                    public void onError(int i, String s) {
                        logger.warn("Lamp {} update failed: {}", (Object)lamp.id, (Object)s);
                    }

                    public void onStateUpdate(Map<String, String> map, List<PHHueError> list) {
                    }
                };
                bridge.updateLightState(lamp.id, lightState, listener);
                Controller.delay();
            }
            this.lastPreset = name;
            Main.conf.setProperty("last.preset", (Object)this.lastPreset);
            Main.saveConfig();
            return true;
        }
        catch (FileNotFoundException e) {
            logger.error("Preset '{}' doesn't exist", (Object)name);
            return false;
        }
    }

    public boolean save(String name) {
        PHHueSDK phHueSDK = PHHueSDK.getInstance();
        PHBridge bridge = phHueSDK.getSelectedBridge();
        if (bridge == null) {
            return false;
        }
        PHBridgeResourcesCache cache = bridge.getResourceCache();
        List allLights = cache.getAllLights();
        LampPreset[] lamps = new LampPreset[allLights.size()];
        int idx = 0;
        for (PHLight light : allLights) {
            PHLightState state = new PHLightState(light.getLastKnownLightState());
            LampPreset lamp = new LampPreset();
            lamp.id = light.getIdentifier();
            if (state.getColorMode() == null) {
                logger.warn("Lamp {} color mode is null", (Object)lamp.id);
                lamp.colormode = null;
            } else {
                switch (state.getColorMode()) {
                    case COLORMODE_UNKNOWN: {
                        lamp.colormode = null;
                        break;
                    }
                    case COLORMODE_NONE: {
                        lamp.colormode = null;
                        break;
                    }
                    case COLORMODE_CT: {
                        lamp.colormode = "ct";
                        break;
                    }
                    case COLORMODE_HUE_SATURATION: {
                        lamp.colormode = "hs";
                        break;
                    }
                    case COLORMODE_XY: {
                        lamp.colormode = "xy";
                    }
                }
            }
            lamp.on = state.isOn();
            lamp.bri = state.getBrightness();
            lamp.sat = state.getSaturation();
            lamp.hue = state.getHue();
            lamp.ct = state.getCt();
            lamp.xy = new float[2];
            lamp.xy[0] = state.getX().floatValue();
            lamp.xy[1] = state.getY().floatValue();
            lamps[idx] = lamp;
            ++idx;
        }
        if (lamps.length > 0) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson((Object)lamps);
            logger.info("Saving '{}' preset", (Object)name);
            logger.trace(json);
            try {
                PrintWriter out = new PrintWriter(PRESETS_FOLDER + name + ".json");
                out.print(json);
                out.close();
                return true;
            }
            catch (FileNotFoundException e) {
                logger.error("Can't save preset '{}': {}", (Object)name, (Object)e.getMessage());
            }
        }
        return false;
    }

    private void lampStateWatchdog() {
        if (AmbiSync.getInstance().isRunning()) {
            return;
        }
        logger.warn("watchdog");
        PHHueSDK phHueSDK = PHHueSDK.getInstance();
        PHBridge bridge = phHueSDK.getSelectedBridge();
        PHBridgeResourcesCache cache = bridge.getResourceCache();
        List allLights = cache.getAllLights();
        for (PHLight light : allLights) {
            String preset;
            PHLight previousState = this.lightStates.get(light.getIdentifier());
            if (light.getLastKnownLightState().isReachable().booleanValue() && previousState != null && !previousState.getLastKnownLightState().isReachable().booleanValue() && (preset = Preset.getInstance().getLastPreset()) != null) {
                logger.warn("Lamp {} was turned off and now is back on, restoring last preset '{}'", (Object)light.getIdentifier(), (Object)preset);
                Preset.getInstance().load(preset);
            }
            this.lightStates.put(light.getIdentifier(), new PHLight(light));
            if (light.getLastKnownLightState().isReachable().booleanValue()) continue;
            logger.warn("Lamp {} is no longer reachable", (Object)light.getIdentifier());
        }
    }
}

