/*
 * Decompiled with CFR 0.152.
 */
package ru.org.amip.ambisync.config;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.util.StringUtils;
import org.apache.http.client.fluent.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.org.amip.ambisync.config.CommandPreset;

public class Command {
    private static final Logger logger = LoggerFactory.getLogger(Command.class);
    private static Command ourInstance = new Command();
    public static final String PRESETS_FOLDER = "../conf/cc-presets/";
    private HashMap<String, CommandPreset> presets = new HashMap();

    public static Command getInstance() {
        return ourInstance;
    }

    private Command() {
        this.loadPresets();
    }

    public HashMap<String, CommandPreset> getPresets() {
        return this.presets;
    }

    public boolean handleCommand(String trigger, Map<String, String> params) {
        if (!this.presets.containsKey(trigger)) {
            logger.warn("Command preset with '{}' trigger not found", (Object)trigger);
            return false;
        }
        CommandPreset cmd = this.presets.get(trigger);
        switch (cmd.type) {
            case "exec": {
                this.handleExec(cmd, params);
                break;
            }
            case "http": {
                this.handleGet(cmd, params);
                break;
            }
            default: {
                logger.warn("Unknown command type: {}", (Object)cmd.type);
                return false;
            }
        }
        return true;
    }

    private void handleGet(CommandPreset cmd, Map<String, String> params) {
        try {
            String request = StringUtils.stringSubstitution((String)cmd.command, params, (boolean)true).toString();
            Request.Get((String)request).connectTimeout(5000).socketTimeout(5000).execute();
            logger.info("'{}' http trigger handled ({})", (Object)cmd.trigger, (Object)cmd.command);
        }
        catch (IOException e) {
            logger.warn("HTTP request ({}) for trigger '{}' has failed", new Object[]{cmd.command, cmd.trigger, e});
        }
    }

    private void handleExec(CommandPreset cmd, Map<String, String> params) {
        CommandLine cmdLine = new CommandLine(cmd.command);
        cmdLine.setSubstitutionMap(params);
        if (cmd.args != null) {
            for (String arg : cmd.args) {
                cmdLine.addArgument(arg);
            }
        }
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        ExecuteWatchdog watchdog = new ExecuteWatchdog(60000L);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setExitValue(1);
        if (cmd.workdir == null) {
            executor.setWorkingDirectory(new File(cmd.command).getParentFile());
        } else {
            executor.setWorkingDirectory(new File(cmd.workdir));
        }
        executor.setWatchdog(watchdog);
        try {
            executor.execute(cmdLine, (ExecuteResultHandler)resultHandler);
            logger.info("'{}' exec trigger handled ({})", (Object)cmd.trigger, (Object)cmd.command);
        }
        catch (IOException e) {
            logger.warn("Command '{}' execution failed for '{}' trigger", new Object[]{cmd.command, cmd.trigger, e});
        }
    }

    public int loadPresets() {
        Gson gson = new Gson();
        this.presets.clear();
        File[] files = new File(PRESETS_FOLDER).listFiles();
        int total = 0;
        if (files != null) {
            for (File file : files) {
                if (!file.isFile() || !file.getName().endsWith(".json")) continue;
                try {
                    CommandPreset cmd = (CommandPreset)gson.fromJson((Reader)new FileReader(PRESETS_FOLDER + file.getName()), CommandPreset.class);
                    if (cmd.trigger != null && cmd.command != null) {
                        if (this.presets.containsKey(cmd.trigger)) {
                            logger.warn("Duplicate trigger {} detected in command preset {}", (Object)cmd.trigger, (Object)file.getName());
                        }
                        this.presets.put(cmd.trigger, cmd);
                        ++total;
                        if (cmd.aliases == null) continue;
                        for (String alias : cmd.aliases) {
                            if (this.presets.containsKey(alias)) {
                                logger.warn("Duplicate trigger alias {} detected in command preset {}", (Object)alias, (Object)file.getName());
                            }
                            this.presets.put(alias, cmd);
                        }
                        continue;
                    }
                    logger.warn("Preset in {} doesn't have a trigger or command defined", (Object)file.getName());
                }
                catch (JsonIOException | JsonSyntaxException | FileNotFoundException e) {
                    logger.error("Failed to load command preset {}", (Object)file.getName(), (Object)e);
                }
            }
        }
        if (!this.presets.isEmpty()) {
            logger.info("Loaded {} command presets!", (Object)total);
        }
        return total;
    }
}

