/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.heartbeat;

import com.philips.lighting.hue.sdk.exception.PHHueInvalidAPIException;
import com.philips.lighting.hue.sdk.fbp.PHBridgeVersionManager;
import com.philips.lighting.hue.sdk.heartbeat.PHHeartbeatProcessor;
import com.philips.lighting.model.PHBridge;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;

public class PHHeartbeatTimer
extends Timer {
    private HashMap<PHBridge, ArrayList<PHHeartbeatProcessor>> heartbeatMap = new HashMap();

    public void startHeartbeat(PHBridge bridge, long intervalMS, PHHeartbeatProcessor.PHHeartbeatType heartbeatType) {
        if (intervalMS < 100L && heartbeatType != PHHeartbeatProcessor.PHHeartbeatType.FULL_CONFIG || intervalMS < 1000L && heartbeatType == PHHeartbeatProcessor.PHHeartbeatType.FULL_CONFIG) {
            throw new IllegalArgumentException("Heartbeat timer should be atleast 1000ms");
        }
        if (bridge == null || heartbeatType == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        PHBridgeVersionManager bvm = PHBridgeVersionManager.getInstance();
        if (heartbeatType == PHHeartbeatProcessor.PHHeartbeatType.CONFIG ? bvm.getBridgeConfigurationSerializer() == null : (heartbeatType == PHHeartbeatProcessor.PHHeartbeatType.GROUPS ? bvm.getGroupSerializer() == null : (heartbeatType == PHHeartbeatProcessor.PHHeartbeatType.LIGHTS ? bvm.getLightSerializer() == null : (heartbeatType == PHHeartbeatProcessor.PHHeartbeatType.SCENES ? bvm.getScenesSerializer() == null : (heartbeatType == PHHeartbeatProcessor.PHHeartbeatType.SCHEDULES ? bvm.getSchedulesSerializer() == null : (heartbeatType == PHHeartbeatProcessor.PHHeartbeatType.SENSORS ? bvm.getSensorSerializer() == null : heartbeatType == PHHeartbeatProcessor.PHHeartbeatType.RULES && bvm.getRulesSerializer() == null)))))) {
            throw new PHHueInvalidAPIException("Invalid API call for Portal");
        }
        this.stopHeartbeat(bridge, heartbeatType);
        ArrayList<PHHeartbeatProcessor> arrayList = this.heartbeatMap.get(bridge) != null ? this.heartbeatMap.get(bridge) : new ArrayList<PHHeartbeatProcessor>();
        PHHeartbeatProcessor hbProccesor = new PHHeartbeatProcessor(bridge, heartbeatType);
        this.scheduleTimerTask(hbProccesor, intervalMS);
        arrayList.add(hbProccesor);
        this.heartbeatMap.put(bridge, arrayList);
    }

    public void stopHeartbeat(PHBridge bridge, PHHeartbeatProcessor.PHHeartbeatType heartbeatType) {
        if (bridge != null || heartbeatType != null) {
            ArrayList<PHHeartbeatProcessor> arrayList = this.heartbeatMap.get(bridge);
            if (arrayList != null) {
                Iterator<PHHeartbeatProcessor> iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    PHHeartbeatProcessor hbProcessor = iterator.next();
                    if (hbProcessor.getType() != heartbeatType) continue;
                    hbProcessor.cancel();
                    iterator.remove();
                }
            }
            if (this.heartbeatMap.get(bridge) == null || this.heartbeatMap.get(bridge).isEmpty()) {
                this.heartbeatMap.remove(bridge);
            }
        }
    }

    private void scheduleTimerTask(PHHeartbeatProcessor hbProcessor, long intervalMS) {
        this.schedule((TimerTask)hbProcessor, 0L, intervalMS);
    }

    public boolean isHeartbeating(PHBridge bridge) {
        if (bridge != null) {
            return this.heartbeatMap.containsKey(bridge);
        }
        return false;
    }

    public void stopAllHeartbeat(PHBridge bridge) {
        if (bridge != null) {
            PHHeartbeatProcessor.PHHeartbeatType[] values;
            for (PHHeartbeatProcessor.PHHeartbeatType hbt : values = PHHeartbeatProcessor.PHHeartbeatType.values()) {
                this.stopHeartbeat(bridge, hbt);
            }
        }
    }
}

