/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.heartbeat;

import com.philips.lighting.hue.sdk.clip.PHLightSerializer;
import com.philips.lighting.hue.sdk.clip.PHRuleSerializer;
import com.philips.lighting.hue.sdk.clip.PHSceneSerializer;
import com.philips.lighting.hue.sdk.clip.PHScheduleSerializer;
import com.philips.lighting.hue.sdk.clip.PHSensorSerializer;
import com.philips.lighting.hue.sdk.exception.PHHeartbeatException;
import com.philips.lighting.hue.sdk.fbp.PHBridgeVersionManager;
import com.philips.lighting.hue.sdk.heartbeat.PHHeartbeatProcessor;
import com.philips.lighting.hue.sdk.heartbeat.PHHeartbeatTimer;
import com.philips.lighting.hue.sdk.utilities.impl.PHHueHelper;
import com.philips.lighting.model.PHBridge;

public class PHHeartbeatManager {
    private static PHHeartbeatManager hbManager;
    private static PHHeartbeatTimer hbTimer;

    private PHHeartbeatManager() {
    }

    public static synchronized PHHeartbeatManager getInstance() {
        if (hbManager == null) {
            hbManager = new PHHeartbeatManager();
            hbTimer = new PHHeartbeatTimer();
        }
        return hbManager;
    }

    public void enableFullConfigHeartbeat(PHBridge bridge, long intervalMS) {
        hbTimer.startHeartbeat(bridge, intervalMS, PHHeartbeatProcessor.PHHeartbeatType.FULL_CONFIG);
    }

    public void disableFullConfigHeartbeat(PHBridge bridge) {
        hbTimer.stopHeartbeat(bridge, PHHeartbeatProcessor.PHHeartbeatType.FULL_CONFIG);
    }

    public void enableConfigHeartbeat(PHBridge bridge, long intervalMS) {
        this.checkAndStartMultiResourceHeartbeat(bridge, intervalMS, PHHeartbeatProcessor.PHHeartbeatType.CONFIG);
    }

    public void disableConfigHeartbeat(PHBridge bridge) {
        hbTimer.stopHeartbeat(bridge, PHHeartbeatProcessor.PHHeartbeatType.CONFIG);
    }

    public void enableLightsHeartbeat(PHBridge bridge, long intervalMS) {
        PHLightSerializer lightSerializer = PHBridgeVersionManager.getInstance().getLightSerializer();
        if (lightSerializer == null || !lightSerializer.canFetchAll()) {
            throw new PHHeartbeatException("Multi resource heartbeat is not supported on this bridge version");
        }
        this.checkAndStartMultiResourceHeartbeat(bridge, intervalMS, PHHeartbeatProcessor.PHHeartbeatType.LIGHTS);
    }

    public void disableLightsHeartbeat(PHBridge bridge) {
        hbTimer.stopHeartbeat(bridge, PHHeartbeatProcessor.PHHeartbeatType.LIGHTS);
    }

    public void enableScenesHeartbeat(PHBridge bridge, long intervalMS) {
        PHSceneSerializer scenesSerializer = PHBridgeVersionManager.getInstance().getScenesSerializer();
        if (scenesSerializer == null || !scenesSerializer.canFetchAll()) {
            throw new PHHeartbeatException("Multi resource heartbeat is not supported on this bridge version");
        }
        this.checkAndStartMultiResourceHeartbeat(bridge, intervalMS, PHHeartbeatProcessor.PHHeartbeatType.SCENES);
    }

    public void disableScenesHeartbeat(PHBridge bridge) {
        hbTimer.stopHeartbeat(bridge, PHHeartbeatProcessor.PHHeartbeatType.SCENES);
    }

    public void enableSchedulesHeartbeat(PHBridge bridge, long intervalMS) {
        PHScheduleSerializer schedulesSerializer = PHBridgeVersionManager.getInstance().getSchedulesSerializer();
        if (schedulesSerializer == null || !schedulesSerializer.canFetchAll()) {
            throw new PHHeartbeatException("Multi resource heartbeat is not supported on this bridge version");
        }
        this.checkAndStartMultiResourceHeartbeat(bridge, intervalMS, PHHeartbeatProcessor.PHHeartbeatType.SCHEDULES);
    }

    public void disableSchedulesHeartbeat(PHBridge bridge) {
        hbTimer.stopHeartbeat(bridge, PHHeartbeatProcessor.PHHeartbeatType.SCHEDULES);
    }

    public void enableSensorsHeartbeat(PHBridge bridge, long intervalMS) {
        PHSensorSerializer sensorSerializer = PHBridgeVersionManager.getInstance().getSensorSerializer();
        if (sensorSerializer == null || !sensorSerializer.canFetchAll()) {
            throw new PHHeartbeatException("Multi resource heartbeat is not supported on this bridge version");
        }
        this.checkAndStartMultiResourceHeartbeat(bridge, intervalMS, PHHeartbeatProcessor.PHHeartbeatType.SENSORS);
    }

    public void disableSensorsHeartbeat(PHBridge bridge) {
        hbTimer.stopHeartbeat(bridge, PHHeartbeatProcessor.PHHeartbeatType.SENSORS);
    }

    public void enableRulesHeartbeat(PHBridge bridge, long intervalMS) {
        PHRuleSerializer rulesSerializer = PHBridgeVersionManager.getInstance().getRulesSerializer();
        if (rulesSerializer == null || !rulesSerializer.canFetchAll()) {
            throw new PHHeartbeatException("Multi resource heartbeat is not supported on this bridge version");
        }
        this.checkAndStartMultiResourceHeartbeat(bridge, intervalMS, PHHeartbeatProcessor.PHHeartbeatType.RULES);
    }

    public void disableRulesHeartbeat(PHBridge bridge) {
        hbTimer.stopHeartbeat(bridge, PHHeartbeatProcessor.PHHeartbeatType.RULES);
    }

    public boolean isHeartBeating(PHBridge bridge) {
        return hbTimer.isHeartbeating(bridge);
    }

    public void disableAllHeartbeats(PHBridge bridge) {
        hbTimer.stopAllHeartbeat(bridge);
    }

    private void checkAndStartMultiResourceHeartbeat(PHBridge bridge, long intervalMS, PHHeartbeatProcessor.PHHeartbeatType heartbeatType) {
        if (bridge == null || bridge.getResourceCache() == null || bridge.getResourceCache().getBridgeConfiguration() == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        int bridgeVersion = Integer.parseInt(bridge.getResourceCache().getBridgeConfiguration().getSoftwareVersion());
        bridgeVersion = PHHueHelper.getBridgeVersion((int)bridgeVersion);
        hbTimer.startHeartbeat(bridge, intervalMS, heartbeatType);
    }

    public static void removeTimer() {
        hbTimer.cancel();
        hbManager = null;
        hbTimer = null;
    }
}

