/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.connection.impl;

import com.philips.lighting.hue.sdk.utilities.impl.PHLog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class PHHueHttpConnection {
    private static final String TAG = "PHHueHttpConnection";
    static final String GET = "GET";
    static final String DELETE = "DELETE";
    static final String PUT = "PUT";
    static final String POST = "POST";
    private int timeoutConnection = 8000;
    private HttpURLConnection connection;

    public void openConnection(String url, String method) throws MalformedURLException, IOException {
        PHLog.d((String)TAG, (String)("openConnection with URL:" + url));
        URL uri = new URL(url);
        this.connection = (HttpURLConnection)uri.openConnection();
        this.connection.setRequestMethod(method);
        this.connection.setConnectTimeout(this.timeoutConnection);
        this.connection.setReadTimeout(this.timeoutConnection);
    }

    public int getTimeoutConnection() {
        return this.timeoutConnection;
    }

    public void setTimeoutConnection(int timeoutConnection) {
        this.timeoutConnection = timeoutConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getData(String url) {
        BufferedReader in = null;
        String returnString = null;
        try {
            String line;
            this.openConnection(url, GET);
            if (this.connection == null) {
                String string = null;
                return string;
            }
            this.connection.connect();
            Object content = null;
            if (this.connection.getResponseCode() == 200) {
                content = this.connection.getContent();
            }
            if (content == null) {
                String e = null;
                return e;
            }
            in = new BufferedReader(new InputStreamReader((InputStream)content, "UTF8"));
            StringBuffer sb = new StringBuffer("");
            String newLine = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line);
                sb.append(newLine);
                if (in.ready()) continue;
            }
            in.close();
            returnString = sb.toString();
        }
        catch (Exception e) {
            if (PHLog.isLoggable()) {
                PHLog.e((String)TAG, (String)("GetData Exception: " + e));
            }
        }
        finally {
            block24: {
                if (in != null) {
                    try {
                        in.close();
                        this.connection.disconnect();
                    }
                    catch (IOException e) {
                        if (!PHLog.isLoggable()) break block24;
                        PHLog.e((String)TAG, (String)("GetData IOException: " + e));
                    }
                }
            }
        }
        PHLog.d((String)TAG, (String)("Bridge Response : " + returnString));
        return returnString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postData(String data, String url) {
        BufferedReader in = null;
        String returnString = null;
        try {
            String line;
            this.openConnection(url, POST);
            if (this.connection == null) {
                String string = null;
                return string;
            }
            PHLog.d((String)TAG, (String)("DATA : " + data));
            this.connection.setDoOutput(true);
            OutputStream outputStream = this.connection.getOutputStream();
            if (outputStream == null) {
                String e = null;
                return e;
            }
            OutputStreamWriter out = new OutputStreamWriter(outputStream, "UTF-8");
            out.write(data);
            out.flush();
            out.close();
            this.connection.connect();
            Object content = this.connection.getContent();
            if (content == null) {
                String string = null;
                return string;
            }
            in = new BufferedReader(new InputStreamReader((InputStream)content, "UTF-8"));
            StringBuffer sb = new StringBuffer("");
            String newLine = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line);
                sb.append(newLine);
                if (in.ready()) continue;
            }
            in.close();
            returnString = sb.toString();
        }
        catch (Exception e) {
            if (PHLog.isLoggable()) {
                PHLog.e((String)TAG, (String)("PostData Exception: " + e));
            }
        }
        finally {
            block27: {
                if (in != null) {
                    try {
                        in.close();
                        this.connection.disconnect();
                    }
                    catch (IOException e) {
                        if (!PHLog.isLoggable()) break block27;
                        PHLog.e((String)TAG, (String)("PostData IOException: " + e));
                    }
                }
            }
        }
        PHLog.d((String)TAG, (String)("Bridge Response : " + returnString));
        return returnString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deleteData(String url) {
        String str = null;
        BufferedReader in = null;
        try {
            String line;
            this.openConnection(url, DELETE);
            if (this.connection == null) {
                String string = null;
                return string;
            }
            this.connection.connect();
            Object content = this.connection.getContent();
            if (content == null) {
                String e = str;
                return e;
            }
            in = new BufferedReader(new InputStreamReader((InputStream)content, "UTF-8"));
            StringBuffer sb = new StringBuffer("");
            String newLine = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line);
                sb.append(newLine);
                if (in.ready()) continue;
            }
            in.close();
            str = sb.toString();
        }
        catch (Exception e) {
            if (PHLog.isLoggable()) {
                PHLog.e((String)TAG, (String)("DeleteData Exception: " + e));
            }
        }
        finally {
            block23: {
                if (in != null) {
                    try {
                        in.close();
                        this.connection.disconnect();
                    }
                    catch (IOException e) {
                        if (!PHLog.isLoggable()) break block23;
                        PHLog.e((String)TAG, (String)("DeleteData IOException: " + e));
                    }
                }
            }
        }
        PHLog.d((String)TAG, (String)("Bridge Response : " + str));
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String putData(String data, String url) {
        BufferedReader in = null;
        String returnString = null;
        try {
            String line;
            this.openConnection(url, PUT);
            if (this.connection == null) {
                String string = null;
                return string;
            }
            PHLog.d((String)TAG, (String)("DATA :  " + data));
            this.connection.setDoOutput(true);
            this.connection.connect();
            OutputStream outputStream = this.connection.getOutputStream();
            if (outputStream == null) {
                String e = null;
                return e;
            }
            OutputStreamWriter out = new OutputStreamWriter(outputStream, "UTF-8");
            out.write(data);
            out.close();
            Object content = this.connection.getContent();
            if (content == null) {
                String string = null;
                return string;
            }
            in = new BufferedReader(new InputStreamReader((InputStream)content, "UTF-8"));
            StringBuffer sb = new StringBuffer("");
            String newLine = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line);
                sb.append(newLine);
                if (in.ready()) continue;
            }
            in.close();
            returnString = sb.toString();
        }
        catch (Exception e) {
            if (PHLog.isLoggable()) {
                PHLog.e((String)TAG, (String)("PutData Exception: " + e));
            }
        }
        finally {
            block27: {
                if (in != null) {
                    try {
                        in.close();
                        this.connection.disconnect();
                    }
                    catch (IOException e) {
                        if (!PHLog.isLoggable()) break block27;
                        PHLog.e((String)TAG, (String)("PutData Exception: " + e));
                    }
                }
            }
        }
        PHLog.d((String)TAG, (String)("Bridge Response : " + returnString));
        return returnString;
    }
}

