/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.upnp;

import com.philips.lighting.hue.sdk.utilities.impl.PHLog;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class PHUpnpManager {
    private static final String TAG = "PHUpnpManager";
    private static final int DEFAULT_MX = 3;
    private static final int DEFAULT_TTL = 4;
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final int DEFAULT_SSDP_SEARCH_PORT = 1901;
    private static final String SSDP_IP = "239.255.255.250";
    private static final String STRING_ROOT_DEVICE = "upnp:rootdevice";
    private static final int PORT = 1900;
    private DatagramPacket input;
    private boolean isRunning = true;
    private boolean isThreadStopped = false;
    private List<String> recv = new ArrayList<String>();

    public List<String> startSearch() {
        block7: {
            try {
                this.receive();
                this.startUpnpSendMessage();
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    PHLog.e((String)TAG, (String)("InterruptedException: " + e));
                }
                this.isRunning = false;
                while (!this.isThreadStopped) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        PHLog.e((String)TAG, (String)("InterruptedException: " + e));
                    }
                }
                PHLog.d((String)TAG, (String)("Size of Bridge Search Response" + this.recv.size()));
            }
            catch (Exception e) {
                if (!PHLog.isLoggable()) break block7;
                PHLog.e((String)TAG, (String)("InterruptedException: " + e));
            }
        }
        return this.recv;
    }

    public void receive() throws IOException {
        int bindPort = 1901;
        final MulticastSocket skt = new MulticastSocket(null);
        skt.bind(new InetSocketAddress(InetAddress.getByName("0.0.0.0"), bindPort));
        skt.setTimeToLive(4);
        skt.setSoTimeout(5000);
        skt.joinGroup(InetAddress.getByName(SSDP_IP));
        byte[] buf = new byte[2048];
        this.input = new DatagramPacket(buf, buf.length);
        new Thread(){

            @Override
            public void run() {
                block8: {
                    while (PHUpnpManager.this.isRunning) {
                        PHLog.d((String)PHUpnpManager.TAG, (String)"Bridge Search is Running ..");
                        try {
                            skt.receive(PHUpnpManager.this.input);
                            String received = new String(PHUpnpManager.this.input.getData(), PHUpnpManager.this.input.getOffset(), PHUpnpManager.this.input.getLength());
                            PHUpnpManager.this.recv.add(received);
                            PHLog.d((String)PHUpnpManager.TAG, (String)("Search Response=" + received));
                        }
                        catch (SocketTimeoutException ex) {
                            if (!PHLog.isLoggable()) continue;
                            PHLog.e((String)PHUpnpManager.TAG, (String)("SocketTimeoutException: " + ex));
                        }
                        catch (IOException ioEx) {
                            if (!PHLog.isLoggable()) continue;
                            PHLog.e((String)PHUpnpManager.TAG, (String)("SocketTimeoutException: " + ioEx));
                        }
                        catch (Exception ex) {
                            if (PHLog.isLoggable()) {
                                PHLog.e((String)PHUpnpManager.TAG, (String)("SocketTimeoutException: " + ex));
                            }
                            PHUpnpManager.this.isRunning = false;
                            break;
                        }
                    }
                    try {
                        skt.leaveGroup(InetAddress.getByName(PHUpnpManager.SSDP_IP));
                        skt.close();
                    }
                    catch (Exception ex) {
                        if (!PHLog.isLoggable()) break block8;
                        PHLog.e((String)PHUpnpManager.TAG, (String)("SocketTimeoutException: " + ex));
                    }
                }
                PHUpnpManager.this.isThreadStopped = true;
            }
        }.start();
    }

    public void sendMessage(InetAddress src, int ttl, int mx, String searchTarget) throws IOException {
        InetSocketAddress adr = new InetSocketAddress(InetAddress.getByName(SSDP_IP), 1900);
        MulticastSocket skt = new MulticastSocket(null);
        skt.bind(new InetSocketAddress(src, 1901));
        skt.setTimeToLive(ttl);
        StringBuffer packet = new StringBuffer();
        packet.append("M-SEARCH * HTTP/1.1\r\n");
        packet.append("HOST: ").append(SSDP_IP).append(":").append(1900).append("\r\n");
        packet.append("ST: ").append(searchTarget).append("\r\n");
        packet.append("MAN: \"ssdp:discover\"\r\n");
        packet.append("MX: ").append(mx).append("\r\n").append("\r\n");
        PHLog.d((String)TAG, (String)("Discovery Request=239.255.255.250:1900multicast address from ip " + src.getHostAddress() + ":\n" + packet.toString()));
        String toSend = packet.toString();
        byte[] pk = toSend.getBytes();
        skt.send(new DatagramPacket(pk, pk.length, adr));
        skt.disconnect();
        skt.close();
    }

    public void startUpnpSendMessage() throws IOException {
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        while (e.hasMoreElements()) {
            NetworkInterface intf = e.nextElement();
            Enumeration<InetAddress> adrs = intf.getInetAddresses();
            while (adrs.hasMoreElements()) {
                InetAddress adr = adrs.nextElement();
                if (!(adr instanceof Inet4Address) || adr.isLoopbackAddress()) continue;
                this.sendMessage(adr, 4, 3, STRING_ROOT_DEVICE);
            }
        }
    }
}

