/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.upnp;

import com.philips.lighting.hue.sdk.PHAccessPoint;
import com.philips.lighting.hue.sdk.connection.impl.PHHueHttpConnection;
import com.philips.lighting.hue.sdk.util.PHDnsChecker;
import com.philips.lighting.hue.sdk.utilities.impl.PHHueHelper;
import com.philips.lighting.hue.sdk.utilities.impl.PHLog;
import java.util.ArrayList;
import java.util.List;
import org.json.hue.JSONArray;
import org.json.hue.JSONException;
import org.json.hue.JSONObject;

public class PHPortalSearchManager {
    private static final String TAG = PHPortalSearchManager.class.getSimpleName();
    private String portalAddress = "https://www.meethue.com";
    static final String PORTAL_NUPNP = "/api/nupnp";
    private int reachabilityTimeout = 2000;

    public List<PHAccessPoint> searchPortal() {
        ArrayList<PHAccessPoint> accessPoints = new ArrayList<PHAccessPoint>();
        if (!this.isPortalReachable()) {
            return accessPoints;
        }
        String jsonString = null;
        try {
            jsonString = this.getHttpConnection().getData(this.portalAddress + PORTAL_NUPNP);
        }
        catch (Exception e1) {
            return accessPoints;
        }
        if (jsonString != null && jsonString.length() > 0) {
            try {
                JSONArray jsonArray = new JSONArray(jsonString);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject jsonObject = jsonArray.optJSONObject(i);
                    if (jsonObject == null) continue;
                    String bridgeId = jsonObject.optString("id");
                    String internalIPaddress = jsonObject.optString("internalipaddress");
                    if (bridgeId == null || internalIPaddress == null || (bridgeId = bridgeId.replace(":", "")).length() == 0 || internalIPaddress.length() == 0) continue;
                    PHAccessPoint accessPoint = new PHAccessPoint();
                    accessPoint.setIpAddress(internalIPaddress);
                    accessPoint.setMacAddress(PHHueHelper.macAddressFromBridgeId((String)bridgeId.trim()));
                    accessPoint.setBridgeId(bridgeId);
                    if (accessPoints.contains(accessPoint)) continue;
                    accessPoints.add(accessPoint);
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return accessPoints;
    }

    public PHHueHttpConnection getHttpConnection() {
        return new PHHueHttpConnection();
    }

    public void setPortalAddress(String address) {
        this.portalAddress = address;
    }

    public String getPortalAddress() {
        return this.portalAddress;
    }

    private boolean isPortalReachable() {
        PHDnsChecker dnsRes = new PHDnsChecker(this.portalAddress.replaceFirst("https://", ""));
        Thread dnsCheckerThread = new Thread(dnsRes);
        dnsCheckerThread.start();
        try {
            dnsCheckerThread.join(this.reachabilityTimeout);
            return dnsRes.get() != null;
        }
        catch (InterruptedException e) {
            PHLog.e((String)TAG, (String)("isPortalReachable Exception: " + e.getMessage()));
            return false;
        }
    }

    public void setPortalReachabilityTimeout(int timeout) {
        this.reachabilityTimeout = timeout;
    }

    public int getPortalReachabilityTimeout() {
        return this.reachabilityTimeout;
    }
}

