/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.upnp;

import com.philips.lighting.hue.sdk.PHAccessPoint;
import com.philips.lighting.hue.sdk.upnp.IPAddressScanner;
import com.philips.lighting.hue.sdk.utilities.impl.PHLog;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class PHIpAddressSearchManager {
    public static final int START_IP_SCAN = 1;
    public static final int END_IP_SCAN = 255;

    public List<PHAccessPoint> startIpAddressSearch() {
        String baseIP;
        String hostIP = this.getHostIp();
        if (hostIP != null && !hostIP.isEmpty() && (baseIP = hostIP.substring(0, hostIP.lastIndexOf(46) + 1)) != null && !baseIP.isEmpty()) {
            ArrayList<String> ipScanList = new ArrayList<String>();
            for (int i = 1; i < 255; ++i) {
                ipScanList.add(baseIP + i);
            }
            return this.scanIpRange(ipScanList);
        }
        return new ArrayList<PHAccessPoint>();
    }

    public String getHostIp() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces == null) {
                return null;
            }
            while (interfaces.hasMoreElements()) {
                NetworkInterface iface = interfaces.nextElement();
                if (iface.isLoopback() || !iface.isUp() || iface.getDisplayName().contains("rmnet")) continue;
                Enumeration<InetAddress> addresses = iface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    if (!(addr instanceof Inet4Address)) continue;
                    return addr.getHostAddress();
                }
            }
            return null;
        }
        catch (SocketException e) {
            PHLog.e((String)PHIpAddressSearchManager.class.getSimpleName(), (String)e.getMessage());
            return null;
        }
    }

    public List<PHAccessPoint> scanIpRange(List<String> ipScanList) {
        ArrayList<PHAccessPoint> phAccessPointList = new ArrayList<PHAccessPoint>();
        ArrayList<Future<PHAccessPoint>> allResults = new ArrayList<Future<PHAccessPoint>>();
        Future<PHAccessPoint> result = null;
        ExecutorService execSrv = Executors.newFixedThreadPool(100);
        for (String string : ipScanList) {
            IPAddressScanner worker = this.getIPAddressScanner(string);
            result = execSrv.submit(worker);
            if (result == null) continue;
            allResults.add(result);
        }
        try {
            execSrv.shutdown();
            execSrv.awaitTermination(15L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e1) {
            // empty catch block
        }
        for (Future future : allResults) {
            try {
                if (future == null || future.get(10L, TimeUnit.MILLISECONDS) == null) {
                    future.cancel(true);
                    continue;
                }
                PHAccessPoint pap = new PHAccessPoint();
                pap.setIpAddress(((PHAccessPoint)future.get()).getIpAddress());
                pap.setMacAddress(((PHAccessPoint)future.get()).getMacAddress());
                pap.setBridgeId(((PHAccessPoint)future.get()).getBridgeId());
                pap.setUsername(((PHAccessPoint)future.get()).getUsername());
                phAccessPointList.add(pap);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {}
        }
        return phAccessPointList;
    }

    public IPAddressScanner getIPAddressScanner(String ip) {
        return new IPAddressScanner(ip);
    }
}

