/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.notification.impl;

import com.philips.lighting.hue.listener.PHBridgeAPIListener;
import com.philips.lighting.hue.listener.PHBridgeConfigurationListener;
import com.philips.lighting.hue.listener.PHGroupListener;
import com.philips.lighting.hue.listener.PHHTTPListener;
import com.philips.lighting.hue.listener.PHLightListener;
import com.philips.lighting.hue.listener.PHRuleListener;
import com.philips.lighting.hue.listener.PHSceneListener;
import com.philips.lighting.hue.listener.PHScheduleListener;
import com.philips.lighting.hue.listener.PHSensorListener;
import com.philips.lighting.hue.sdk.PHAccessPoint;
import com.philips.lighting.hue.sdk.PHHueSDK;
import com.philips.lighting.hue.sdk.PHNotificationManager;
import com.philips.lighting.hue.sdk.PHSDKListener;
import com.philips.lighting.hue.sdk.notification.impl.PHHandlerListener;
import com.philips.lighting.hue.sdk.notification.impl.PHHueResultReceiver;
import com.philips.lighting.model.PHBridge;
import com.philips.lighting.model.PHBridgeConfiguration;
import com.philips.lighting.model.PHBridgeResource;
import com.philips.lighting.model.PHGroup;
import com.philips.lighting.model.PHHueError;
import com.philips.lighting.model.PHHueParsingError;
import com.philips.lighting.model.PHLight;
import com.philips.lighting.model.PHScene;
import com.philips.lighting.model.PHSchedule;
import com.philips.lighting.model.rule.PHRule;
import com.philips.lighting.model.sensor.PHSensor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PHNotificationManagerImpl
extends PHNotificationManager {
    private List<PHSDKListener> localSDKListeners = new ArrayList<PHSDKListener>();
    private static PHNotificationManagerImpl notificationManager;
    private boolean searchPolling = true;

    public static synchronized PHNotificationManagerImpl getInstance() {
        if (notificationManager == null) {
            notificationManager = new PHNotificationManagerImpl();
        }
        return notificationManager;
    }

    private PHNotificationManagerImpl() {
    }

    @Override
    public void registerSDKListener(PHSDKListener listener) {
        if (listener != null) {
            this.localSDKListeners.add(listener);
        }
    }

    @Override
    public void unregisterSDKListener(PHSDKListener listener) {
        if (listener != null) {
            this.localSDKListeners.remove(listener);
        }
    }

    public static PHNotificationManagerImpl getNotificationManager() {
        return notificationManager;
    }

    @Override
    public void cancelSearchNotification() {
        this.searchPolling = false;
    }

    public boolean isSearchRunning() {
        return this.searchPolling;
    }

    public void startSearchNotification() {
        this.searchPolling = true;
    }

    public static void cleanNotificationManager() {
        notificationManager = null;
    }

    public void notifySDKError(final int code, final String message) {
        PHHueResultReceiver receiver = new PHHueResultReceiver(new PHHandlerListener(){

            @Override
            public void onReceived() {
                for (PHSDKListener listener : PHNotificationManagerImpl.this.localSDKListeners) {
                    if (listener == null) continue;
                    listener.onError(code, message);
                }
            }
        });
        receiver.execute(null);
    }

    public void notifyParsingError(final List<PHHueParsingError> parsingErrors) {
        PHHueResultReceiver receiver = new PHHueResultReceiver(new PHHandlerListener(){

            @Override
            public void onReceived() {
                for (PHSDKListener listener : PHNotificationManagerImpl.this.localSDKListeners) {
                    if (listener == null) continue;
                    listener.onParsingErrors(parsingErrors);
                }
            }
        });
        receiver.execute(null);
    }

    public void notifyBridgeSearchResult(final List<PHAccessPoint> accessPoints) {
        PHHueResultReceiver receiver = new PHHueResultReceiver(new PHHandlerListener(){

            @Override
            public void onReceived() {
                for (PHSDKListener listener : PHNotificationManagerImpl.this.localSDKListeners) {
                    if (listener == null) continue;
                    listener.onAccessPointsFound(accessPoints);
                }
            }
        });
        receiver.execute(null);
    }

    public void notifyBridgeAuthentication(final PHAccessPoint accessPoint) {
        PHHueResultReceiver receiver = new PHHueResultReceiver(new PHHandlerListener(){

            @Override
            public void onReceived() {
                for (PHSDKListener listener : PHNotificationManagerImpl.this.localSDKListeners) {
                    if (listener == null) continue;
                    listener.onAuthenticationRequired(accessPoint);
                }
            }
        });
        receiver.execute(null);
    }

    public void notifyBridgeConnected(final PHBridge bridge, final String username) {
        if (PHHueSDK.getInstance() != null && bridge != null) {
            PHHueSDK.getInstance().setSelectedBridge(bridge);
        }
        PHHueResultReceiver receiver = new PHHueResultReceiver(new PHHandlerListener(){

            @Override
            public void onReceived() {
                for (PHSDKListener listener : PHNotificationManagerImpl.this.localSDKListeners) {
                    if (listener == null) continue;
                    listener.onBridgeConnected(bridge, username);
                }
            }
        });
        receiver.execute(null);
    }

    public void notifyCacheUpdated(int phmessageType, PHBridge bridge) {
        ArrayList<Integer> cacheNotificationsList = new ArrayList<Integer>();
        cacheNotificationsList.add(phmessageType);
        this.notifyCacheUpdated(cacheNotificationsList, bridge);
    }

    public void notifyCacheUpdated(final List<Integer> cacheNotificationsList, final PHBridge bridge) {
        PHHueResultReceiver receiver = new PHHueResultReceiver(new PHHandlerListener(){

            @Override
            public void onReceived() {
                for (PHSDKListener listener : PHNotificationManagerImpl.this.localSDKListeners) {
                    if (listener == null) continue;
                    listener.onCacheUpdated(cacheNotificationsList, bridge);
                }
            }
        });
        receiver.execute(null);
    }

    public void notifyConnectionLost(final PHAccessPoint accessPoint) {
        PHHueResultReceiver receiver = new PHHueResultReceiver(new PHHandlerListener(){

            @Override
            public void onReceived() {
                for (PHSDKListener listener : PHNotificationManagerImpl.this.localSDKListeners) {
                    if (listener == null) continue;
                    listener.onConnectionLost(accessPoint);
                }
            }
        });
        receiver.execute(null);
    }

    public void notifyConnectionResumed(final PHBridge bridge) {
        PHHueResultReceiver receiver = new PHHueResultReceiver(new PHHandlerListener(){

            @Override
            public void onReceived() {
                for (PHSDKListener listener : PHNotificationManagerImpl.this.localSDKListeners) {
                    if (listener == null) continue;
                    listener.onConnectionResumed(bridge);
                }
            }
        });
        receiver.execute(null);
    }

    public void notifyGroupCreated(final PHGroupListener listener, final PHGroup group) {
        PHHueResultReceiver receiver = new PHHueResultReceiver(new PHHandlerListener(){

            @Override
            public void onReceived() {
                listener.onCreated(group);
            }
        });
        receiver.execute(null);
    }

    public void notifyGroupDetails(final PHGroupListener listener, final PHGroup group) {
        if (listener == null) {
            return;
        }
        PHHueResultReceiver receiver = new PHHueResultReceiver(new PHHandlerListener(){

            @Override
            public void onReceived() {
                listener.onReceivingGroupDetails(group);
            }
        });
        receiver.execute(null);
    }

    public void notifyAllGroupDetails(final PHGroupListener listener, final List<PHBridgeResource> groupHeaders) {
        if (listener == null) {
            return;
        }
        PHHueResultReceiver receiver = new PHHueResultReceiver(new PHHandlerListener(){

            @Override
            public void onReceived() {
                listener.onReceivingAllGroups(groupHeaders);
            }
        });
        receiver.execute(null);
    }

    public void notifyLightDetails(final PHLightListener listener, final PHLight foundLight) {
        if (listener == null) {
            return;
        }
        PHHueResultReceiver receiver = new PHHueResultReceiver(new PHHandlerListener(){

            @Override
            public void onReceived() {
                listener.onReceivingLightDetails(foundLight);
            }
        });
        receiver.execute(null);
    }

    public void notifyLightHeaders(final PHLightListener listener, final List<PHBridgeResource> lightHeaders, final boolean isSearchCompete) {
        if (listener == null) {
            return;
        }
        PHHueResultReceiver receiver = new PHHueResultReceiver(new PHHandlerListener(){

            @Override
            public void onReceived() {
                listener.onReceivingLights(lightHeaders);
                if (isSearchCompete) {
                    listener.onSearchComplete();
                }
            }
        });
        receiver.execute(null);
    }

    public void notifyScheduleCreated(final PHScheduleListener listener, final PHSchedule schedule) {
        if (listener == null) {
            return;
        }
        PHHueResultReceiver receiver = new PHHueResultReceiver(new PHHandlerListener(){

            @Override
            public void onReceived() {
                listener.onCreated(schedule);
            }
        });
        receiver.execute(null);
    }

    public void notifyBridgeConfigReceived(final PHBridgeConfigurationListener listner, final PHBridgeConfiguration config) {
        if (listner == null) {
            return;
        }
        PHHueResultReceiver receiver = new PHHueResultReceiver(new PHHandlerListener(){

            @Override
            public void onReceived() {
                if (listner != null) {
                    listner.onReceivingConfiguration(config);
                }
            }
        });
        receiver.execute(null);
    }

    public void notifyBridgeAPIStateUpdate(final PHBridgeAPIListener listener, final Map<String, String> successResponse, final List<PHHueError> errorResponse) {
        if (listener == null) {
            return;
        }
        PHHueResultReceiver receiver = new PHHueResultReceiver(new PHHandlerListener(){

            @Override
            public void onReceived() {
                if (listener != null) {
                    listener.onStateUpdate(successResponse, errorResponse);
                }
            }
        });
        receiver.execute(null);
    }

    public void notifyBridgeAPISuccess(final PHBridgeAPIListener listener) {
        if (listener == null) {
            return;
        }
        PHHueResultReceiver receiver = new PHHueResultReceiver(new PHHandlerListener(){

            @Override
            public void onReceived() {
                if (listener != null) {
                    listener.onSuccess();
                }
            }
        });
        receiver.execute(null);
    }

    public void notifyBridgeAPIError(final PHBridgeAPIListener listener, final int code, final String message) {
        if (listener == null) {
            return;
        }
        PHHueResultReceiver receiver = new PHHueResultReceiver(new PHHandlerListener(){

            @Override
            public void onReceived() {
                if (listener != null) {
                    listener.onError(code, message);
                }
            }
        });
        receiver.execute(null);
    }

    public void notifyScenesReceived(final PHSceneListener listener, final List<PHScene> sceneList) {
        if (listener == null) {
            return;
        }
        PHHueResultReceiver receiver = new PHHueResultReceiver(new PHHandlerListener(){

            @Override
            public void onReceived() {
                listener.onScenesReceived(sceneList);
            }
        });
        receiver.execute(null);
    }

    public void notifySensorsReceived(final PHSensorListener listener, final List<PHBridgeResource> sensorHeaderList) {
        if (listener == null) {
            return;
        }
        PHHueResultReceiver receiver = new PHHueResultReceiver(new PHHandlerListener(){

            @Override
            public void onReceived() {
                listener.onSensorsReceived(sensorHeaderList);
            }
        });
        receiver.execute(null);
    }

    public void notifySensorDetails(final PHSensorListener listener, final PHSensor sensor) {
        if (listener == null) {
            return;
        }
        PHHueResultReceiver receiver = new PHHueResultReceiver(new PHHandlerListener(){

            @Override
            public void onReceived() {
                listener.onReceivingSensorDetails(sensor);
            }
        });
        receiver.execute(null);
    }

    public void notifySensorSearchFinished(final PHSensorListener listener) {
        if (listener == null) {
            return;
        }
        PHHueResultReceiver receiver = new PHHueResultReceiver(new PHHandlerListener(){

            @Override
            public void onReceived() {
                listener.onSensorSearchFinished();
            }
        });
        receiver.execute(null);
    }

    public void notifyRuleDetails(final PHRuleListener listener, final PHRule rule) {
        if (listener == null) {
            return;
        }
        PHHueResultReceiver receiver = new PHHueResultReceiver(new PHHandlerListener(){

            @Override
            public void onReceived() {
                listener.onReceivingRuleDetails(rule);
            }
        });
        receiver.execute(null);
    }

    public void notifyBridgeGetScene(final PHSceneListener listener, final PHScene scene) {
        if (listener == null) {
            return;
        }
        PHHueResultReceiver receiver = new PHHueResultReceiver(new PHHandlerListener(){

            @Override
            public void onReceived() {
                listener.onSceneReceived(scene);
            }
        });
        receiver.execute(null);
    }

    public void notifyHTTPResponse(final PHHTTPListener listener, final String jsonResponse) {
        if (listener == null) {
            return;
        }
        PHHueResultReceiver receiver = new PHHueResultReceiver(new PHHandlerListener(){

            @Override
            public void onReceived() {
                listener.onHTTPResponse(jsonResponse);
            }
        });
        receiver.execute(null);
    }
}

