/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.heartbeat;

import com.philips.lighting.hue.listener.PHBridgeConfigurationListener;
import com.philips.lighting.hue.sdk.PHAccessPoint;
import com.philips.lighting.hue.sdk.PHHueSDK;
import com.philips.lighting.hue.sdk.PHMessageType;
import com.philips.lighting.hue.sdk.bridge.impl.PHBridgeDelegator;
import com.philips.lighting.hue.sdk.bridge.impl.PHBridgeImpl;
import com.philips.lighting.hue.sdk.bridge.impl.PHBridgeResourcesCacheImpl;
import com.philips.lighting.hue.sdk.clip.PHBridgeConfigurationSerializer;
import com.philips.lighting.hue.sdk.clip.PHCLIPParser;
import com.philips.lighting.hue.sdk.clip.serialisation.PHCLIPParserBase;
import com.philips.lighting.hue.sdk.connection.impl.PHBridgeInternal;
import com.philips.lighting.hue.sdk.connection.impl.PHHueHttpConnection;
import com.philips.lighting.hue.sdk.connection.impl.PHLocalBridgeDelegator;
import com.philips.lighting.hue.sdk.fbp.PHBridgeVersionManager;
import com.philips.lighting.hue.sdk.notification.impl.PHNotificationManagerImpl;
import com.philips.lighting.hue.sdk.utilities.impl.PHLog;
import com.philips.lighting.model.PHBridge;
import com.philips.lighting.model.PHBridgeConfiguration;
import com.philips.lighting.model.PHGroup;
import com.philips.lighting.model.PHHueError;
import com.philips.lighting.model.PHHueParsingError;
import com.philips.lighting.model.PHLight;
import com.philips.lighting.model.PHScene;
import com.philips.lighting.model.PHSchedule;
import com.philips.lighting.model.PHWhiteListEntry;
import com.philips.lighting.model.rule.PHRule;
import com.philips.lighting.model.sensor.PHSensor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import org.json.hue.JSONObject;

public class PHHeartbeatProcessor
extends TimerTask {
    private PHBridge bridge;
    private static final String TAG = "PHHeartbeatProcessor";
    public static final byte NO_OF_RETRIES = 1;
    private int currentTry = 0;
    private boolean notifyConnectionResume = true;
    private boolean isProcessing;
    private PHHeartbeatType heartbeatType;
    private List<Integer> cacheNotificationsList = new ArrayList<Integer>();

    public PHHeartbeatProcessor(PHBridge bridge2, PHHeartbeatType heartbeatType) {
        this.bridge = bridge2;
        this.heartbeatType = heartbeatType;
    }

    @Override
    public void run() {
        PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
        if (PHHueSDK.getStoredSDKObject() == null) {
            this.isProcessing = false;
            return;
        }
        if (this.bridge == null) {
            if (notificationManager != null) {
                notificationManager.notifySDKError(42, "Internal error:bridge object is null");
            }
            return;
        }
        this.isProcessing = true;
        String response = this.getResponseFromResource();
        boolean error = false;
        if (response != null) {
            PHCLIPParserBase parser = PHCLIPParserBase.getInstance();
            List errorTable = parser.parseError(response);
            if (errorTable.size() != 0) {
                this.isProcessing = false;
                this.disconnectBridge(true);
                PHHueError errorObject = (PHHueError)errorTable.get(0);
                if (notificationManager != null) {
                    notificationManager.notifySDKError(errorObject.getCode(), errorObject.getMessage());
                }
                this.cancel();
            } else {
                if (!this.notifyConnectionResume) {
                    this.notifyConnectionResume = true;
                    PHHueSDK sdkImplementation = PHHueSDK.getStoredSDKObject();
                    if (sdkImplementation != null) {
                        sdkImplementation.addBridge(this.bridge);
                    }
                }
                if (notificationManager != null) {
                    notificationManager.notifyConnectionResumed(this.bridge);
                }
                PHLog.d((String)TAG, (String)("start processing HeartbeatResponse for type " + this.heartbeatType.toString()));
                this.processHeartbeatResponse(response);
            }
        } else {
            error = true;
        }
        if (error) {
            this.notifyConnectionResume = false;
            if (this.currentTry < 1) {
                ++this.currentTry;
                this.run();
            } else {
                this.disconnectBridge(false);
                String couldntConnect = "No connection";
                if (notificationManager != null) {
                    notificationManager.notifySDKError(22, couldntConnect);
                }
                PHAccessPoint accessPoint = this.disconnectedBridgeAsAccessPoint();
                if (notificationManager != null) {
                    notificationManager.notifyConnectionLost(accessPoint);
                }
            }
        }
        this.isProcessing = false;
    }

    private void processHeartbeatResponse(String response) {
        block22: {
            JSONObject rootObject = null;
            try {
                PHBridgeConfiguration newBridgeConfig = null;
                List groupsList = null;
                List lightsList = null;
                List sceneList = null;
                List schedulesList = null;
                List sensorList = null;
                List ruleList = null;
                rootObject = new JSONObject(response);
                if (rootObject != null) {
                    PHCLIPParser parser;
                    PHBridgeConfigurationSerializer serializer;
                    PHBridgeVersionManager bridgeVersionManager = PHBridgeVersionManager.getInstance();
                    if (this.heartbeatType == PHHeartbeatType.CONFIG || this.heartbeatType == PHHeartbeatType.FULL_CONFIG) {
                        PHBridgeConfigurationSerializer bridgeConfigSerializer = bridgeVersionManager.getBridgeConfigurationSerializer();
                        String bridgeSwVersion = bridgeConfigSerializer.parseBridgeSoftwareVersion(rootObject);
                        String bridgeAPIVersion = bridgeConfigSerializer.parseBridgeAPIVersion(rootObject);
                        bridgeVersionManager.setBridgeVersion(bridgeSwVersion, bridgeAPIVersion);
                    }
                    PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
                    ArrayList<PHHueParsingError> parsingErrors = new ArrayList<PHHueParsingError>();
                    if ((this.heartbeatType == PHHeartbeatType.CONFIG || this.heartbeatType == PHHeartbeatType.FULL_CONFIG) && (serializer = bridgeVersionManager.getBridgeConfigurationSerializer()) != null) {
                        newBridgeConfig = serializer.parseBridgeConfiguration(rootObject);
                        parser = (PHCLIPParser)serializer;
                        parsingErrors.addAll(parser.getParsingErrors());
                        parser.clearErrors();
                    }
                    if ((this.heartbeatType == PHHeartbeatType.GROUPS || this.heartbeatType == PHHeartbeatType.FULL_CONFIG) && (serializer = bridgeVersionManager.getGroupSerializer()) != null) {
                        groupsList = serializer.parseGroups(rootObject);
                        parser = (PHCLIPParser)serializer;
                        parsingErrors.addAll(parser.getParsingErrors());
                        parser.clearErrors();
                    }
                    if ((this.heartbeatType == PHHeartbeatType.LIGHTS || this.heartbeatType == PHHeartbeatType.FULL_CONFIG) && (serializer = bridgeVersionManager.getLightSerializer()) != null) {
                        lightsList = serializer.parseLights(rootObject);
                        parser = (PHCLIPParser)serializer;
                        parsingErrors.addAll(parser.getParsingErrors());
                        parser.clearErrors();
                    }
                    if ((this.heartbeatType == PHHeartbeatType.SCENES || this.heartbeatType == PHHeartbeatType.FULL_CONFIG) && (serializer = bridgeVersionManager.getScenesSerializer()) != null) {
                        sceneList = serializer.parseScenes(rootObject);
                        parser = (PHCLIPParser)serializer;
                        parsingErrors.addAll(parser.getParsingErrors());
                        parser.clearErrors();
                    }
                    if ((this.heartbeatType == PHHeartbeatType.SCHEDULES || this.heartbeatType == PHHeartbeatType.FULL_CONFIG) && (serializer = bridgeVersionManager.getSchedulesSerializer()) != null) {
                        schedulesList = serializer.parseSchedules(rootObject, this.bridge.getResourceCache().getBridgeConfiguration().getTimeZone());
                        parser = (PHCLIPParser)serializer;
                        parsingErrors.addAll(parser.getParsingErrors());
                        parser.clearErrors();
                    }
                    if ((this.heartbeatType == PHHeartbeatType.SENSORS || this.heartbeatType == PHHeartbeatType.FULL_CONFIG) && (serializer = bridgeVersionManager.getSensorSerializer()) != null) {
                        sensorList = serializer.parseSensors(rootObject);
                        parser = (PHCLIPParser)serializer;
                        parsingErrors.addAll(parser.getParsingErrors());
                        parser.clearErrors();
                    }
                    if ((this.heartbeatType == PHHeartbeatType.RULES || this.heartbeatType == PHHeartbeatType.FULL_CONFIG) && (serializer = bridgeVersionManager.getRulesSerializer()) != null) {
                        ruleList = serializer.parseRules(rootObject);
                        parser = (PHCLIPParser)serializer;
                        parsingErrors.addAll(parser.getParsingErrors());
                        parser.clearErrors();
                    }
                    if (notificationManager != null && parsingErrors.size() != 0) {
                        notificationManager.notifyParsingError(parsingErrors);
                    }
                    PHBridgeResourcesCacheImpl cacheImpl = (PHBridgeResourcesCacheImpl)this.bridge.getResourceCache();
                    Map lightsCache = cacheImpl.getLights();
                    Map groupsCache = cacheImpl.getGroups();
                    PHBridgeConfiguration bridgeConfig = cacheImpl.getBridgeConfiguration();
                    Map schedulesCache = cacheImpl.getSchedules();
                    Map sceneCache = cacheImpl.getScenes();
                    Map sensorCache = cacheImpl.getSensors();
                    Map ruleCache = cacheImpl.getRules();
                    this.cacheNotificationsList.clear();
                    if (this.isLightsChanged(lightsList, lightsCache)) {
                        this.cacheNotificationsList.add(PHMessageType.LIGHTS_CACHE_UPDATED);
                        cacheImpl.setLights(this.getNewLightsCache(lightsList));
                        PHLog.d((String)TAG, (String)"LIGHTS_CACHE_UPDATED");
                    }
                    if (this.isGroupsChanged(groupsList, groupsCache)) {
                        this.cacheNotificationsList.add(PHMessageType.GROUPS_CACHE_UPDATED);
                        cacheImpl.setGroups(this.getNewGroupsCache(groupsList));
                        PHLog.d((String)TAG, (String)"GROUPS_CACHE_UPDATED");
                    }
                    if (this.isSchedulesChanged(schedulesList, schedulesCache)) {
                        this.cacheNotificationsList.add(PHMessageType.SCHEDULES_CACHE_UPDATED);
                        cacheImpl.setSchedules(this.getNewSchedulesCache(schedulesList));
                        PHLog.d((String)TAG, (String)"SCHEDULES_CACHE_UPDATED");
                    }
                    if (this.isScenesChanged(sceneList, sceneCache)) {
                        this.cacheNotificationsList.add(PHMessageType.SCENE_CACHE_UPDATED);
                        cacheImpl.setScenes(this.getNewScenesCache(sceneList));
                        PHLog.d((String)TAG, (String)"SCENE_CACHE_UPDATED");
                    }
                    if (this.isSensorsChanged(sensorList, sensorCache)) {
                        this.cacheNotificationsList.add(PHMessageType.SENSOR_CACHE_UPDATED);
                        cacheImpl.setSensors(this.getNewSensorsCache(sensorList));
                        PHLog.d((String)TAG, (String)"SENSOR_CACHE_UPDATED");
                    }
                    if (this.checkAndUpdateRules(ruleList, ruleCache)) {
                        this.cacheNotificationsList.add(PHMessageType.RULE_CACHE_UPDATED);
                        cacheImpl.setRules(this.getNewRulesCache(ruleList));
                        PHLog.d((String)TAG, (String)"RULE_CACHE_UPDATED");
                    }
                    if (newBridgeConfig != null) {
                        String userName = bridgeConfig.getUsername();
                        newBridgeConfig.setUserName(userName);
                        if (!bridgeConfig.equals((Object)newBridgeConfig)) {
                            cacheImpl.setBridgeConfiguration(newBridgeConfig);
                            this.cacheNotificationsList.add(PHMessageType.BRIDGE_CONFIGURATION_CACHE_UPDATED);
                            PHLog.d((String)TAG, (String)"BRIDGE_CONFIGURATION_CACHE_UPDATED");
                        } else {
                            cacheImpl.setBridgeConfiguration(newBridgeConfig);
                        }
                    }
                    PHLog.d((String)TAG, (String)("Notified with notificationFlags :" + this.cacheNotificationsList.size()));
                    if (this.cacheNotificationsList.size() != 0 && notificationManager != null) {
                        notificationManager.notifyCacheUpdated(this.cacheNotificationsList, this.bridge);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
                if (notificationManager == null) break block22;
                notificationManager.notifySDKError(42, "Internal error in SDK");
            }
        }
    }

    public PHHeartbeatType getType() {
        return this.heartbeatType;
    }

    private boolean isLightsChanged(List<PHLight> lightsList, Map<String, PHLight> lightsCache) {
        if (lightsList == null || lightsCache == null) {
            return false;
        }
        if (lightsList.size() != lightsCache.size()) {
            return true;
        }
        for (PHLight light : lightsList) {
            PHLight cachedLight = lightsCache.get(light.getIdentifier());
            if (cachedLight == null) {
                return true;
            }
            if (cachedLight.equals((Object)light)) continue;
            return true;
        }
        return false;
    }

    private Map<String, PHLight> getNewLightsCache(List<PHLight> lightsList) {
        HashMap<String, PHLight> lightsCacheCopy = new HashMap<String, PHLight>();
        for (PHLight light : lightsList) {
            lightsCacheCopy.put(light.getIdentifier(), light);
        }
        return lightsCacheCopy;
    }

    private boolean isGroupsChanged(List<PHGroup> groupsList, Map<String, PHGroup> groupsCache) {
        if (groupsList == null || groupsCache == null) {
            return false;
        }
        if (groupsList.size() != groupsCache.size()) {
            return true;
        }
        for (PHGroup group : groupsList) {
            PHGroup cachedGroup = groupsCache.get(group.getIdentifier());
            if (cachedGroup == null) {
                return true;
            }
            if (cachedGroup.equals((Object)group)) continue;
            return true;
        }
        return false;
    }

    private Map<String, PHGroup> getNewGroupsCache(List<PHGroup> groupsList) {
        HashMap<String, PHGroup> groupsCacheCopy = new HashMap<String, PHGroup>();
        for (PHGroup group : groupsList) {
            groupsCacheCopy.put(group.getIdentifier(), group);
        }
        return groupsCacheCopy;
    }

    private boolean isSchedulesChanged(List<PHSchedule> schedulesList, Map<String, PHSchedule> schedulesCache) {
        if (schedulesList == null || schedulesCache == null) {
            return false;
        }
        if (schedulesList.size() != schedulesCache.size()) {
            return true;
        }
        for (PHSchedule schedule : schedulesList) {
            PHSchedule cachedSchedule = schedulesCache.get(schedule.getIdentifier());
            if (cachedSchedule == null) {
                return true;
            }
            if (cachedSchedule.equals((Object)schedule)) continue;
            return true;
        }
        return false;
    }

    private Map<String, PHSchedule> getNewSchedulesCache(List<PHSchedule> schedulesList) {
        HashMap<String, PHSchedule> schedulesCacheCopy = new HashMap<String, PHSchedule>();
        for (PHSchedule schedule : schedulesList) {
            schedulesCacheCopy.put(schedule.getIdentifier(), schedule);
        }
        return schedulesCacheCopy;
    }

    private boolean isScenesChanged(List<PHScene> sceneList, Map<String, PHScene> sceneCache) {
        if (sceneList == null || sceneCache == null) {
            return false;
        }
        if (sceneList.size() != sceneCache.size()) {
            return true;
        }
        for (PHScene scene : sceneList) {
            PHScene cachedScene = sceneCache.get(scene.getSceneIdentifier());
            if (cachedScene == null) {
                sceneCache.put(scene.getSceneIdentifier(), scene);
                return true;
            }
            if (cachedScene.equals((Object)scene)) continue;
            return true;
        }
        return false;
    }

    private Map<String, PHScene> getNewScenesCache(List<PHScene> scenesList) {
        HashMap<String, PHScene> scenessCacheCopy = new HashMap<String, PHScene>();
        for (PHScene scene : scenesList) {
            scenessCacheCopy.put(scene.getSceneIdentifier(), scene);
        }
        return scenessCacheCopy;
    }

    private boolean isSensorsChanged(List<PHSensor> sensorList, Map<String, PHSensor> sensorCache) {
        if (sensorList == null || sensorCache == null) {
            return false;
        }
        if (sensorList.size() != sensorCache.size()) {
            return true;
        }
        for (PHSensor sensor : sensorList) {
            PHSensor cachedSensor = sensorCache.get(sensor.getIdentifier());
            if (cachedSensor == null) {
                sensorCache.put(sensor.getIdentifier(), sensor);
                return true;
            }
            if (cachedSensor.equals((Object)sensor)) continue;
            return true;
        }
        return false;
    }

    private Map<String, PHSensor> getNewSensorsCache(List<PHSensor> sensorList) {
        HashMap<String, PHSensor> sensorCacheCopy = new HashMap<String, PHSensor>();
        for (PHSensor sensor : sensorList) {
            sensorCacheCopy.put(sensor.getIdentifier(), sensor);
        }
        return sensorCacheCopy;
    }

    private boolean checkAndUpdateRules(List<PHRule> rulesList, Map<String, PHRule> rulesCache) {
        if (rulesList == null || rulesCache == null) {
            return false;
        }
        if (rulesList.size() != rulesCache.size()) {
            return true;
        }
        for (PHRule rule : rulesList) {
            PHRule cachedRule = rulesCache.get(rule.getIdentifier());
            if (cachedRule == null) {
                rulesCache.put(rule.getIdentifier(), rule);
                return true;
            }
            if (cachedRule.equals((Object)rule)) continue;
            return true;
        }
        return false;
    }

    private Map<String, PHRule> getNewRulesCache(List<PHRule> ruleList) {
        HashMap<String, PHRule> ruleCacheCopy = new HashMap<String, PHRule>();
        for (PHRule rule : ruleList) {
            ruleCacheCopy.put(rule.getIdentifier(), rule);
        }
        return ruleCacheCopy;
    }

    private void disconnectBridge(boolean stopHeartBeat) {
        PHHueSDK sdkImplementation = PHHueSDK.getStoredSDKObject();
        if (sdkImplementation == null) {
            return;
        }
        if (stopHeartBeat) {
            sdkImplementation.getHeartbeatManager().disableAllHeartbeats(this.bridge);
            sdkImplementation.disconnect(this.bridge);
        } else {
            sdkImplementation.removeBridge(this.bridge);
        }
    }

    public PHBridgeInternal getInternalObject() {
        return new PHBridgeInternal();
    }

    private PHAccessPoint disconnectedBridgeAsAccessPoint() {
        if (this.bridge == null) {
            return null;
        }
        PHAccessPoint accessPoint = new PHAccessPoint();
        PHBridgeConfiguration bridgeConfiguration = this.bridge.getResourceCache().getBridgeConfiguration();
        accessPoint.setIpAddress(bridgeConfiguration.getIpAddress());
        accessPoint.setMacAddress(bridgeConfiguration.getMacAddress());
        accessPoint.setBridgeId(bridgeConfiguration.getBridgeID());
        accessPoint.setUsername(bridgeConfiguration.getUsername());
        return accessPoint;
    }

    public boolean isProcessing() {
        return this.isProcessing;
    }

    private String getResponseFromResource() {
        PHBridgeResourcesCacheImpl cacheImpl = (PHBridgeResourcesCacheImpl)this.bridge.getResourceCache();
        PHBridgeConfiguration bridgeConfig = cacheImpl.getBridgeConfiguration();
        PHBridgeInternal internals = this.getInternalObject();
        if (this.heartbeatType == PHHeartbeatType.CONFIG) {
            return internals.getConfigDetails(bridgeConfig.getUsername(), bridgeConfig.getIpAddress());
        }
        if (this.heartbeatType == PHHeartbeatType.GROUPS) {
            return internals.getGroupsDetail(bridgeConfig.getUsername(), bridgeConfig.getIpAddress());
        }
        if (this.heartbeatType == PHHeartbeatType.LIGHTS) {
            return internals.getLightsDetail(bridgeConfig.getUsername(), bridgeConfig.getIpAddress());
        }
        if (this.heartbeatType == PHHeartbeatType.SCENES) {
            return internals.getScenesDetail(bridgeConfig.getUsername(), bridgeConfig.getIpAddress());
        }
        if (this.heartbeatType == PHHeartbeatType.SCHEDULES) {
            return internals.getSchedulesDetail(bridgeConfig.getUsername(), bridgeConfig.getIpAddress());
        }
        if (this.heartbeatType == PHHeartbeatType.SENSORS) {
            return internals.getSensorsDetail(bridgeConfig.getUsername(), bridgeConfig.getIpAddress());
        }
        if (this.heartbeatType == PHHeartbeatType.RULES) {
            return internals.getRulesDetail(bridgeConfig.getUsername(), bridgeConfig.getIpAddress());
        }
        return internals.getBridgeDetails(bridgeConfig.getUsername(), bridgeConfig.getIpAddress());
    }

    private void checkAppNameDeviceName(PHBridgeConfiguration bridgeConfig) {
        final String whitelistID = ((PHBridgeImpl)this.bridge).getBridgeDelegator().getWhitelistIdentifier();
        PHWhiteListEntry whitelistEntry = null;
        for (PHWhiteListEntry entry : bridgeConfig.getWhiteListEntries()) {
            if (!entry.getUserName().equals(whitelistID)) continue;
            whitelistEntry = entry;
        }
        if (whitelistEntry != null && whitelistEntry.getDeviceName() == null) {
            String sdkAppName = PHHueSDK.getInstance().getAppName();
            String sdkDeviceName = PHHueSDK.getInstance().getDeviceName();
            String combinedName = sdkAppName + "#" + sdkDeviceName;
            new Thread(){

                @Override
                public void run() {
                    PHHueHttpConnection httpObject = new PHHueHttpConnection();
                    final PHBridgeDelegator delegator = ((PHBridgeImpl)PHHeartbeatProcessor.this.bridge).getBridgeDelegator();
                    try {
                        Method buildAddressMethod = delegator.getClass().getMethod("buildHttpAddress", null);
                        StringBuffer address = (StringBuffer)buildAddressMethod.invoke((Object)delegator, null);
                        String url = address.append("config").toString();
                        String response = httpObject.putData("{\"linkbutton\":true}", url);
                        if (response.contains("success")) {
                            delegator.removeUsername(whitelistID, new PHBridgeConfigurationListener(){

                                public void onSuccess() {
                                    PHHueSDK sdk = PHHueSDK.getInstance();
                                    try {
                                        Field ipField = PHLocalBridgeDelegator.class.getDeclaredField("ipAddress");
                                        ipField.setAccessible(true);
                                        String ip = (String)ipField.get(delegator);
                                        PHAccessPoint accessPoint = new PHAccessPoint();
                                        accessPoint.setIpAddress(ip);
                                        accessPoint.setUsername(whitelistID);
                                        sdk.startPushlinkAuthentication(accessPoint);
                                    }
                                    catch (NoSuchFieldException e) {
                                        e.printStackTrace();
                                    }
                                    catch (SecurityException e) {
                                        e.printStackTrace();
                                    }
                                    catch (IllegalArgumentException e) {
                                        e.printStackTrace();
                                    }
                                    catch (IllegalAccessException e) {
                                        e.printStackTrace();
                                    }
                                }

                                public void onStateUpdate(Map<String, String> successAttribute, List<PHHueError> errorAttribute) {
                                }

                                public void onError(int code, String message) {
                                    PHHueSDK sdk = PHHueSDK.getInstance();
                                    try {
                                        Field ipField = PHLocalBridgeDelegator.class.getDeclaredField("ipAddress");
                                        ipField.setAccessible(true);
                                        String ip = (String)ipField.get(delegator);
                                        PHAccessPoint accessPoint = new PHAccessPoint();
                                        accessPoint.setIpAddress(ip);
                                        accessPoint.setUsername(whitelistID);
                                        sdk.startPushlinkAuthentication(accessPoint);
                                    }
                                    catch (NoSuchFieldException e) {
                                        e.printStackTrace();
                                    }
                                    catch (SecurityException e) {
                                        e.printStackTrace();
                                    }
                                    catch (IllegalArgumentException e) {
                                        e.printStackTrace();
                                    }
                                    catch (IllegalAccessException e) {
                                        e.printStackTrace();
                                    }
                                }

                                public void onReceivingConfiguration(PHBridgeConfiguration configuration) {
                                }
                            });
                        }
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                        return;
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                        return;
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        return;
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                        return;
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                        return;
                    }
                }
            }.start();
        }
    }

    public static enum PHHeartbeatType {
        FULL_CONFIG,
        LIGHTS,
        SCENES,
        SENSORS,
        CONFIG,
        RULES,
        GROUPS,
        SCHEDULES;

    }
}

