/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk;

import com.philips.lighting.hue.sdk.PHAccessPoint;
import com.philips.lighting.hue.sdk.PHNotificationManager;
import com.philips.lighting.hue.sdk.bridge.impl.PHBridgeImpl;
import com.philips.lighting.hue.sdk.bridge.impl.PHBridgeResourcesCacheImpl;
import com.philips.lighting.hue.sdk.connection.impl.PHBridgeInternal;
import com.philips.lighting.hue.sdk.data.BridgeHeader;
import com.philips.lighting.hue.sdk.exception.PHBridgeNotConnectedException;
import com.philips.lighting.hue.sdk.exception.PHHeartbeatException;
import com.philips.lighting.hue.sdk.exception.PHHueException;
import com.philips.lighting.hue.sdk.heartbeat.PHHeartbeatManager;
import com.philips.lighting.hue.sdk.notification.impl.PHNotificationManagerImpl;
import com.philips.lighting.hue.sdk.upnp.PHBridgeSearchManagerImpl;
import com.philips.lighting.hue.sdk.utilities.impl.PHLog;
import com.philips.lighting.model.PHBridge;
import com.philips.lighting.model.PHBridgeConfiguration;
import com.philips.lighting.model.PHBridgeResourcesCache;
import com.philips.lighting.model.PHGroup;
import com.philips.lighting.model.PHLight;
import com.philips.lighting.model.PHLightState;
import com.philips.lighting.model.PHSchedule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PHHueSDK {
    private static PHHueSDK instance = null;
    private PHBridge selectedBridge;
    private List<PHBridge> bridgeObjects;
    private PHHeartbeatManager heartbeatManager;
    private PHBridgeInternal phBridgeInternal;
    private static final String SDK_VERSION = "1.11.2";
    public static final byte SEARCH_BRIDGE = 1;
    public static final int HB_INTERVAL = 10000;
    private PHLightState currentLightState;
    private List<PHAccessPoint> accessPointsFound = new ArrayList<PHAccessPoint>();
    private PHNotificationManager notificationManager;
    public static final byte LOG = 2;
    private List<PHAccessPoint> disconnectedAccessPoint = new ArrayList<PHAccessPoint>();
    private Map<String, Long> lastHeartbeat = new HashMap<String, Long>();
    private String deviceName;
    private String appName;

    private PHHueSDK() {
        this.bridgeObjects = new ArrayList<PHBridge>();
        this.heartbeatManager = PHHeartbeatManager.getInstance();
        this.notificationManager = PHNotificationManager.getDefaultManager();
    }

    public static PHHueSDK getInstance() {
        if (instance == null) {
            instance = new PHHueSDK();
        }
        return instance;
    }

    public static PHHueSDK create() {
        return PHHueSDK.getInstance();
    }

    public List<PHBridge> getAllBridges() {
        return this.bridgeObjects;
    }

    public static PHHueSDK getStoredSDKObject() {
        return instance;
    }

    public PHBridgeInternal getInternalObject() {
        return new PHBridgeInternal();
    }

    public PHHeartbeatManager getHeartbeatManager() {
        return this.heartbeatManager;
    }

    public Object getSDKService(byte msgType) {
        switch (msgType) {
            case 1: {
                return new PHBridgeSearchManagerImpl();
            }
            case 2: {
                return new PHLog();
            }
        }
        return null;
    }

    public void enableHeartbeat(PHBridge bridge, long time) {
        if (bridge == null) {
            throw new PHBridgeNotConnectedException("Input parameter can't be null");
        }
        if (!this.isHeartbeatEnabled(bridge)) {
            this.heartbeatManager.enableFullConfigHeartbeat((PHBridge)((PHBridgeImpl)bridge), time);
        }
    }

    public void disableHeartbeat(PHBridge bridge) {
        if (bridge == null) {
            throw new PHBridgeNotConnectedException("Input parameter can't be null");
        }
        if (this.isHeartbeatEnabled(bridge)) {
            this.heartbeatManager.disableFullConfigHeartbeat((PHBridge)((PHBridgeImpl)bridge));
        }
    }

    public void disableAllHeartbeat() {
        for (PHBridge bridge : this.bridgeObjects) {
            if (!this.isHeartbeatEnabled(bridge)) continue;
            this.heartbeatManager.disableAllHeartbeats((PHBridge)((PHBridgeImpl)bridge));
        }
    }

    public boolean isHeartbeatEnabled(PHBridge bridge) {
        if (bridge == null) {
            throw new PHBridgeNotConnectedException("Input parameter can't be null");
        }
        return this.heartbeatManager.isHeartBeating((PHBridge)((PHBridgeImpl)bridge));
    }

    public void connect(PHAccessPoint accessPoint) throws PHHueException {
        if (accessPoint == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        this.phBridgeInternal = new PHBridgeInternal();
        for (int i = 0; i < this.bridgeObjects.size(); ++i) {
            PHBridgeResourcesCacheImpl cacheImpl = (PHBridgeResourcesCacheImpl)this.bridgeObjects.get(i).getResourceCache();
            PHBridgeConfiguration bridgeConfig = cacheImpl.getBridgeConfiguration();
            if (bridgeConfig == null || !bridgeConfig.getIpAddress().equals(accessPoint.getIpAddress())) continue;
            throw new PHHueException("You are already connected.");
        }
        this.phBridgeInternal.connectToAccessPoint(accessPoint);
    }

    public boolean isAccessPointConnected(PHAccessPoint accessPoint) {
        if (this.bridgeObjects != null) {
            for (int i = 0; i < this.bridgeObjects.size(); ++i) {
                PHBridgeResourcesCacheImpl cacheImpl = (PHBridgeResourcesCacheImpl)this.bridgeObjects.get(i).getResourceCache();
                PHBridgeConfiguration bridgeConfig = cacheImpl.getBridgeConfiguration();
                if (bridgeConfig == null || !bridgeConfig.getIpAddress().equals(accessPoint.getIpAddress())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean disconnect(PHBridge bridge) throws PHHeartbeatException {
        if (this.isHeartbeatEnabled(bridge)) {
            throw new PHHeartbeatException("Heartbeat is not stopped before disconnecting a bridge");
        }
        return this.removeBridge(bridge);
    }

    public void startPushlinkAuthentication(PHAccessPoint accessPoint) {
        if (accessPoint == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        this.stopPushlinkAuthentication();
        this.phBridgeInternal = new PHBridgeInternal();
        this.phBridgeInternal.startPushlinkTimer(accessPoint);
    }

    public boolean stopPushlinkAuthentication() {
        if (this.phBridgeInternal == null) {
            return false;
        }
        return this.phBridgeInternal.stopPushLinkTimer();
    }

    public void destroySDK() {
        PHNotificationManagerImpl.cleanNotificationManager();
        if (this.heartbeatManager != null) {
            PHHueSDK pHHueSDK = this;
            pHHueSDK.heartbeatManager.removeTimer();
        }
        instance = null;
    }

    public String getSDKVersion() {
        return SDK_VERSION;
    }

    public boolean removeBridge(PHBridge bridge) {
        if (this.bridgeObjects != null) {
            return this.bridgeObjects.remove(bridge);
        }
        return false;
    }

    public void addBridge(PHBridge bridge) {
        if (this.bridgeObjects != null && bridge != null) {
            this.bridgeObjects.add(bridge);
        }
    }

    public List<PHAccessPoint> getAccessPointsFound() {
        return this.accessPointsFound;
    }

    public PHBridge getSelectedBridge() {
        return this.selectedBridge;
    }

    public void setSelectedBridge(PHBridge selectedBridge) {
        this.selectedBridge = selectedBridge;
    }

    public PHLightState getCurrentLightState() {
        return this.currentLightState;
    }

    public void setCurrentLightState(PHLightState currentLightState) {
        this.currentLightState = currentLightState;
    }

    public PHNotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    public synchronized List<BridgeHeader> getBridgesForDisplay() {
        List<PHBridge> connectedBridges = this.getAllBridges();
        ArrayList<BridgeHeader> bridgeData = new ArrayList<BridgeHeader>();
        if (connectedBridges != null) {
            for (PHBridge bridge : connectedBridges) {
                if (!this.isHeartbeatEnabled(bridge)) {
                    this.enableHeartbeat(bridge, 10000L);
                }
                boolean isFound = false;
                PHBridgeResourcesCache cache = bridge.getResourceCache();
                BridgeHeader newHeader = new BridgeHeader(cache.getBridgeConfiguration().getIpAddress(), "Connected", this.lastHeartbeat.get(cache.getBridgeConfiguration().getIpAddress()));
                for (int i = 0; i < bridgeData.size(); ++i) {
                    BridgeHeader header = (BridgeHeader)bridgeData.get(i);
                    if (!header.getIPAddress().equals(newHeader.getIPAddress())) continue;
                    header.setStatus(newHeader.getStatus());
                    isFound = true;
                    break;
                }
                if (isFound) continue;
                bridgeData.add(newHeader);
            }
        }
        for (int i = 0; i < this.disconnectedAccessPoint.size(); ++i) {
            boolean isFound = false;
            for (int j = 0; j < bridgeData.size(); ++j) {
                if (!((BridgeHeader)bridgeData.get(j)).getIPAddress().equals(this.disconnectedAccessPoint.get(i).getIpAddress())) continue;
                ((BridgeHeader)bridgeData.get(j)).setStatus("Disconnected");
                isFound = true;
                break;
            }
            if (isFound) continue;
            bridgeData.add(new BridgeHeader(this.disconnectedAccessPoint.get(i).getIpAddress(), "Disconnected", this.lastHeartbeat.get(this.disconnectedAccessPoint.get(i).getIpAddress())));
        }
        return bridgeData;
    }

    public List<PHAccessPoint> getDisconnectedAccessPoint() {
        return this.disconnectedAccessPoint;
    }

    public void setDisconnectedAccessPoint(List<PHAccessPoint> disconnectedAccessPoint) {
        this.disconnectedAccessPoint = disconnectedAccessPoint;
    }

    public Map<String, Long> getLastHeartbeat() {
        return this.lastHeartbeat;
    }

    public void setLastHeartbeat(Map<String, Long> lastHeartbeat) {
        this.lastHeartbeat = lastHeartbeat;
    }

    public String[] getLightNames(List<PHLight> lights) {
        int size = lights.size();
        String[] lightArray = new String[size];
        for (int i = 0; i < size; ++i) {
            lightArray[i] = lights.get(i).getName();
        }
        return lightArray;
    }

    public String[] getGroupNames(List<PHGroup> groups) {
        int size = groups.size();
        String[] groupArray = new String[size];
        for (int i = 0; i < size; ++i) {
            groupArray[i] = groups.get(i).getName();
        }
        return groupArray;
    }

    public String[] getScheduleNames(List<PHSchedule> schedules) {
        int size = schedules.size();
        String[] timerArray = new String[size];
        for (int i = 0; i < size; ++i) {
            timerArray[i] = schedules.get(i).getName();
        }
        return timerArray;
    }

    public String getDeviceName() {
        return this.deviceName != null ? this.deviceName : "MyDevice";
    }

    public void setDeviceName(String deviceName) {
        if (deviceName == null || deviceName.isEmpty()) {
            throw new IllegalArgumentException("Device Name must contain at least 1 character, maximum 19, cannot contain #");
        }
        deviceName.replaceAll("#", "");
        while (deviceName.getBytes().length > 19) {
            deviceName = deviceName.substring(0, deviceName.length() - 1);
        }
        this.deviceName = deviceName;
    }

    public String getAppName() {
        return this.appName != null ? this.appName : "MyApplication";
    }

    public void setAppName(String appName) {
        if (appName == null || appName.isEmpty()) {
            throw new IllegalArgumentException("Application Name must contain at least 1 character, maximum 20, cannot contain #");
        }
        appName.replaceAll("#", "");
        while (appName.getBytes().length > 20) {
            appName = appName.substring(0, appName.length() - 1);
        }
        this.appName = appName;
    }
}

