/*
 * Decompiled with CFR 0.152.
 */
package ru.org.amip.ambisync.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.org.amip.ambisync.config.Lamp;

public class LampConfig {
    private static final Logger logger = LoggerFactory.getLogger(LampConfig.class);
    public static final String LAMPS_CONFIG = "../conf/sync-presets/lamps.json";
    private Map<String, Lamp> lamps = new LinkedHashMap<String, Lamp>();

    public static JsonObject convertFileToJSON(String fileName) throws FileNotFoundException {
        JsonParser parser = new JsonParser();
        JsonElement jsonElement = parser.parse((Reader)new FileReader(fileName));
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        return jsonObject;
    }

    public Map<String, Lamp> load() {
        return this.load(null);
    }

    public Map<String, Lamp> load(String config) {
        config = config == null ? LAMPS_CONFIG : "../conf/sync-presets/" + config + ".json";
        try {
            JsonObject o = LampConfig.convertFileToJSON(config);
            Set lamps = o.entrySet();
            for (Map.Entry lamp : lamps) {
                String name = (String)lamp.getKey();
                Lamp l = new Lamp();
                JsonObject sidesObject = (JsonObject)lamp.getValue();
                Set sides = sidesObject.entrySet();
                for (Map.Entry side : sides) {
                    String position;
                    switch (position = (String)side.getKey()) {
                        case "left": 
                        case "right": 
                        case "top": 
                        case "bottom": {
                            JsonArray leds = ((JsonElement)side.getValue()).getAsJsonArray();
                            ArrayList<Integer> ledList = new ArrayList<Integer>();
                            for (JsonElement led : leds) {
                                ledList.add(led.getAsInt());
                            }
                            l.setLeds(position, ledList);
                            break;
                        }
                        case "brightness": {
                            l.setBrightness(((JsonElement)side.getValue()).getAsInt());
                            break;
                        }
                        case "immersion": {
                            l.setImmersion(((JsonElement)side.getValue()).getAsInt());
                            break;
                        }
                        case "transition": {
                            l.setTransition(((JsonElement)side.getValue()).getAsInt());
                            break;
                        }
                        case "model": {
                            l.setModel(((JsonElement)side.getValue()).getAsString());
                        }
                    }
                }
                this.lamps.put(name, l);
            }
            logger.info("Loaded {} lamps from {}", (Object)lamps.size(), (Object)config);
        }
        catch (FileNotFoundException e) {
            logger.error("Cannot load lamps config file ({})!", (Object)config);
        }
        return this.lamps;
    }

    public static void main(String[] args) {
        new LampConfig().load();
    }
}

