/*
 * Decompiled with CFR 0.152.
 */
package ru.org.amip.ambisync;

import org.boris.winrun4j.Service;
import org.boris.winrun4j.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.org.amip.ambisync.Main;

public class ServiceMain
implements Service {
    private static final Logger logger = LoggerFactory.getLogger(ServiceMain.class);

    @Override
    public int serviceMain(String[] args) throws ServiceException {
        logger.info("AmbySync is starting as system service...");
        Main.main(args);
        return 0;
    }

    @Override
    public int serviceRequest(int control) throws ServiceException {
        switch (control) {
            case 1: 
            case 5: {
                logger.info("AmbySync system service shutdown...");
                Runtime.getRuntime().removeShutdownHook(Main.SHUTDOWN_HOOK);
                Thread thread = new Thread(Main.SHUTDOWN_HOOK);
                thread.start();
                try {
                    thread.join(10000L);
                }
                catch (InterruptedException e) {
                    logger.error("Interrupted", (Throwable)e);
                }
                break;
            }
        }
        return 0;
    }
}

