/*
 * Decompiled with CFR 0.152.
 */
package ru.org.amip.ambisync;

import com.philips.lighting.hue.sdk.PHAccessPoint;
import com.philips.lighting.hue.sdk.PHBridgeSearchManager;
import com.philips.lighting.hue.sdk.PHHueSDK;
import com.philips.lighting.hue.sdk.PHSDKListener;
import com.philips.lighting.model.PHBridge;
import com.philips.lighting.model.PHHueParsingError;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.org.amip.ambisync.AmbiSync;
import ru.org.amip.ambisync.Main;

public class Controller {
    private static final Logger logger = LoggerFactory.getLogger(Controller.class);
    private static Controller instance = new Controller();
    private PHHueSDK phHueSDK;
    private AmbiSync al;
    private PHBridge lastConnectedBridge;
    private volatile boolean connectionLost = false;
    private List<PHAccessPoint> bridges = new ArrayList<PHAccessPoint>();
    private volatile boolean isSyncEnabled = false;
    private long cacheUpdated;
    private PHSDKListener listener = new PHSDKListener(){

        public void onAccessPointsFound(List<PHAccessPoint> accessPointsList) {
            logger.info("Found {} bridges", (Object)accessPointsList.size());
            String username = Main.conf.getString("bridge.username");
            Controller.this.bridges.clear();
            PHAccessPoint autoConnect = null;
            for (PHAccessPoint point : accessPointsList) {
                Controller.this.bridges.add(point);
                logger.info("  > {} [{}]", (Object)point.getIpAddress(), (Object)point.getMacAddress());
                if (accessPointsList.size() != 1 && !point.getIpAddress().equalsIgnoreCase(Main.conf.getString("bridge.ip")) || username == null || username.isEmpty()) continue;
                autoConnect = point;
            }
            if (autoConnect != null) {
                autoConnect.setUsername(username);
                Controller.this.phHueSDK.connect(autoConnect);
            }
        }

        public void onCacheUpdated(List<Integer> list, PHBridge bridge) {
            logger.trace("Bridge cache updated");
            Controller.this.setCacheUpdated(System.currentTimeMillis());
        }

        public void onBridgeConnected(PHBridge bridge, String user) {
            logger.trace("Bridge connected");
            Controller.this.lastConnectedBridge = bridge;
            Controller.this.phHueSDK.setSelectedBridge(bridge);
            Controller.this.phHueSDK.enableHeartbeat(bridge, 10000L);
            String lastIpAddress = bridge.getResourceCache().getBridgeConfiguration().getIpAddress();
            logger.info("Connected to bridge: {} [{}]", (Object)lastIpAddress, (Object)user);
            Main.conf.setProperty("bridge.username", (Object)user);
            Main.conf.setProperty("bridge.ip", (Object)lastIpAddress);
            Main.saveConfig();
            if (Controller.this.isSyncEnabled) {
                Controller.this.al.startSync(true);
            }
        }

        public void onAuthenticationRequired(PHAccessPoint accessPoint) {
            logger.warn("Bridge '{}' requires authentication, press a button on this bridge within 30 seconds", (Object)accessPoint.getIpAddress());
            Controller.this.phHueSDK.startPushlinkAuthentication(accessPoint);
        }

        public void onConnectionLost(PHAccessPoint arg0) {
            logger.warn("Bridge connection lost");
            Controller.this.connectionLost = true;
            Controller.this.al.stopSync(false);
        }

        public void onParsingErrors(List<PHHueParsingError> list) {
            logger.warn("Parsing errors:");
            for (PHHueParsingError error : list) {
                logger.warn("{}", (Object)error.getMessage());
            }
        }

        public void onConnectionResumed(PHBridge arg0) {
            logger.trace("Bridge connection resumed");
            if (Controller.this.connectionLost) {
                Controller.this.connectionLost = false;
                if (Controller.this.isSyncEnabled) {
                    Controller.this.al.startSync(true);
                }
            }
        }

        public void onError(int code, String message) {
            logger.error("{} (code: {})", (Object)message, (Object)code);
        }
    };

    public static Controller getInstance() {
        return instance;
    }

    public void setSyncEnabled(boolean isSyncEnabled) {
        this.isSyncEnabled = isSyncEnabled;
    }

    private Controller() {
        this.phHueSDK = PHHueSDK.getInstance();
        this.phHueSDK.setAppName("HAmbiSync");
        this.phHueSDK.setDeviceName(System.getProperty("os.name"));
        this.al = AmbiSync.getInstance();
        this.isSyncEnabled = Main.conf.getBoolean("sync.autostart");
    }

    public synchronized List<PHAccessPoint> getBridges() {
        return this.bridges;
    }

    public void findBridges() {
        logger.info("Searching for bridges, please wait...");
        PHBridgeSearchManager sm = (PHBridgeSearchManager)this.phHueSDK.getSDKService((byte)1);
        sm.search(true, true);
    }

    public void shutdown() {
        if (this.lastConnectedBridge != null) {
            this.phHueSDK.disableHeartbeat(this.lastConnectedBridge);
            this.phHueSDK.disconnect(this.lastConnectedBridge);
        }
        this.phHueSDK.destroySDK();
    }

    public synchronized long getCacheUpdated() {
        return this.cacheUpdated;
    }

    public synchronized void setCacheUpdated(long cacheUpdated) {
        this.cacheUpdated = cacheUpdated;
    }

    public PHSDKListener getListener() {
        return this.listener;
    }

    public boolean connectToLastKnownAccessPoint() {
        String username = Main.conf.getString("bridge.username");
        String lastIpAddress = Main.conf.getString("bridge.ip");
        if (username == null || lastIpAddress == null || username.isEmpty() || lastIpAddress.isEmpty()) {
            logger.error("Missing Last Username or Last IP.  Last known connection not found.");
            return false;
        }
        PHAccessPoint accessPoint = new PHAccessPoint();
        accessPoint.setIpAddress(lastIpAddress);
        accessPoint.setUsername(username);
        this.phHueSDK.connect(accessPoint);
        return true;
    }

    public static void delay() {
        int delay = Main.conf.getInt("bridge.update.delay");
        if (delay > 0) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static void delay(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

