/*
 * Decompiled with CFR 0.152.
 */
package ru.org.amip.ambisync;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.org.amip.ambisync.Main;
import ru.org.amip.ambisync.RGB;
import ru.org.amip.ambisync.config.Lamp;

public class AmbilightUtil {
    private static final Logger logger = LoggerFactory.getLogger(AmbilightUtil.class);

    public static RGB getAverageColor(Lamp l, JsonObject data) {
        String layer = Main.conf.getString("tv.ambi.layer");
        Map<String, ArrayList<Integer>> sideLeds = l.getSideLeds();
        int r = 0;
        int g = 0;
        int b = 0;
        int count = 0;
        for (Map.Entry<String, ArrayList<Integer>> entry : sideLeds.entrySet()) {
            String side = entry.getKey();
            ArrayList<Integer> leds = entry.getValue();
            for (Integer led : leds) {
                JsonObject jsLayer = data.get(layer).getAsJsonObject();
                if (jsLayer != null) {
                    JsonObject jsSide = jsLayer.get(side).getAsJsonObject();
                    if (jsSide != null) {
                        JsonObject rgb = jsSide.get(led.toString()).getAsJsonObject();
                        if (rgb != null) {
                            r += rgb.get("r").getAsInt();
                            g += rgb.get("g").getAsInt();
                            b += rgb.get("b").getAsInt();
                            ++count;
                            continue;
                        }
                        logger.error("LED number '{}' in layer `{}` on side `{}` is not preset in TV JSON response", new Object[]{led, layer, side});
                        continue;
                    }
                    logger.error("Side '{}' is not preset in TV JSON response", (Object)side);
                    continue;
                }
                logger.error("Layer '{}' is not preset in TV JSON response", (Object)layer);
            }
        }
        if (count == 0) {
            logger.error("Can't calculate average color, check your lamps/tv config!");
            return new RGB(0, 0, 0);
        }
        return new RGB(r / count, g / count, b / count);
    }
}

