/*
 * Decompiled with CFR 0.152.
 */
package ru.org.amip.ambisync;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.philips.lighting.hue.sdk.PHHueSDK;
import com.philips.lighting.model.PHBridge;
import com.philips.lighting.model.PHBridgeResourcesCache;
import com.philips.lighting.model.PHLight;
import com.philips.lighting.model.PHLightState;
import com.tpvision.ambilightplushue.helpers.Algorithm;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.org.amip.ambisync.AmbilightForcedSyncJob;
import ru.org.amip.ambisync.AmbilightSyncJob;
import ru.org.amip.ambisync.AmbilightUtil;
import ru.org.amip.ambisync.Controller;
import ru.org.amip.ambisync.Main;
import ru.org.amip.ambisync.RGB;
import ru.org.amip.ambisync.StandbyException;
import ru.org.amip.ambisync.config.Lamp;
import ru.org.amip.ambisync.config.LampConfig;

public class AmbiSync {
    private static final Logger logger = LoggerFactory.getLogger(AmbiSync.class);
    private static AmbiSync instance = new AmbiSync();
    public static final int MAX_ERRORS = Main.conf.getInt("tv.max.errors", 10);
    public static final int TV_TIMEOUT = Main.conf.getInt("tv.timeout", 5000);
    private String tvUrl;
    private HttpGet httpget;
    private CloseableHttpClient client;
    private ResponseHandler<JsonObject> rh;
    private HashMap<String, LampState> previousState = new HashMap();
    private HashMap<String, PHLightState> savedState = new HashMap();
    private HashMap<String, String> lampModel = new HashMap();
    private PHHueSDK phHueSDK = PHHueSDK.getInstance();
    private Scheduler scheduler;
    private volatile int syncErrors = 0;
    private volatile boolean running = false;
    private volatile Timer retryTimer;
    private volatile Map<String, Lamp> lamps = new LampConfig().load(Main.conf.getString("sync.preset"));
    private long syncStopped;
    private boolean detectStandby = Main.conf.getBoolean("sync.detect.standby", true);

    public synchronized long getSyncStopped() {
        return this.syncStopped;
    }

    public synchronized void setSyncStopped(long syncStopped) {
        this.syncStopped = syncStopped;
    }

    public boolean isRunning() {
        return this.running;
    }

    public static AmbiSync getInstance() {
        return instance;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setLampsConfig(final String config) {
        logger.info("Changing lamps config to '{}'", (Object)config);
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                boolean running = AmbiSync.this.isRunning();
                if (running) {
                    AmbiSync.this.stopSync(false);
                    Controller.delay(2000L);
                }
                Main.conf.setProperty("sync.preset", (Object)config);
                Main.saveConfig();
                AmbiSync.this.lamps = new LampConfig().load(Main.conf.getString("sync.preset"));
                if (running) {
                    AmbiSync.this.startSync(false);
                }
            }
        }, 0L);
    }

    private AmbiSync() {
        String tvIP = Main.conf.getString("tv.ip");
        if (tvIP == null || tvIP.isEmpty()) {
            logger.error("Please edit 'conf/application.conf' and set 'tv.ip' property");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Controller.delay(3000L);
                    System.exit(1);
                }
            }).start();
            return;
        }
        this.tvUrl = "http://" + tvIP + ":" + Main.conf.getString("tv.port") + Main.conf.getString("tv.ambi");
        logger.info("Ambilight TV URL: {}", (Object)this.tvUrl);
        RequestConfig.Builder requestBuilder = RequestConfig.custom();
        requestBuilder = requestBuilder.setConnectTimeout(TV_TIMEOUT);
        requestBuilder = requestBuilder.setConnectionRequestTimeout(TV_TIMEOUT);
        requestBuilder = requestBuilder.setSocketTimeout(TV_TIMEOUT);
        this.client = HttpClients.custom().setDefaultRequestConfig(requestBuilder.build()).build();
        this.httpget = new HttpGet(this.tvUrl);
        this.rh = new ResponseHandler<JsonObject>(){

            public JsonObject handleResponse(HttpResponse response) throws IOException {
                StatusLine statusLine = response.getStatusLine();
                HttpEntity entity = response.getEntity();
                if (statusLine.getStatusCode() >= 300) {
                    throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
                }
                if (entity == null) {
                    throw new ClientProtocolException("Response contains no content");
                }
                JsonParser parser = new JsonParser();
                ContentType contentType = ContentType.getOrDefault((HttpEntity)entity);
                Charset charset = contentType.getCharset();
                InputStreamReader reader = new InputStreamReader(entity.getContent(), charset);
                return (JsonObject)parser.parse((Reader)reader);
            }
        };
        this.prepareScheduler();
    }

    public TriggerKey schedulePeriodicJob(String name, Class<? extends Job> jobClass, int interval) throws SchedulerException {
        JobDetail job = JobBuilder.newJob(jobClass).withIdentity(name).build();
        SimpleTrigger trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(name + "-trigger").startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds((long)interval).repeatForever()).build();
        this.scheduler.scheduleJob(job, (Trigger)trigger);
        return trigger.getKey();
    }

    private void prepareScheduler() {
        try {
            this.scheduler = StdSchedulerFactory.getDefaultScheduler();
            this.schedulePeriodicJob("syncAmbilight", AmbilightSyncJob.class, Main.conf.getInt("sync.interval"));
            this.schedulePeriodicJob("forceSyncAmbilight", AmbilightForcedSyncJob.class, Main.conf.getInt("forced.sync.interval"));
        }
        catch (SchedulerException e) {
            logger.error("Scheduler error", (Throwable)e);
        }
    }

    public void saveLampsState() {
        logger.info("Saving current lamps state...");
        long updated = Controller.getInstance().getCacheUpdated();
        long stopped = this.getSyncStopped();
        logger.debug("Cache updated: {}, sync stopped: {}", (Object)new Date(updated), (Object)new Date(stopped));
        boolean save = true;
        if (updated - 20000L < stopped) {
            logger.info("Save aborted, lamp state cache can contain ambilight values");
            save = false;
        }
        PHBridge bridge = this.phHueSDK.getSelectedBridge();
        PHBridgeResourcesCache cache = bridge.getResourceCache();
        List allLights = cache.getAllLights();
        if (save) {
            this.savedState.clear();
            this.lampModel.clear();
        }
        for (PHLight light : allLights) {
            PHLightState state = new PHLightState(light.getLastKnownLightState());
            if (save) {
                this.savedState.put(light.getIdentifier(), state);
            }
            if (this.lamps.containsKey(light.getIdentifier())) {
                this.lampModel.put(light.getIdentifier(), light.getModelNumber());
                continue;
            }
            if (!Main.conf.getBoolean("sync.turn.off.other", false)) continue;
            PHLightState lightState = new PHLightState();
            lightState.setOn(Boolean.valueOf(false));
            bridge.updateLightState(light, lightState);
            Controller.delay();
        }
    }

    public void restoreLampsState() {
        logger.info("Restoring last lamps state...");
        for (int i = 0; i < 2; ++i) {
            for (Map.Entry<String, PHLightState> entry : this.savedState.entrySet()) {
                this.phHueSDK.getSelectedBridge().updateLightState(entry.getKey(), entry.getValue(), null);
                Controller.delay();
            }
            Controller.delay(1000L);
        }
    }

    public void setLampsState(boolean state) {
        logger.info("Turning {} lamps configured for synchronization...", (Object)(state ? "on" : "off"));
        PHBridge bridge = this.phHueSDK.getSelectedBridge();
        PHBridgeResourcesCache cache = bridge.getResourceCache();
        List allLights = cache.getAllLights();
        for (int i = 0; i < 2; ++i) {
            for (PHLight light : allLights) {
                logger.trace("{}", (Object)light);
                if (!this.lamps.containsKey(light.getIdentifier())) continue;
                PHLightState lightState = new PHLightState();
                lightState.setOn(Boolean.valueOf(state));
                bridge.updateLightState(light, lightState);
                Controller.delay();
            }
            Controller.delay(50L);
        }
    }

    public synchronized void update(boolean force) {
        block9: {
            try {
                JsonObject ambilightData = (JsonObject)this.client.execute((HttpUriRequest)this.httpget, this.rh);
                this.syncErrors = 0;
                int standbyModeColor = 0;
                for (Map.Entry<String, Lamp> entry : this.lamps.entrySet()) {
                    RGB color = AmbilightUtil.getAverageColor(entry.getValue(), ambilightData);
                    standbyModeColor += color.r + color.g + color.b;
                    String lid = entry.getKey();
                    LampState ps = this.previousState.get(lid);
                    if (!force && ps != null && ps.getColor().equalsWithOffset(color, Main.conf.getInt("rgb.offset"))) continue;
                    AtomicInteger outBrightness = new AtomicInteger();
                    Lamp lamp = this.lamps.get(lid);
                    String model = this.lampModel.get(lid);
                    if (model == null) {
                        model = lamp.getModel();
                    }
                    if (model == null) {
                        logger.warn("Lamp {} model is not detected, will default to LCT001", (Object)lid);
                        model = "LCT001";
                    }
                    float[] xy = Algorithm.convertRGBtoXY_final((float)((float)color.r / 255.0f), (float)((float)color.g / 255.0f), (float)((float)color.b / 255.0f), (int)0, (int)0, (int)0, (AtomicInteger)outBrightness, (int)lamp.getImmersion(), (int)lamp.getBrightness(), (String)model);
                    if (force || ps == null || ps.getX() != xy[0] || ps.getY() != xy[1] || ps.getBrightness() != outBrightness.get()) {
                        logger.trace("@{}@> {} => {},{},{}|{}", new Object[]{lid, color, Float.valueOf(xy[0]), Float.valueOf(xy[1]), outBrightness.get(), lamp.getTransition()});
                        PHLightState lightState = new PHLightState();
                        lightState.setX(Float.valueOf(xy[0]));
                        lightState.setY(Float.valueOf(xy[1]));
                        lightState.setBrightness(Integer.valueOf(outBrightness.get()));
                        lightState.setTransitionTime(Integer.valueOf(lamp.getTransition()));
                        if (!this.running) {
                            return;
                        }
                        this.phHueSDK.getSelectedBridge().updateLightState(lid, lightState, null);
                        Controller.delay();
                    }
                    this.previousState.put(lid, new LampState(xy[0], xy[1], outBrightness.get(), color));
                }
                if (this.detectStandby && force && this.lamps.size() > 0 && standbyModeColor == 0) {
                    throw new StandbyException("standby mode enabled");
                }
            }
            catch (Exception e) {
                logger.error("Can't get ambilight from TV: {}", (Object)e.getMessage());
                ++this.syncErrors;
                if (this.syncErrors <= MAX_ERRORS && !(e instanceof StandbyException)) break block9;
                if (!(e instanceof StandbyException)) {
                    logger.error("Maximum errors count ({}) reached, stopping sync", (Object)MAX_ERRORS);
                }
                this.stopSync(true);
                if (!Main.conf.getBoolean("sync.resume", true)) break block9;
                this.startSync(true);
            }
        }
    }

    public void startSync(final boolean check) {
        if (this.running) {
            return;
        }
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    if (check) {
                        logger.info("Checking for ambilight data at {}", (Object)AmbiSync.this.tvUrl);
                        JsonObject ambilightData = (JsonObject)AmbiSync.this.client.execute((HttpUriRequest)AmbiSync.this.httpget, AmbiSync.this.rh);
                        int standbyModeColor = 0;
                        for (Map.Entry entry : AmbiSync.this.lamps.entrySet()) {
                            RGB color = AmbilightUtil.getAverageColor((Lamp)entry.getValue(), ambilightData);
                            standbyModeColor += color.r + color.g + color.b;
                        }
                        if (standbyModeColor == 0) {
                            throw new StandbyException();
                        }
                        logger.info("TV is available, starting sync!");
                    }
                    AmbiSync.this._startSync();
                }
                catch (Exception e) {
                    int retry = Main.conf.getInt("tv.retry.interval", 60);
                    if (e instanceof IOException) {
                        logger.info("TV is not available, will try to ping it again in {} seconds", (Object)retry);
                    } else if (e instanceof StandbyException) {
                        logger.info("Ambilight data is all zeroes, standby mode is active");
                    }
                    AmbiSync.this.retryTimer = new Timer();
                    AmbiSync.this.retryTimer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            AmbiSync.this.startSync(true);
                        }
                    }, retry * 1000);
                }
            }
        }, 0L);
    }

    private void _startSync() {
        if (this.running) {
            return;
        }
        logger.info("Sync started");
        this.running = true;
        this.syncErrors = 0;
        if (Main.conf.getBoolean("sync.restore")) {
            this.saveLampsState();
        }
        this.setLampsState(true);
        try {
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            logger.error("Scheduler error", (Throwable)e);
        }
    }

    public void stopSync(final boolean abnormal) {
        if (this.retryTimer != null) {
            this.retryTimer.cancel();
        }
        if (!this.running) {
            return;
        }
        try {
            if (this.scheduler != null) {
                this.scheduler.standby();
            }
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
        this.running = false;
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                logger.info("Sync stopped");
                AmbiSync.this.setSyncStopped(System.currentTimeMillis());
                if (Main.conf.getBoolean("sync.restore")) {
                    AmbiSync.this.restoreLampsState();
                }
                Controller.delay(1000L);
                if (Main.conf.getBoolean("sync.lamps.off.on.stop", false)) {
                    AmbiSync.this.setLampsState(false);
                }
                if (abnormal && Main.conf.getBoolean("sync.lamps.off.on.error", true)) {
                    AmbiSync.this.setLampsState(false);
                }
            }
        }, 1000L);
    }

    private class LampState {
        float x;
        float y;
        int brightness;
        RGB color;

        private LampState(float x, float y, int brightness, RGB color) {
            this.x = x;
            this.y = y;
            this.brightness = brightness;
            this.color = color;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public int getBrightness() {
            return this.brightness;
        }

        public RGB getColor() {
            return this.color;
        }
    }
}

