/*
 * Decompiled with CFR 0.152.
 */
package com.tpvision.ambilightplushue.helpers;

import android.graphics.Color;
import android.graphics.PointF;
import android.util.FloatMath;
import com.tpvision.ambilightplushue.helpers.Algorithm;
import java.util.HashMap;
import java.util.Map;

public class ColorGamut {
    private static boolean checkPointInLampsReach(PointF pointF, Map<ColorType, PointF> map) {
        PointF pointF2 = new PointF(map.get((Object)((Object)ColorType.Lime)).x - map.get((Object)((Object)ColorType.Red)).x, map.get((Object)((Object)ColorType.Lime)).y - map.get((Object)((Object)ColorType.Red)).y);
        PointF pointF3 = new PointF(map.get((Object)((Object)ColorType.Blue)).x - map.get((Object)((Object)ColorType.Red)).x, map.get((Object)((Object)ColorType.Blue)).y - map.get((Object)((Object)ColorType.Red)).y);
        PointF pointF4 = new PointF(pointF.x - map.get((Object)((Object)ColorType.Red)).x, pointF.y - map.get((Object)((Object)ColorType.Red)).y);
        float f = ColorGamut.crossProduct(pointF4, pointF3) / ColorGamut.crossProduct(pointF2, pointF3);
        float f2 = ColorGamut.crossProduct(pointF2, pointF4) / ColorGamut.crossProduct(pointF2, pointF3);
        return f >= 0.0f && f2 >= 0.0f && f + f2 <= 1.0f;
    }

    private static float crossProduct(PointF pointF, PointF pointF2) {
        return pointF.x * pointF2.y - pointF.y * pointF2.x;
    }

    public static float[] fixXYColor(float f, float f2, String string) {
        float[] fArray = new float[]{f, f2};
        PointF pointF = new PointF(fArray[0], fArray[1]);
        Map<ColorType, PointF> map = ColorGamut.getReachPointForModel(string);
        if (!ColorGamut.checkPointInLampsReach(pointF, map)) {
            PointF pointF2 = ColorGamut.getClosestPoint(map.get((Object)ColorType.Red), map.get((Object)ColorType.Lime), pointF);
            PointF pointF3 = ColorGamut.getClosestPoint(map.get((Object)ColorType.Blue), map.get((Object)ColorType.Red), pointF);
            PointF pointF4 = ColorGamut.getClosestPoint(map.get((Object)ColorType.Lime), map.get((Object)ColorType.Blue), pointF);
            float f3 = ColorGamut.getDistanceBetweenTwoPoints(pointF, pointF2);
            float f4 = ColorGamut.getDistanceBetweenTwoPoints(pointF, pointF3);
            float f5 = ColorGamut.getDistanceBetweenTwoPoints(pointF, pointF4);
            float f6 = f3;
            PointF pointF5 = pointF2;
            if (f4 < f6) {
                f6 = f4;
                pointF5 = pointF3;
            }
            if (f5 < f6) {
                pointF5 = pointF4;
            }
            fArray[0] = pointF5.x;
            fArray[1] = pointF5.y;
        }
        return fArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static PointF getClosestPoint(PointF pointF, PointF pointF2, PointF pointF3) {
        PointF pointF4 = new PointF(pointF3.x - pointF.x, pointF3.y - pointF.y);
        PointF pointF5 = new PointF(pointF2.x - pointF.x, pointF2.y - pointF.y);
        float f = pointF5.x * pointF5.x + pointF5.y * pointF5.y;
        float f2 = (pointF4.x * pointF5.x + pointF4.y * pointF5.y) / f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
            return new PointF(pointF.x + f2 * pointF5.x, pointF.y + f2 * pointF5.y);
        }
        if (!(f2 > 1.0f)) return new PointF(pointF.x + f2 * pointF5.x, pointF.y + f2 * pointF5.y);
        f2 = 1.0f;
        return new PointF(pointF.x + f2 * pointF5.x, pointF.y + f2 * pointF5.y);
    }

    private static float getDistanceBetweenTwoPoints(PointF pointF, PointF pointF2) {
        float f = pointF.x - pointF2.x;
        float f2 = pointF.y - pointF2.y;
        return FloatMath.sqrt(f * f + f2 * f2);
    }

    private static Map<ColorType, PointF> getReachPointForModel(String string) {
        HashMap<ColorType, PointF> hashMap = new HashMap<ColorType, PointF>();
        switch (Algorithm.getModelType(string)) {
            default: {
                hashMap.put(ColorType.Red, new PointF(1.0f, 0.0f));
                hashMap.put(ColorType.Lime, new PointF(0.0f, 1.0f));
                hashMap.put(ColorType.Blue, new PointF(0.0f, 0.0f));
                return hashMap;
            }
            case 0: {
                hashMap.put(ColorType.Red, new PointF(0.675f, 0.322f));
                hashMap.put(ColorType.Lime, new PointF(0.4091f, 0.518f));
                hashMap.put(ColorType.Blue, new PointF(0.167f, 0.04f));
                return hashMap;
            }
            case 1: 
        }
        hashMap.put(ColorType.Red, new PointF(0.704f, 0.296f));
        hashMap.put(ColorType.Lime, new PointF(0.2151f, 0.7106f));
        hashMap.put(ColorType.Blue, new PointF(0.138f, 0.08f));
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static float[] xyFromColor(int n, String string) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7 = (float)Color.red(n) / 255.0f;
        float f8 = f7 > 0.04045f ? (float)Math.pow((0.055f + f7) / 1.055f, 2.4f) : f7 / 12.92f;
        float f9 = 0.4360747f * f8 + 0.3850649f * (f6 = (f5 = (float)Color.green(n) / 255.0f) > 0.04045f ? (float)Math.pow((0.055f + f5) / 1.055f, 2.4f) : f5 / 12.92f) + 0.0930804f * (f4 = (f3 = (float)Color.blue(n) / 255.0f) > 0.04045f ? (float)Math.pow((0.055f + f3) / 1.055f, 2.4f) : f3 / 12.92f);
        float[] fArray = new float[]{f9 / ((f2 = 0.0139322f * f8 + 0.0971045f * f6 + 0.7141733f * f4) + (f9 + (f = 0.2225045f * f8 + 0.7168786f * f6 + 0.0406169f * f4))), f / (f2 + (f9 + f))};
        if (Float.isNaN(fArray[0])) {
            fArray[0] = 0.0f;
        }
        if (Float.isNaN(fArray[1])) {
            fArray[1] = 0.0f;
        }
        return ColorGamut.fixXYColor(fArray[0], fArray[1], string);
    }

    private static final class ColorType
    extends Enum<ColorType> {
        public static final /* enum */ ColorType Blue;
        private static final /* synthetic */ ColorType[] ENUM$VALUES;
        public static final /* enum */ ColorType Lime;
        public static final /* enum */ ColorType Red;

        static {
            Red = new ColorType();
            Lime = new ColorType();
            Blue = new ColorType();
            ColorType[] colorTypeArray = new ColorType[]{Red, Lime, Blue};
            ENUM$VALUES = colorTypeArray;
        }

        public static ColorType valueOf(String string) {
            return Enum.valueOf(ColorType.class, string);
        }

        public static ColorType[] values() {
            ColorType[] colorTypeArray = ENUM$VALUES;
            int n = colorTypeArray.length;
            ColorType[] colorTypeArray2 = new ColorType[n];
            System.arraycopy(colorTypeArray, 0, colorTypeArray2, 0, n);
            return colorTypeArray2;
        }
    }
}

