/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.util.FloatMath;

public class PointF {
    public float x;
    public float y;

    public PointF() {
    }

    public PointF(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public final void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public final void set(PointF p) {
        this.x = p.x;
        this.y = p.y;
    }

    public final void negate() {
        this.x = -this.x;
        this.y = -this.y;
    }

    public final void offset(float dx, float dy) {
        this.x += dx;
        this.y += dy;
    }

    public final boolean equals(float x, float y) {
        return this.x == x && this.y == y;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PointF pointF = (PointF)o;
        if (Float.compare(pointF.x, this.x) != 0) {
            return false;
        }
        return Float.compare(pointF.y, this.y) == 0;
    }

    public int hashCode() {
        int result = this.x != 0.0f ? Float.floatToIntBits(this.x) : 0;
        result = 31 * result + (this.y != 0.0f ? Float.floatToIntBits(this.y) : 0);
        return result;
    }

    public String toString() {
        return "PointF(" + this.x + ", " + this.y + ")";
    }

    public final float length() {
        return PointF.length(this.x, this.y);
    }

    public static float length(float x, float y) {
        return FloatMath.sqrt(x * x + y * y);
    }
}

