/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.model;

import com.philips.lighting.annotations.Bridge;
import com.philips.lighting.model.PHLight;

public class PHLightState {
    private static final int BRIGHTNESS_MAX = 254;
    private static final int BRIGHTNESS_MIN = 0;
    private static final int HUE_MAX = 65535;
    private static final int HUE_MIN = 0;
    private static final int SATURATION_MAX = 254;
    private static final int SATURATION_MIN = 0;
    private static final int CT_MAX = 500;
    private static final int CT_MIN = 153;
    private static final float XY_MAX = 1.0f;
    private static final float XY_MIN = 0.0f;
    private static final int TRANSITION_TIME_MAX = 65535;
    private static final int TRANSITION_TIME_MIN = 0;
    private static final int BRI_INC_MAX = 254;
    private static final int BRI_INC_MIN = -254;
    private static final int SAT_INC_MAX = 254;
    private static final int SAT_INC_MIN = -254;
    private static final int HUE_INC_MAX = 65534;
    private static final int HUE_INC_MIN = -65534;
    private static final int CT_INC_MAX = 65534;
    private static final int CT_INC_MIN = -65534;
    private static final float XY_INC_MAX = 0.5f;
    private static final float XY_INC_MIN = -0.5f;
    @Bridge(name="on")
    private Boolean on;
    @Bridge(name="bri")
    private Integer brightness = null;
    @Bridge(name="hue")
    private Integer hue = null;
    @Bridge(name="sat")
    private Integer saturation = null;
    @Bridge(name="ct")
    private Integer ct = null;
    @Bridge(name="alert")
    private PHLight.PHLightAlertMode alert = PHLight.PHLightAlertMode.ALERT_UNKNOWN;
    @Bridge(name="effect")
    private PHLight.PHLightEffectMode effect = PHLight.PHLightEffectMode.EFFECT_UNKNOWN;
    @Bridge(name="transitiontime")
    private Integer transitionTime = null;
    private Integer incrementBri;
    private Integer incrementCt;
    private Integer incrementHue;
    private Integer incrementSat;
    private Float incrementX;
    private Float incrementY;
    @Bridge(name="reachable")
    private Boolean isReachable;
    private Float x = null;
    private Float y = null;
    private PHLight.PHLightColorMode colormode = PHLight.PHLightColorMode.COLORMODE_UNKNOWN;

    public PHLightState() {
    }

    public PHLightState(PHLightState lightState) {
        if (lightState == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        this.alert = lightState.alert;
        this.brightness = lightState.brightness;
        this.colormode = lightState.colormode;
        this.ct = lightState.ct;
        this.effect = lightState.effect;
        this.hue = lightState.hue;
        this.on = lightState.on;
        this.saturation = lightState.saturation;
        this.transitionTime = lightState.transitionTime;
        this.x = lightState.x;
        this.y = lightState.y;
        this.isReachable = lightState.isReachable;
    }

    public Boolean isOn() {
        return this.on;
    }

    public void setOn(Boolean on) {
        this.on = on;
    }

    public Integer getBrightness() {
        return this.brightness;
    }

    public void setBrightness(Integer brightness) {
        this.setBrightness(brightness, false);
    }

    public void setBrightness(Integer bri, boolean clipToRange) {
        if (clipToRange && bri != null) {
            if (bri > 254) {
                bri = 254;
            } else if (bri < 0) {
                bri = 0;
            }
        }
        this.brightness = bri;
    }

    public Integer getHue() {
        return this.hue;
    }

    public void setHue(Integer hue) {
        this.setHue(hue, false);
    }

    public void setHue(Integer hueParam, boolean clipToRange) {
        if (clipToRange && hueParam != null) {
            if (hueParam > 65535) {
                hueParam = hueParam - 65535;
                hueParam = hueParam - 1;
            } else if (hueParam < 0) {
                hueParam = hueParam + 65535;
                hueParam = hueParam + 1;
            }
        }
        this.hue = hueParam;
    }

    public Integer getSaturation() {
        return this.saturation;
    }

    public void setSaturation(Integer saturation) {
        this.saturation = saturation;
    }

    public void setSaturation(Integer sat, boolean clipToRange) {
        if (clipToRange && sat != null) {
            if (sat > 254) {
                sat = 254;
            } else if (sat < 0) {
                sat = 254;
            }
        }
        this.saturation = sat;
    }

    public Integer getCt() {
        return this.ct;
    }

    public void setCt(Integer ct) {
        this.setCt(ct, false);
    }

    public void setCt(Integer ct, boolean clipToRange) {
        if (clipToRange && ct != null) {
            if (ct > 500) {
                ct = 500;
            } else if (ct < 153) {
                ct = 153;
            }
        }
        this.ct = ct;
    }

    public PHLight.PHLightAlertMode getAlertMode() {
        return this.alert;
    }

    public PHLight.PHLightEffectMode getEffectMode() {
        return this.effect;
    }

    public Integer getTransitionTime() {
        return this.transitionTime;
    }

    public void setTransitionTime(Integer transitionTime) {
        this.transitionTime = transitionTime;
    }

    public Float getX() {
        return this.x;
    }

    public void setX(Float x) {
        this.setX(x, false);
    }

    public void setX(Float x, boolean clipToRange) {
        if (clipToRange && this.ct != null) {
            if (x.floatValue() > 1.0f) {
                x = Float.valueOf(1.0f);
            } else if (x.floatValue() < 0.0f) {
                x = Float.valueOf(0.0f);
            }
        }
        this.x = x;
    }

    public Float getY() {
        return this.y;
    }

    public void setY(Float y) {
        this.setY(y, false);
    }

    public void setY(Float y, boolean clipToRange) {
        if (clipToRange && this.ct != null) {
            if (y.floatValue() > 1.0f) {
                y = Float.valueOf(1.0f);
            } else if (y.floatValue() < 0.0f) {
                y = Float.valueOf(0.0f);
            }
        }
        this.y = y;
    }

    public PHLight.PHLightColorMode getColorMode() {
        return this.colormode;
    }

    public void setAlertMode(PHLight.PHLightAlertMode alert) {
        this.alert = alert;
    }

    public void setEffectMode(PHLight.PHLightEffectMode effect) {
        this.effect = effect;
    }

    public void setColorMode(PHLight.PHLightColorMode mode) {
        this.colormode = mode;
    }

    public String validateState() {
        if (this.brightness != null && (this.brightness < 0 || this.brightness > 254)) {
            return "brightness should be a value between 0 and 254";
        }
        if (this.hue != null && (this.hue < 0 || this.hue > 65535)) {
            return "hue should be a value between 0 and 65535";
        }
        if (this.saturation != null && (this.saturation < 0 || this.saturation > 254)) {
            return "saturation should be a value between 0 and 254";
        }
        if (this.ct != null && (this.ct < 153 || this.ct > 500)) {
            return "color temperature should be a value between 153 and 500";
        }
        if (this.x != null && this.y == null || this.x == null && this.y != null) {
            return "x and y need both to be set";
        }
        if (this.x != null && this.y != null) {
            if (this.x.floatValue() < 0.0f || this.x.floatValue() > 1.0f) {
                return "x should be a value between 0.0 and1.0";
            }
            if (this.y.floatValue() < 0.0f || this.y.floatValue() > 1.0f) {
                return "y should be a value betwee n0.0 and1.0";
            }
        }
        if (this.alert != null && (this.alert.ordinal() < PHLight.PHLightAlertMode.ALERT_UNKNOWN.ordinal() || this.alert.ordinal() > PHLight.PHLightAlertMode.ALERT_LSELECT.ordinal())) {
            return "alert mode is invalid";
        }
        if (this.effect != null && (this.effect.ordinal() < PHLight.PHLightEffectMode.EFFECT_UNKNOWN.ordinal() || this.effect.ordinal() > PHLight.PHLightEffectMode.EFFECT_COLORLOOP.ordinal())) {
            return "effect mode is invalid";
        }
        if (this.transitionTime != null && (this.transitionTime < 0 || this.transitionTime > 65535)) {
            return "transition time should be a value between0 and65535";
        }
        if (this.incrementBri != null && (this.incrementBri < -254 || this.incrementBri > 254)) {
            return "bri_inc should be a value between  -254 and 254";
        }
        if (this.incrementCt != null && (this.incrementCt < -65534 || this.incrementCt > 65534)) {
            return "ct_inc should be a value between -65534 and 65534";
        }
        if (this.incrementHue != null && (this.incrementHue < -65534 || this.incrementHue > 65534)) {
            return "hue_inc should be a value between -65534 and 65534";
        }
        if (this.incrementSat != null && (this.incrementSat < -254 || this.incrementSat > 254)) {
            return "sat_inc should be a value between -254 and 254";
        }
        if (this.incrementX != null && (this.incrementX.floatValue() < -0.5f || this.incrementX.floatValue() > 0.5f)) {
            return "xy_inc should be a value between -0.5 and 0.5";
        }
        if (this.incrementY != null && (this.incrementY.floatValue() < -0.5f || this.incrementY.floatValue() > 0.5f)) {
            return "xy_inc should be a value between -0.5 and 0.5";
        }
        return null;
    }

    public Boolean isReachable() {
        return this.isReachable;
    }

    public void setReachable(Boolean isReachable) {
        this.isReachable = isReachable;
    }

    public Integer getIncrementBri() {
        return this.incrementBri;
    }

    public void setIncrementBri(Integer incrementBri) {
        this.incrementBri = incrementBri;
    }

    public Integer getIncrementCt() {
        return this.incrementCt;
    }

    public void setIncrementCt(Integer incrementCt) {
        this.incrementCt = incrementCt;
    }

    public Integer getIncrementHue() {
        return this.incrementHue;
    }

    public void setIncrementHue(Integer incrementHue) {
        this.incrementHue = incrementHue;
    }

    public Integer getIncrementSat() {
        return this.incrementSat;
    }

    public void setIncrementSat(Integer incrementSat) {
        this.incrementSat = incrementSat;
    }

    public Float getIncrementX() {
        return this.incrementX;
    }

    public void setIncrementX(Float incrementX) {
        this.incrementX = incrementX;
    }

    public Float getIncrementY() {
        return this.incrementY;
    }

    public void setIncrementY(Float incrementY) {
        this.incrementY = incrementY;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alert == null ? 0 : this.alert.hashCode());
        result = 31 * result + (this.brightness == null ? 0 : this.brightness.hashCode());
        result = 31 * result + (this.colormode == null ? 0 : this.colormode.hashCode());
        result = 31 * result + (this.ct == null ? 0 : this.ct.hashCode());
        result = 31 * result + (this.effect == null ? 0 : this.effect.hashCode());
        result = 31 * result + (this.hue == null ? 0 : this.hue.hashCode());
        result = 31 * result + (this.incrementBri == null ? 0 : this.incrementBri.hashCode());
        result = 31 * result + (this.incrementCt == null ? 0 : this.incrementCt.hashCode());
        result = 31 * result + (this.incrementHue == null ? 0 : this.incrementHue.hashCode());
        result = 31 * result + (this.incrementSat == null ? 0 : this.incrementSat.hashCode());
        result = 31 * result + (this.incrementX == null ? 0 : this.incrementX.hashCode());
        result = 31 * result + (this.incrementY == null ? 0 : this.incrementY.hashCode());
        result = 31 * result + (this.on == null ? 0 : this.on.hashCode());
        result = 31 * result + (this.saturation == null ? 0 : this.saturation.hashCode());
        result = 31 * result + (this.transitionTime == null ? 0 : this.transitionTime.hashCode());
        result = 31 * result + (this.x == null ? 0 : this.x.hashCode());
        result = 31 * result + (this.y == null ? 0 : this.y.hashCode());
        result = 31 * result + (this.isReachable == null ? 0 : this.isReachable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PHLightState other = (PHLightState)obj;
        if (this.alert != other.alert) {
            return false;
        }
        if (this.brightness == null ? other.brightness != null : !this.brightness.equals(other.brightness)) {
            return false;
        }
        if (this.colormode != other.colormode) {
            return false;
        }
        if (this.ct == null ? other.ct != null : !this.ct.equals(other.ct)) {
            return false;
        }
        if (this.effect != other.effect) {
            return false;
        }
        if (this.hue == null ? other.hue != null : !this.hue.equals(other.hue)) {
            return false;
        }
        if (this.incrementBri == null ? other.incrementBri != null : !this.incrementBri.equals(other.incrementBri)) {
            return false;
        }
        if (this.incrementCt == null ? other.incrementCt != null : !this.incrementCt.equals(other.incrementCt)) {
            return false;
        }
        if (this.incrementHue == null ? other.incrementHue != null : !this.incrementHue.equals(other.incrementHue)) {
            return false;
        }
        if (this.incrementSat == null ? other.incrementSat != null : !this.incrementSat.equals(other.incrementSat)) {
            return false;
        }
        if (this.incrementX == null ? other.incrementX != null : !this.incrementX.equals(other.incrementX)) {
            return false;
        }
        if (this.incrementY == null ? other.incrementY != null : !this.incrementY.equals(other.incrementY)) {
            return false;
        }
        if (this.isReachable == null ? other.isReachable != null : !this.isReachable.equals(other.isReachable)) {
            return false;
        }
        if (this.on == null ? other.on != null : !this.on.equals(other.on)) {
            return false;
        }
        if (this.saturation == null ? other.saturation != null : !this.saturation.equals(other.saturation)) {
            return false;
        }
        if (this.transitionTime == null ? other.transitionTime != null : !this.transitionTime.equals(other.transitionTime)) {
            return false;
        }
        if (this.x == null ? other.x != null : !this.x.equals(other.x)) {
            return false;
        }
        return !(this.y == null ? other.y != null : !this.y.equals(other.y));
    }
}

