/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.model;

import com.philips.lighting.model.PHBridgeResource;
import java.util.List;

public class PHGroup
extends PHBridgeResource {
    private String type;
    private String modelId;
    private String uniqueId;
    private PHGroupClass groupClass;
    private List<String> lightIdentifiers;

    public PHGroup() {
        super("", "");
    }

    public PHGroup(String name, String identifier) {
        super(name, identifier);
    }

    public PHGroup(PHGroup group) {
        super(PHGroup.isNull(group).getName(), PHGroup.isNull(group).getIdentifier());
        this.lightIdentifiers = group.lightIdentifiers;
    }

    public List<String> getLightIdentifiers() {
        return this.lightIdentifiers;
    }

    public void setLightIdentifiers(List<String> lightIdentifiers) {
        this.lightIdentifiers = lightIdentifiers;
    }

    private static PHGroup isNull(PHGroup group) {
        if (group == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        return group;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getModelId() {
        return this.modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public PHGroupClass getGroupClass() {
        return this.groupClass;
    }

    public void setGroupClass(PHGroupClass groupClass) {
        this.groupClass = groupClass;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.lightIdentifiers == null ? 0 : this.lightIdentifiers.hashCode());
        result = 31 * result + (this.modelId == null ? 0 : this.modelId.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PHGroup other = (PHGroup)obj;
        if (this.lightIdentifiers == null ? other.lightIdentifiers != null : !this.lightIdentifiers.equals(other.lightIdentifiers)) {
            return false;
        }
        if (this.modelId == null ? other.modelId != null : !this.modelId.equals(other.modelId)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public static enum PHGroupClass {
        CLASS_LIVING_ROOM("Living room"),
        CLASS_KITCHEN("Kitchen"),
        CLASS_DINING("Dining"),
        CLASS_BEDROOM("Bedroom"),
        CLASS_KIDS_BEDROOM("Kids bedroom"),
        CLASS_BATHROOM("Bathroom"),
        CLASS_NURSERY("Nursery"),
        CLASS_RECREATION("Recreation"),
        CLASS_OFFICE("Office"),
        CLASS_GYM("Gym"),
        CLASS_HALLWAY("Hallway"),
        CLASS_TOILET("Toilet"),
        CLASS_FRONT_DOOR("Front door"),
        CLASS_GARAGE("Garage"),
        CLASS_TERRACE("Terrace"),
        CLASS_GARDEN("Garden"),
        CLASS_DRIVEWAY("Driveway"),
        CLASS_CARPORT("Carport"),
        CLASS_OTHER("Other");

        private String value;

        private PHGroupClass(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static PHGroupClass fromString(String value) {
            if (value.equals(CLASS_BATHROOM.getValue())) {
                return CLASS_BATHROOM;
            }
            if (value.equals(CLASS_BEDROOM.getValue())) {
                return CLASS_BEDROOM;
            }
            if (value.equals(CLASS_CARPORT.getValue())) {
                return CLASS_CARPORT;
            }
            if (value.equals(CLASS_DINING.getValue())) {
                return CLASS_DINING;
            }
            if (value.equals(CLASS_DRIVEWAY.getValue())) {
                return CLASS_DRIVEWAY;
            }
            if (value.equals(CLASS_FRONT_DOOR.getValue())) {
                return CLASS_FRONT_DOOR;
            }
            if (value.equals(CLASS_GARAGE.getValue())) {
                return CLASS_GARAGE;
            }
            if (value.equals(CLASS_GARDEN.getValue())) {
                return CLASS_GARDEN;
            }
            if (value.equals(CLASS_GYM.getValue())) {
                return CLASS_GYM;
            }
            if (value.equals(CLASS_HALLWAY.getValue())) {
                return CLASS_HALLWAY;
            }
            if (value.equals(CLASS_KIDS_BEDROOM.getValue())) {
                return CLASS_KIDS_BEDROOM;
            }
            if (value.equals(CLASS_KITCHEN.getValue())) {
                return CLASS_KITCHEN;
            }
            if (value.equals(CLASS_LIVING_ROOM.getValue())) {
                return CLASS_LIVING_ROOM;
            }
            if (value.equals(CLASS_NURSERY.getValue())) {
                return CLASS_NURSERY;
            }
            if (value.equals(CLASS_OFFICE.getValue())) {
                return CLASS_OFFICE;
            }
            if (value.equals(CLASS_OTHER.getValue())) {
                return CLASS_OTHER;
            }
            if (value.equals(CLASS_RECREATION.getValue())) {
                return CLASS_RECREATION;
            }
            if (value.equals(CLASS_TERRACE.getValue())) {
                return CLASS_TERRACE;
            }
            if (value.equals(CLASS_TOILET.getValue())) {
                return CLASS_TOILET;
            }
            return CLASS_OTHER;
        }
    }
}

