/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.model;

import com.philips.lighting.annotations.Bridge;
import com.philips.lighting.model.PHBackup;
import com.philips.lighting.model.PHBridgeResource;
import com.philips.lighting.model.PHPortalState;
import com.philips.lighting.model.PHSoftwareUpdateStatus;
import com.philips.lighting.model.PHWhiteListEntry;
import java.util.ArrayList;

public class PHBridgeConfiguration
extends PHBridgeResource {
    public static final int VALUE_NOT_SET = -55;
    private String ipAddress;
    private String macAddress;
    private String modelId;
    private String userName;
    private String proxy;
    private int proxyPort = -55;
    private String softwareVersion;
    private String apiVersion = null;
    private String netmask;
    private String gateway;
    private Boolean dhcpEnabled;
    private Boolean portalServicesEnabled;
    private Boolean touchlink;
    @Bridge(name="time")
    private String time;
    @Bridge(name="localtime")
    private String localTime;
    private String timeZone;
    private PHSoftwareUpdateStatus softwareStatus;
    private String bridgeID;
    private ArrayList<PHWhiteListEntry> whiteListEntries = new ArrayList();
    private PHPortalState portalState = null;
    private boolean reboot = false;
    private Integer zigbeeChannel = null;
    private Boolean checkForUpdate = null;
    private boolean factoryNew;
    private String replacesBridgeId;
    private PHBackup backup;

    public PHBridgeConfiguration() {
        super(null, null);
    }

    public PHBridgeConfiguration(PHBridgeConfiguration bridgeConfiguration) {
        super(bridgeConfiguration.getName(), bridgeConfiguration.getIdentifier());
        this.bridgeID = bridgeConfiguration.bridgeID;
        this.replacesBridgeId = bridgeConfiguration.replacesBridgeId;
        this.factoryNew = bridgeConfiguration.factoryNew;
        this.dhcpEnabled = bridgeConfiguration.dhcpEnabled;
        this.gateway = bridgeConfiguration.gateway;
        this.ipAddress = bridgeConfiguration.ipAddress;
        this.macAddress = bridgeConfiguration.macAddress;
        this.netmask = bridgeConfiguration.netmask;
        this.portalServicesEnabled = bridgeConfiguration.portalServicesEnabled;
        this.proxy = bridgeConfiguration.proxy;
        this.proxyPort = bridgeConfiguration.proxyPort;
        this.softwareStatus = bridgeConfiguration.softwareStatus;
        this.softwareVersion = bridgeConfiguration.softwareVersion;
        this.apiVersion = bridgeConfiguration.apiVersion;
        this.time = bridgeConfiguration.time;
        this.localTime = bridgeConfiguration.localTime;
        this.timeZone = bridgeConfiguration.timeZone;
        this.userName = bridgeConfiguration.userName;
        this.whiteListEntries = bridgeConfiguration.whiteListEntries;
        this.portalState = bridgeConfiguration.portalState;
        this.reboot = bridgeConfiguration.reboot;
        this.zigbeeChannel = bridgeConfiguration.zigbeeChannel;
        this.checkForUpdate = bridgeConfiguration.checkForUpdate;
        this.backup = bridgeConfiguration.backup;
    }

    public Boolean getDhcpEnabled() {
        return this.dhcpEnabled;
    }

    public void setDhcpEnabled(Boolean dhcpEnabled) {
        this.dhcpEnabled = dhcpEnabled;
    }

    public Boolean getPortalServicesEnabled() {
        return this.portalServicesEnabled;
    }

    public void setPortalServicesEnabled(Boolean portalServicesEnabled) {
        this.portalServicesEnabled = portalServicesEnabled;
    }

    public Boolean getTouchlink() {
        return this.touchlink;
    }

    public void setTouchlink(Boolean touchlink) {
        this.touchlink = touchlink;
    }

    public PHSoftwareUpdateStatus getSoftwareStatus() {
        return this.softwareStatus;
    }

    public void setSoftwareStatus(PHSoftwareUpdateStatus softwareStatus) {
        this.softwareStatus = softwareStatus;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public String getUsername() {
        return this.userName;
    }

    public void setUserName(String key) {
        this.userName = key;
    }

    public String getProxy() {
        return this.proxy;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public void setSoftwareVersion(String softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public String getNetmask() {
        return this.netmask;
    }

    public void setNetmask(String netmask) {
        this.netmask = netmask;
    }

    public String getGateway() {
        return this.gateway;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public String getLocalTime() {
        return this.localTime;
    }

    public void setLocalTime(String localTime) {
        this.localTime = localTime;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String getBridgeID() {
        if (this.bridgeID != null) {
            return this.bridgeID;
        }
        if (this.macAddress == null) {
            return null;
        }
        String stringWithoutColons = this.macAddress.replace(":", "");
        if (stringWithoutColons.length() != 12) {
            return this.macAddress;
        }
        String bridgeId = stringWithoutColons.substring(0, 6) + "FFFE" + stringWithoutColons.substring(6);
        return bridgeId.toUpperCase();
    }

    public void setBridgeID(String bridgeID) {
        this.bridgeID = bridgeID != null ? bridgeID.toUpperCase() : bridgeID;
    }

    public void setAPIVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getAPIVersion() {
        return this.apiVersion;
    }

    public ArrayList<PHWhiteListEntry> getWhiteListEntries() {
        return this.whiteListEntries;
    }

    public void setWhiteListEntries(ArrayList<PHWhiteListEntry> whiteListEntries) {
        this.whiteListEntries = whiteListEntries;
    }

    public PHPortalState getPortalState() {
        return this.portalState;
    }

    public void setPortalState(PHPortalState portalState) {
        this.portalState = portalState;
    }

    public boolean isReboot() {
        return this.reboot;
    }

    public void setReboot(boolean reboot) {
        this.reboot = reboot;
    }

    public Integer getZigbeeChannel() {
        return this.zigbeeChannel;
    }

    public void setZigbeeChannel(Integer zigbeeChannel) {
        this.zigbeeChannel = zigbeeChannel;
    }

    public Boolean getCheckForUpdate() {
        return this.checkForUpdate;
    }

    public void setCheckForUpdate(Boolean checkForUpdate) {
        this.checkForUpdate = checkForUpdate;
    }

    public String getModelId() {
        return this.modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public boolean getFactoryNew() {
        return this.factoryNew;
    }

    public void setFactoryNew(boolean factoryNew) {
        this.factoryNew = factoryNew;
    }

    public String getReplacesBridgeId() {
        return this.replacesBridgeId;
    }

    public void setReplacesBridgeId(String replacesBridgeId) {
        this.replacesBridgeId = replacesBridgeId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.apiVersion == null ? 0 : this.apiVersion.hashCode());
        result = 31 * result + (this.bridgeID == null ? 0 : this.bridgeID.hashCode());
        result = 31 * result + (this.checkForUpdate == null ? 0 : this.checkForUpdate.hashCode());
        result = 31 * result + (this.dhcpEnabled == null ? 0 : this.dhcpEnabled.hashCode());
        result = 31 * result + (this.gateway == null ? 0 : this.gateway.hashCode());
        result = 31 * result + (this.ipAddress == null ? 0 : this.ipAddress.hashCode());
        result = 31 * result + (this.localTime == null ? 0 : this.localTime.hashCode());
        result = 31 * result + (this.macAddress == null ? 0 : this.macAddress.hashCode());
        result = 31 * result + (this.modelId == null ? 0 : this.modelId.hashCode());
        result = 31 * result + (this.netmask == null ? 0 : this.netmask.hashCode());
        result = 31 * result + (this.portalServicesEnabled == null ? 0 : this.portalServicesEnabled.hashCode());
        result = 31 * result + (this.portalState == null ? 0 : this.portalState.hashCode());
        result = 31 * result + (this.proxy == null ? 0 : this.proxy.hashCode());
        result = 31 * result + this.proxyPort;
        result = 31 * result + (this.reboot ? 1231 : 1237);
        result = 31 * result + (this.softwareStatus == null ? 0 : this.softwareStatus.hashCode());
        result = 31 * result + (this.backup == null ? 0 : this.backup.hashCode());
        result = 31 * result + (this.softwareVersion == null ? 0 : this.softwareVersion.hashCode());
        result = 31 * result + (this.time == null ? 0 : this.time.hashCode());
        result = 31 * result + (this.timeZone == null ? 0 : this.timeZone.hashCode());
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        result = 31 * result + (this.whiteListEntries == null ? 0 : this.whiteListEntries.hashCode());
        result = 31 * result + (this.zigbeeChannel == null ? 0 : this.zigbeeChannel.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PHBridgeConfiguration other = (PHBridgeConfiguration)obj;
        if (this.apiVersion == null ? other.apiVersion != null : !this.apiVersion.equals(other.apiVersion)) {
            return false;
        }
        if (this.bridgeID == null ? other.bridgeID != null : !this.bridgeID.equals(other.bridgeID)) {
            return false;
        }
        if (this.checkForUpdate == null ? other.checkForUpdate != null : !this.checkForUpdate.equals(other.checkForUpdate)) {
            return false;
        }
        if (this.dhcpEnabled == null ? other.dhcpEnabled != null : !this.dhcpEnabled.equals(other.dhcpEnabled)) {
            return false;
        }
        if (this.gateway == null ? other.gateway != null : !this.gateway.equals(other.gateway)) {
            return false;
        }
        if (this.ipAddress == null ? other.ipAddress != null : !this.ipAddress.equals(other.ipAddress)) {
            return false;
        }
        if (this.macAddress == null ? other.macAddress != null : !this.macAddress.equals(other.macAddress)) {
            return false;
        }
        if (this.modelId == null ? other.modelId != null : !this.modelId.equals(other.modelId)) {
            return false;
        }
        if (this.netmask == null ? other.netmask != null : !this.netmask.equals(other.netmask)) {
            return false;
        }
        if (this.portalServicesEnabled == null ? other.portalServicesEnabled != null : !this.portalServicesEnabled.equals(other.portalServicesEnabled)) {
            return false;
        }
        if (this.portalState == null ? other.portalState != null : !this.portalState.equals(other.portalState)) {
            return false;
        }
        if (this.proxy == null ? other.proxy != null : !this.proxy.equals(other.proxy)) {
            return false;
        }
        if (this.proxyPort != other.proxyPort) {
            return false;
        }
        if (this.reboot != other.reboot) {
            return false;
        }
        if (this.softwareStatus == null ? other.softwareStatus != null : !this.softwareStatus.equals(other.softwareStatus)) {
            return false;
        }
        if (this.backup == null ? other.backup != null : !this.backup.equals(other.backup)) {
            return false;
        }
        if (this.softwareVersion == null ? other.softwareVersion != null : !this.softwareVersion.equals(other.softwareVersion)) {
            return false;
        }
        if (this.timeZone == null ? other.timeZone != null : !this.timeZone.equals(other.timeZone)) {
            return false;
        }
        if (this.userName == null ? other.userName != null : !this.userName.equals(other.userName)) {
            return false;
        }
        if (this.whiteListEntries == null ? other.whiteListEntries != null : !this.whiteListEntries.equals(other.whiteListEntries)) {
            return false;
        }
        return !(this.zigbeeChannel == null ? other.zigbeeChannel != null : !this.zigbeeChannel.equals(other.zigbeeChannel));
    }

    public PHBackup getBackup() {
        return this.backup;
    }

    public void setBackup(PHBackup backup) {
        this.backup = backup;
    }
}

