/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.utilities.impl;

import java.util.HashMap;
import java.util.Locale;

public class Color {
    public static final int BLACK = -16777216;
    public static final int DKGRAY = -12303292;
    public static final int GRAY = -7829368;
    public static final int LTGRAY = -3355444;
    public static final int WHITE = -1;
    public static final int RED = -65536;
    public static final int GREEN = -16711936;
    public static final int BLUE = -16776961;
    public static final int YELLOW = -256;
    public static final int CYAN = -16711681;
    public static final int MAGENTA = -65281;
    public static final int TRANSPARENT = 0;
    private static final HashMap<String, Integer> sColorNameMap = new HashMap();

    public static int alpha(int color) {
        return color >>> 24;
    }

    public static int red(int color) {
        return color >> 16 & 0xFF;
    }

    public static int green(int color) {
        return color >> 8 & 0xFF;
    }

    public static int blue(int color) {
        return color & 0xFF;
    }

    public static int rgb(int red, int green, int blue) {
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    public static int argb(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static float hue(int color) {
        float H;
        int temp;
        int b = color & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int V = Math.max(b, Math.max(r, g));
        if (V == (temp = Math.min(b, Math.min(r, g)))) {
            H = 0.0f;
        } else {
            float vtemp = V - temp;
            float cr = (float)(V - r) / vtemp;
            float cg = (float)(V - g) / vtemp;
            float cb = (float)(V - b) / vtemp;
            H = r == V ? cb - cg : (g == V ? 2.0f + cr - cb : 4.0f + cg - cr);
            if ((H /= 6.0f) < 0.0f) {
                H += 1.0f;
            }
        }
        return H;
    }

    public static float saturation(int color) {
        int temp;
        int b = color & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int V = Math.max(b, Math.max(r, g));
        float S = V == (temp = Math.min(b, Math.min(r, g))) ? 0.0f : (float)(V - temp) / (float)V;
        return S;
    }

    public static float brightness(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int V = Math.max(b, Math.max(r, g));
        return (float)V / 255.0f;
    }

    public static int parseColor(String colorString) {
        if (colorString.charAt(0) == '#') {
            long color = Long.parseLong(colorString.substring(1), 16);
            if (colorString.length() == 7) {
                color |= 0xFFFFFFFFFF000000L;
            } else if (colorString.length() != 9) {
                throw new IllegalArgumentException("Unknown color");
            }
            return (int)color;
        }
        Integer color = sColorNameMap.get(colorString.toLowerCase(Locale.US));
        if (color != null) {
            return color;
        }
        throw new IllegalArgumentException("Unknown color");
    }

    static {
        sColorNameMap.put("black", -16777216);
        sColorNameMap.put("darkgray", -12303292);
        sColorNameMap.put("gray", -7829368);
        sColorNameMap.put("lightgray", -3355444);
        sColorNameMap.put("white", -1);
        sColorNameMap.put("red", -65536);
        sColorNameMap.put("green", -16711936);
        sColorNameMap.put("blue", -16776961);
        sColorNameMap.put("yellow", -256);
        sColorNameMap.put("cyan", -16711681);
        sColorNameMap.put("magenta", -65281);
        sColorNameMap.put("aqua", 65535);
        sColorNameMap.put("fuchsia", 0xFF00FF);
        sColorNameMap.put("darkgrey", -12303292);
        sColorNameMap.put("grey", -7829368);
        sColorNameMap.put("lightgrey", -3355444);
        sColorNameMap.put("lime", 65280);
        sColorNameMap.put("maroon", 0x800000);
        sColorNameMap.put("navy", 128);
        sColorNameMap.put("olive", 0x808000);
        sColorNameMap.put("purple", 0x800080);
        sColorNameMap.put("silver", 0xC0C0C0);
        sColorNameMap.put("teal", 32896);
    }
}

