/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.utilities;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PHDateTimePattern {
    private Date date = null;
    private Integer timeIntervalStart = null;
    private Integer timeIntervalEnd = null;
    private Integer timer = null;
    private Integer recurringTimerInterval = null;
    private Integer randomTime = null;
    private Integer recurringDays = RecurringDay.access$000(RecurringDay.RecurringNone);
    private TimeZone timeZone = null;

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Integer getTimeIntervalStart() {
        return this.timeIntervalStart;
    }

    public void setTimeIntervalStart(Integer timeIntervalStart) {
        this.timeIntervalStart = timeIntervalStart;
    }

    public Integer getTimeIntervalEnd() {
        return this.timeIntervalEnd;
    }

    public void setTimeIntervalEnd(Integer timeIntervalEnd) {
        this.timeIntervalEnd = timeIntervalEnd;
    }

    public Integer getTimer() {
        return this.timer;
    }

    public void setTimer(Integer timer) {
        this.timer = timer;
    }

    public Integer getRecurringTimerInterval() {
        return this.recurringTimerInterval;
    }

    public void setRecurringTimerInterval(Integer recurringTimerInterval) {
        this.recurringTimerInterval = recurringTimerInterval;
    }

    public Integer getRandomTime() {
        return this.randomTime;
    }

    public void setRandomTime(Integer randomTime) {
        this.randomTime = randomTime;
    }

    public Integer getRecurringDays() {
        return this.recurringDays;
    }

    public void setRecurringDays(Integer recurringDays) {
        this.recurringDays = recurringDays;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public static PHDateTimePattern patternWithTimeString(String timeString) {
        return PHDateTimePattern.patternWithTimeString(timeString, TimeZone.getDefault());
    }

    public static PHDateTimePattern patternWithTimeString(String timeString, TimeZone timeZone) {
        PHDateTimePattern dateTimePattern = null;
        if (timeString == null || timeString.length() == 0) {
            return null;
        }
        Pattern regexAbsoluteTime = Pattern.compile("^[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(A[0-9]{2}:[0-9]{2}:[0-9]{2})?$", 2);
        Matcher absoluteTimeMatcher = regexAbsoluteTime.matcher(timeString);
        Pattern regexRecurringTime = Pattern.compile("^W[0-9]{1,3}/(T[0-9]{2}:[0-9]{2}:[0-9]{2})?(A[0-9]{2}:[0-9]{2}:[0-9]{2})?$", 2);
        Matcher recurringTimeMatcher = regexRecurringTime.matcher(timeString);
        Pattern regexTimeInterval = Pattern.compile("^T[0-9]{1,2}:[0-9]{2}:[0-9]{2}-T[0-9]{2}:[0-9]{2}:[0-9]{2}", 2);
        Matcher timeIntervalMatcher = regexTimeInterval.matcher(timeString);
        Pattern regexRecurringTimeInterval = Pattern.compile("^W[0-9]{1,3}/T[0-9]{2}:[0-9]{2}:[0-9]{2}-T[0-9]{2}:[0-9]{2}:[0-9]{2}", 2);
        Matcher recurringTimeIntervalMatcher = regexRecurringTimeInterval.matcher(timeString);
        Pattern regexTimer = Pattern.compile("^PT[0-9]{1,2}:[0-9]{2}:[0-9]{2}(A[0-9]{2}:[0-9]{2}:[0-9]{2})?$", 2);
        Matcher timerMatcher = regexTimer.matcher(timeString);
        Pattern regexRecurringTimer = Pattern.compile("^R[0-9]{0,2}/PT[0-9]{2}:[0-9]{2}:[0-9]{2}(A[0-9]{2}:[0-9]{2}:[0-9]{2})?$", 2);
        Matcher recurringTimerMatcher = regexRecurringTimer.matcher(timeString);
        if (absoluteTimeMatcher.find()) {
            dateTimePattern = PHDateTimePattern.patternWithAbsoluteTime(absoluteTimeMatcher.group(), timeString, timeZone);
        } else if (recurringTimeMatcher.find()) {
            dateTimePattern = PHDateTimePattern.patternWithRecurringTime(recurringTimeMatcher.group(), timeString, timeZone);
        } else if (timeIntervalMatcher.find()) {
            dateTimePattern = PHDateTimePattern.patternWithTimeInterval(timeIntervalMatcher.group(), timeString, timeZone);
        } else if (recurringTimeIntervalMatcher.find()) {
            dateTimePattern = PHDateTimePattern.patternWithRecurringTimeInterval(recurringTimeIntervalMatcher.group(), timeString, timeZone);
        } else if (timerMatcher.find()) {
            dateTimePattern = PHDateTimePattern.patternWithTimerString(timerMatcher.group(), timeString, timeZone);
        } else if (recurringTimerMatcher.find()) {
            dateTimePattern = PHDateTimePattern.patternWithRecurringTimerString(recurringTimerMatcher.group(), timeString, timeZone);
        }
        return dateTimePattern;
    }

    public static PHDateTimePattern patternWithRecurringTime(String recurringTimeString, String timeString, TimeZone timeZone) {
        PHDateTimePattern dateTimePattern = null;
        Pattern regexRecurringDays = Pattern.compile("^W([0-9]{1,3})/(T([0-9]{2}:[0-9]{2}:[0-9]{2}))?", 2);
        Matcher recurringDaysMatcher = regexRecurringDays.matcher(recurringTimeString);
        String truncatedTimeString = null;
        recurringDaysMatcher.find();
        String group = recurringDaysMatcher.group(3);
        truncatedTimeString = group != null && group.length() > 0 ? recurringTimeString.substring(recurringTimeString.indexOf(47) + 2, recurringTimeString.length()) : "00:00:00";
        recurringDaysMatcher.reset();
        if (recurringDaysMatcher.find()) {
            SimpleDateFormat dateFormatter = new SimpleDateFormat("HH:mm:ss", new Locale("nl_NL"));
            dateFormatter.setTimeZone(timeZone);
            Date recurringDate = null;
            try {
                recurringDate = dateFormatter.parse(truncatedTimeString);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            if (recurringDate != null) {
                dateTimePattern = new PHDateTimePattern();
                dateTimePattern.setTimeZone(timeZone);
                dateTimePattern.setDate(recurringDate);
                String recurringDaysString = recurringTimeString.substring(1, recurringTimeString.indexOf(47));
                try {
                    dateTimePattern.setRecurringDays(Integer.parseInt(recurringDaysString));
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                    return null;
                }
                int randomTime = PHDateTimePattern.randomTimeWithTimeString(timeString);
                if (randomTime > 0) {
                    dateTimePattern.setRandomTime(randomTime);
                } else if (randomTime == -1) {
                    dateTimePattern = null;
                }
            }
        }
        return dateTimePattern;
    }

    public static PHDateTimePattern patternWithTimeInterval(String timeInterval, String time, TimeZone timeZone) {
        PHDateTimePattern dateTimePattern = null;
        String truncatedTimeStartString = timeInterval.substring(1, timeInterval.indexOf(45));
        String truncatedTimeEndString = timeInterval.substring(timeInterval.indexOf(45) + 2, timeInterval.length());
        Integer timeStart = PHDateTimePattern.timeWithTruncatedTimeString(truncatedTimeStartString);
        Integer timeEnd = PHDateTimePattern.timeWithTruncatedTimeString(truncatedTimeEndString);
        if (timeStart > 0 && timeEnd > 0) {
            dateTimePattern = new PHDateTimePattern();
            dateTimePattern.timeZone = timeZone;
            dateTimePattern.timeIntervalStart = timeStart;
            dateTimePattern.timeIntervalEnd = timeEnd;
        }
        return dateTimePattern;
    }

    public static PHDateTimePattern patternWithAbsoluteTime(String absoluteTime, String time, TimeZone timeZone) {
        PHDateTimePattern result = null;
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", new Locale("nl_NL"));
        dateFormatter.setTimeZone(timeZone);
        Date absoluteDate = null;
        try {
            absoluteDate = dateFormatter.parse(absoluteTime.substring(0, 19));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (absoluteDate != null) {
            result = new PHDateTimePattern();
            result.timeZone = timeZone;
            result.date = absoluteDate;
            Integer randomTime = PHDateTimePattern.randomTimeWithTimeString(time);
            if (randomTime > 0) {
                result.randomTime = randomTime;
            } else if (randomTime == -1) {
                result.randomTime = null;
            }
        }
        return result;
    }

    public static PHDateTimePattern patternWithRecurringTimeInterval(String recurringTimeInterval, String time, TimeZone timeZone) {
        PHDateTimePattern dateTimePattern = null;
        Pattern regexRecurringTimeInterval = Pattern.compile("^W([0-9]{1,3})/(T[0-9]{2}:[0-9]{2}:[0-9]{2}-T[0-9]{2}:[0-9]{2}:[0-9]{2})", 2);
        Matcher matcher = regexRecurringTimeInterval.matcher(recurringTimeInterval);
        if (matcher.find()) {
            String timeIntervalString;
            String patternString = matcher.group();
            String recurringDayString = patternString.substring(1, patternString.indexOf("/"));
            Integer recurringDays = null;
            try {
                recurringDays = Integer.parseInt(recurringDayString);
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
            if (recurringDays != null && (dateTimePattern = PHDateTimePattern.patternWithTimeInterval(timeIntervalString = patternString.substring(patternString.indexOf(47) + 1, patternString.length()), time, timeZone)) != null) {
                dateTimePattern.recurringDays = recurringDays;
            }
        }
        return dateTimePattern;
    }

    public static PHDateTimePattern patternWithTimerString(String timerString, String time, TimeZone timeZone) {
        PHDateTimePattern dateTimePattern = null;
        int timer = PHDateTimePattern.timeWithTruncatedTimeString(timerString.substring(2, 10));
        if (timer > 0) {
            dateTimePattern = new PHDateTimePattern();
            dateTimePattern.timeZone = timeZone;
            dateTimePattern.timer = timer;
            int randomTime = PHDateTimePattern.randomTimeWithTimeString(time);
            if (randomTime > 0) {
                dateTimePattern.randomTime = randomTime;
            } else if (randomTime == -1) {
                dateTimePattern = null;
            }
        }
        return dateTimePattern;
    }

    public static PHDateTimePattern patternWithRecurringTimerString(String recurringTimerString, String timeString, TimeZone timeZone) {
        String timerString;
        String foundPattern;
        String recurringTimerIntervalString;
        int recurringTimerInterval;
        PHDateTimePattern dateTimePattern = null;
        Pattern regexRecurringTimer = Pattern.compile("^R([0-9]{0,2})/(PT[0-9]{2}:[0-9]{2}:[0-9]{2})", 2);
        Matcher matcher = regexRecurringTimer.matcher(recurringTimerString);
        if (matcher.find() && (0 < (recurringTimerInterval = (recurringTimerIntervalString = (foundPattern = matcher.group()).substring(1, foundPattern.indexOf(47))).isEmpty() ? -1 : Integer.parseInt(recurringTimerIntervalString)) && recurringTimerInterval <= 99 || recurringTimerInterval == -1) && (dateTimePattern = PHDateTimePattern.patternWithTimerString(timerString = foundPattern.substring(foundPattern.indexOf(47) + 1, foundPattern.length()), timeString, timeZone)) != null) {
            dateTimePattern.recurringTimerInterval = recurringTimerInterval;
        }
        return dateTimePattern;
    }

    public static int randomTimeWithTimeString(String time) {
        String randomTimeString;
        int randomTime = 0;
        Pattern regexRandomTime = Pattern.compile("A[0-9]{2}:[0-9]{2}:[0-9]{2}", 2);
        Matcher regexRandomTimeMatcher = regexRandomTime.matcher(time);
        if (regexRandomTimeMatcher.find() && (randomTime = PHDateTimePattern.timeWithTruncatedTimeString((randomTimeString = regexRandomTimeMatcher.group()).substring(1, randomTimeString.length()))) == 0) {
            randomTime = -1;
        }
        return randomTime;
    }

    public static int timeWithTruncatedTimeString(String truncatedTimeString) {
        String[] timeArray = truncatedTimeString.split(":");
        if (timeArray.length != 3) {
            return 0;
        }
        int time = 0;
        if (timeArray[0].startsWith("PT")) {
            timeArray[0] = timeArray[0].substring(2);
        }
        try {
            int hours = Integer.parseInt(timeArray[0]);
            int minutes = Integer.parseInt(timeArray[1]);
            int seconds = Integer.parseInt(timeArray[2]);
            if (hours > 24 || minutes > 60 || seconds > 60) {
                return 0;
            }
            time = hours * 3600 + minutes * 60 + seconds;
            if (time <= 0 || time > 86400) {
                time = 0;
            }
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            time = 0;
        }
        return time;
    }

    public String patternAsString() {
        String timeString = null;
        if (this.date != null) {
            timeString = this.recurringDays != null && this.recurringDays != RecurringDay.RecurringNone.value ? this.recurringTimeAsString() : this.absoluteTimeAsString();
        } else if (this.timeIntervalStart != null && this.timeIntervalStart > 0 && this.timeIntervalEnd != null && this.timeIntervalEnd > 0) {
            timeString = this.recurringDays != null && this.recurringDays != RecurringDay.RecurringNone.value ? this.recurringTimeIntervalAsString() : this.timeIntervalAsString();
        } else if (this.timer != null && this.timer > 0) {
            timeString = this.recurringTimerInterval != null && this.recurringTimerInterval > 0 ? this.recurringTimerAsString() : this.timerAsString();
        }
        return timeString;
    }

    public String absoluteTimeAsString() {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", new Locale("nl_NL"));
        if (this.timeZone != null) {
            dateFormatter.setTimeZone(this.timeZone);
        }
        String timeString = dateFormatter.format(this.date);
        if (this.randomTime != null && this.randomTime > 0) {
            String randomTimeString = this.randomTimeAsStringWithTime(this.randomTime);
            timeString = randomTimeString != null ? timeString.concat(randomTimeString) : null;
        }
        return timeString;
    }

    public String recurringTimeAsString() {
        String truncatedTimeString;
        if (this.recurringDays == null) {
            return null;
        }
        String timeString = String.format(new Locale("nl_NL"), "W%03d/", this.recurringDays);
        SimpleDateFormat dateFormatter = new SimpleDateFormat("'T'HH:mm:ss", new Locale("nl_NL"));
        if (this.timeZone != null) {
            dateFormatter.setTimeZone(this.timeZone);
        }
        if ((truncatedTimeString = dateFormatter.format(this.date)) != null) {
            timeString = timeString.concat(truncatedTimeString);
            if (this.randomTime != null && this.randomTime > 0) {
                String randomTimeString = this.randomTimeAsStringWithTime(this.randomTime);
                timeString = randomTimeString != null ? timeString.concat(randomTimeString) : null;
            }
        } else {
            timeString = null;
        }
        return timeString;
    }

    public String timeIntervalAsString() {
        String timeString = null;
        String timeStringStart = this.truncatedTimeAsStringWithTime(this.timeIntervalStart);
        String timeStringEnd = this.truncatedTimeAsStringWithTime(this.timeIntervalEnd);
        if (timeStringStart != null && timeStringEnd != null) {
            timeString = String.format("%s-%s", timeStringStart, timeStringEnd);
        }
        return timeString;
    }

    public String recurringTimeIntervalAsString() {
        String timeString = String.format(new Locale("nl_NL"), "W%03d/", this.recurringDays);
        String recurringTimeIntervalString = this.timeIntervalAsString();
        timeString = timeString != null ? timeString.concat(recurringTimeIntervalString) : null;
        return timeString;
    }

    public String timerAsString() {
        if (this.timer <= 0 || this.timer > 86400) {
            return null;
        }
        String timeString = "P";
        String truncatedTimeString = this.truncatedTimeAsStringWithTime(this.timer);
        if (truncatedTimeString != null) {
            timeString = timeString.concat(truncatedTimeString);
            if (this.randomTime != null && this.randomTime > 0) {
                String randomTimeString = this.randomTimeAsStringWithTime(this.randomTime);
                timeString = randomTimeString != null ? timeString.concat(randomTimeString) : null;
            }
        } else {
            timeString = null;
        }
        return timeString;
    }

    public String recurringTimerAsString() {
        String timeString = null;
        if (this.recurringTimerInterval >= 1 && this.recurringTimerInterval <= 99 || this.recurringTimerInterval == -1) {
            timeString = this.recurringTimerInterval == -1 ? "R/" : String.format(new Locale("nl_NL"), "R%02d/", (int)this.recurringTimerInterval);
            String recurringTimerIntervalString = this.timerAsString();
            timeString = recurringTimerIntervalString != null ? timeString.concat(recurringTimerIntervalString) : null;
        }
        return timeString;
    }

    public String randomTimeAsStringWithTime(Integer time) {
        if (time <= 0 || time > 86400) {
            return null;
        }
        int hours = (int)Math.floor(time / 3600);
        int minutes = (int)Math.floor(time % 3600 / 60);
        int seconds = time % 3600 % 60;
        String randomString = String.format(new Locale("nl_NL"), "A%02d:%02d:%02d", hours, minutes, seconds);
        return randomString;
    }

    public String truncatedTimeAsStringWithTime(Integer time) {
        if (time <= 0 || time > 86400) {
            return null;
        }
        int hours = (int)Math.floor(time / 3600);
        int minutes = (int)Math.floor(time % 3600 / 60);
        int seconds = time % 3600 % 60;
        String randomString = String.format(new Locale("nl_NL"), "T%02d:%02d:%02d", hours, minutes, seconds);
        return randomString;
    }

    public static enum RecurringDay {
        RecurringNone(0),
        RecurringMonday(64),
        RecurringTuesday(32),
        RecurringWednesday(16),
        RecurringThursday(8),
        RecurringFriday(4),
        RecurringSaturday(2),
        RecurringSunday(1),
        RecurringWeekdays(124),
        RecurringWeekend(3),
        RecurringAlldays(127);

        private int value;

        private RecurringDay(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static RecurringDay fromValue(int value) {
            if (value == RecurringMonday.getValue()) {
                return RecurringMonday;
            }
            if (value == RecurringTuesday.getValue()) {
                return RecurringTuesday;
            }
            if (value == RecurringWednesday.getValue()) {
                return RecurringWednesday;
            }
            if (value == RecurringThursday.getValue()) {
                return RecurringThursday;
            }
            if (value == RecurringFriday.getValue()) {
                return RecurringFriday;
            }
            if (value == RecurringSaturday.getValue()) {
                return RecurringSaturday;
            }
            if (value == RecurringSunday.getValue()) {
                return RecurringSunday;
            }
            if (value == RecurringWeekdays.getValue()) {
                return RecurringWeekdays;
            }
            if (value == RecurringWeekend.getValue()) {
                return RecurringWeekend;
            }
            if (value == RecurringAlldays.getValue()) {
                return RecurringAlldays;
            }
            return RecurringNone;
        }
    }
}

