/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip.serialisation;

import com.philips.lighting.hue.sdk.clip.serialisation.PHScheduleSerializer2;
import com.philips.lighting.hue.sdk.utilities.PHDateTimePattern;
import com.philips.lighting.hue.sdk.utilities.PHUtilities;
import com.philips.lighting.model.PHSchedule;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.json.hue.JSONArray;
import org.json.hue.JSONException;
import org.json.hue.JSONObject;

public class PHScheduleSerializer3
extends PHScheduleSerializer2 {
    private static PHScheduleSerializer3 schedulesSerialisation3;

    public static synchronized PHScheduleSerializer3 getInstance() {
        if (schedulesSerialisation3 == null) {
            schedulesSerialisation3 = new PHScheduleSerializer3();
        }
        return schedulesSerialisation3;
    }

    @Override
    public List<PHSchedule> parseSchedules(JSONObject rootObject, String sTimeZone) {
        JSONArray schedulesArray;
        ArrayList<PHSchedule> schedulesList = new ArrayList<PHSchedule>();
        JSONObject schedules = rootObject.optJSONObject("schedules");
        if (schedules == null) {
            schedules = rootObject;
        }
        if (schedules != null && (schedulesArray = schedules.names()) != null) {
            for (int i = 0; i < schedulesArray.length(); ++i) {
                String scheduleIdentifier = schedulesArray.optString(i);
                try {
                    String jsonStatus;
                    String owner;
                    String localtime;
                    String time;
                    Date startTimeDate;
                    String startTime;
                    Date createdDate;
                    JSONObject scheduleObject = schedules.optJSONObject(scheduleIdentifier);
                    if (scheduleObject == null) continue;
                    PHSchedule schedule = this.parseSingleSchedule(scheduleIdentifier, scheduleObject);
                    String created = scheduleObject.optString("created");
                    if (created != null && created.length() > 0 && (createdDate = PHUtilities.stringToDate(created, "UTC")) != null) {
                        schedule.setCreated(createdDate);
                    }
                    if ((startTime = scheduleObject.optString("starttime")) != null && startTime.length() > 0 && (startTimeDate = PHUtilities.stringToDate(startTime, "UTC")) != null) {
                        schedule.setStartTime(startTimeDate);
                    }
                    if ((time = scheduleObject.optString("time")) != null && time.length() > 0) {
                        PHDateTimePattern dateTimePattern = PHDateTimePattern.patternWithTimeString(time, TimeZone.getTimeZone("UTC"));
                        if (dateTimePattern != null) {
                            schedule.setDate(dateTimePattern.getDate());
                            schedule.setTimer(dateTimePattern.getTimer() != null ? dateTimePattern.getTimer() : 0);
                            schedule.setRecurringTimerInterval(dateTimePattern.getRecurringTimerInterval() != null ? dateTimePattern.getRecurringTimerInterval() : 0);
                            schedule.setRandomTime(dateTimePattern.getRandomTime() != null ? dateTimePattern.getRandomTime() : 0);
                            schedule.setRecurringDays(dateTimePattern.getRecurringDays());
                        } else {
                            throw new JSONException("JSON contains invalid data for time");
                        }
                    }
                    if ((localtime = scheduleObject.optString("localtime")) != null && localtime.length() > 0) {
                        PHDateTimePattern dateTimePattern;
                        if (sTimeZone == null) {
                            sTimeZone = "UTC";
                        }
                        if ((dateTimePattern = PHDateTimePattern.patternWithTimeString(localtime, TimeZone.getTimeZone(sTimeZone))) != null) {
                            schedule.setLocalTime(true);
                            schedule.setDate(dateTimePattern.getDate());
                            schedule.setTimer(dateTimePattern.getTimer() != null ? dateTimePattern.getTimer() : 0);
                            schedule.setRecurringTimerInterval(dateTimePattern.getRecurringTimerInterval() != null ? dateTimePattern.getRecurringTimerInterval() : 0);
                            schedule.setRandomTime(dateTimePattern.getRandomTime() != null ? dateTimePattern.getRandomTime() : 0);
                            schedule.setRecurringDays(dateTimePattern.getRecurringDays());
                        } else {
                            throw new JSONException("JSON contains invalid data for time");
                        }
                    }
                    if (!(owner = scheduleObject.optString("owner")).isEmpty()) {
                        schedule.setOwner(owner);
                    }
                    if ((jsonStatus = scheduleObject.optString("status")).equals("active") || jsonStatus.equals("enabled")) {
                        schedule.setStatus(PHSchedule.PHScheduleStatus.ENABLED);
                    } else if (jsonStatus.equals("disabled")) {
                        schedule.setStatus(PHSchedule.PHScheduleStatus.DISABLED);
                    } else if (jsonStatus.toLowerCase().contains("resource") && jsonStatus.toLowerCase().contains("deleted")) {
                        schedule.setStatus(PHSchedule.PHScheduleStatus.RESOURCE_DELETED);
                    } else if (jsonStatus.equals("error")) {
                        schedule.setStatus(PHSchedule.PHScheduleStatus.ERROR);
                    } else {
                        schedule.setStatus(PHSchedule.PHScheduleStatus.UNKNOWN);
                    }
                    schedulesList.add(schedule);
                    continue;
                }
                catch (Exception e) {
                    this.reportParsingError(64, scheduleIdentifier, "Schedule unparsable due to error: " + e.getMessage(), schedules.optJSONObject(scheduleIdentifier));
                }
            }
        }
        return schedulesList;
    }

    @Override
    public boolean validateAPI(PHSchedule schedule) {
        return true;
    }

    @Override
    public JSONObject createSchedulePacket(PHSchedule schedule, String cmdAddress, String method, String timeZone) throws JSONException {
        JSONObject result = super.createSchedulePacket(schedule, cmdAddress, method, timeZone);
        PHSchedule.PHScheduleStatus status = schedule.getStatus();
        if (status == PHSchedule.PHScheduleStatus.ENABLED) {
            result.put("status", "enabled");
        } else if (status == PHSchedule.PHScheduleStatus.DISABLED) {
            result.put("status", "disabled");
        }
        String timeTarget = "time";
        PHDateTimePattern dateTimePattern = new PHDateTimePattern();
        dateTimePattern.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (schedule.getLocalTime() != null && schedule.getLocalTime().booleanValue()) {
            dateTimePattern.setTimeZone(TimeZone.getTimeZone(timeZone));
            timeTarget = "localtime";
        }
        if (schedule.getRandomTime() != 0) {
            dateTimePattern.setRandomTime(schedule.getRandomTime());
        }
        if (schedule.getDate() != null) {
            dateTimePattern.setDate(schedule.getDate());
            if (schedule.getRecurringDays() != 0) {
                dateTimePattern.setRecurringDays(schedule.getRecurringDays());
            }
        } else if (schedule.getTimer() != 0) {
            dateTimePattern.setTimer(schedule.getTimer());
            if (schedule.getRecurringTimerInterval() >= 1 && schedule.getRecurringTimerInterval() <= 99 || schedule.getRecurringTimerInterval() == -1) {
                dateTimePattern.setRecurringTimerInterval(schedule.getRecurringTimerInterval());
            }
        }
        result.remove("time");
        result.putOpt(timeTarget, dateTimePattern.patternAsString());
        return result;
    }

    @Override
    public JSONObject updateSchedulePacket(PHSchedule schedule, String cmdAddress, String method, String timeZone) throws JSONException {
        return this.createSchedulePacket(schedule, cmdAddress, method, timeZone);
    }

    @Override
    public JSONObject createSchedulePacket(PHSchedule schedule, String cmdAddress, String method) throws JSONException {
        return this.createSchedulePacket(schedule, cmdAddress, method, "UTC");
    }

    @Override
    public JSONObject updateSchedulePacket(PHSchedule schedule, String cmdAddress, String method) throws JSONException {
        return this.updateSchedulePacket(schedule, cmdAddress, method, "UTC");
    }
}

