/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip.serialisation;

import com.philips.lighting.hue.sdk.clip.PHSceneSerializer;
import com.philips.lighting.hue.sdk.clip.serialisation.PHCLIPParserBase;
import com.philips.lighting.hue.sdk.clip.serialisation.PHSceneSerializer2;
import com.philips.lighting.hue.sdk.exception.PHHueException;
import com.philips.lighting.hue.sdk.utilities.impl.PHLog;
import com.philips.lighting.model.PHScene;
import java.util.ArrayList;
import java.util.List;
import org.json.hue.JSONArray;
import org.json.hue.JSONException;
import org.json.hue.JSONObject;

public class PHSceneSerializer1
extends PHCLIPParserBase
implements PHSceneSerializer {
    private static PHSceneSerializer1 scenesSerialisation1;

    public static synchronized PHSceneSerializer1 getInstance() {
        if (scenesSerialisation1 == null) {
            scenesSerialisation1 = new PHSceneSerializer1();
        }
        return scenesSerialisation1;
    }

    @Override
    public List<PHScene> parseScenes(JSONObject rootObject) {
        JSONObject scenes = rootObject.optJSONObject("scenes");
        if (scenes == null) {
            scenes = rootObject;
        }
        ArrayList<PHScene> list = new ArrayList<PHScene>();
        try {
            JSONArray arrays;
            if (scenes != null && (arrays = scenes.names()) != null) {
                for (int i = 0; i < arrays.length(); ++i) {
                    String identifier = arrays.optString(i);
                    try {
                        if (identifier != null && (identifier.length() < 1 || identifier.length() > 16)) {
                            throw new PHHueException("JSON contains invalid scene identifier");
                        }
                        JSONObject obj = scenes.optJSONObject(identifier);
                        if (obj == null) continue;
                        String name = obj.optString("name");
                        if (name == null || name.length() == 0) {
                            throw new PHHueException("JSON is missing key: name");
                        }
                        Boolean activeState = null;
                        activeState = obj.isNull("active") ? null : Boolean.valueOf(obj.optBoolean("active"));
                        JSONArray lightsArray = obj.optJSONArray("lights");
                        if (lightsArray == null) continue;
                        ArrayList<String> lightsIdentifier = new ArrayList<String>();
                        for (int lightcounter = 0; lightcounter < lightsArray.length(); ++lightcounter) {
                            lightsIdentifier.add(lightsArray.optString(lightcounter));
                        }
                        PHScene scene = new PHScene();
                        scene.setSceneIdentifier(identifier);
                        scene.setName(name);
                        scene.setActiveState(this.chooseSceneActiveState(activeState));
                        scene.setLightIdentifiers(lightsIdentifier);
                        list.add(scene);
                        continue;
                    }
                    catch (Exception e) {
                        this.reportParsingError(63, identifier, "Scene unparsable due to error: " + e.getMessage(), scenes.optJSONObject(identifier));
                    }
                }
            }
            return list;
        }
        catch (Exception e) {
            if (PHLog.isLoggable()) {
                PHLog.e("PCCLIPParser1_1", "Excpetion: " + e);
                e.printStackTrace();
            }
            return null;
        }
    }

    private PHScene.PHSceneActiveState chooseSceneActiveState(Boolean activeState) {
        if (activeState == null) {
            return PHScene.PHSceneActiveState.SCENE_STATE_UNKNOWN;
        }
        if (activeState.booleanValue()) {
            return PHScene.PHSceneActiveState.SCENE_STATE_ACTIVE;
        }
        return PHScene.PHSceneActiveState.SCENE_STATE_INACTIVE;
    }

    @Override
    public JSONObject createScenePacket(PHScene scene, boolean isModify) throws JSONException {
        JSONObject toSend = new JSONObject();
        JSONArray array = new JSONArray();
        for (int i = 0; i < scene.getLightIdentifiers().size(); ++i) {
            array.put(i, scene.getLightIdentifiers().get(i));
        }
        toSend.putOpt("name", scene.getName());
        toSend.putOpt("lights", array);
        return toSend;
    }

    @Override
    public JSONObject createActivateScenePacket(String sceneId) throws JSONException {
        JSONObject toSend = new JSONObject();
        toSend.putOpt("scene", sceneId);
        return toSend;
    }

    @Override
    public boolean validateAPI(PHScene scene) {
        if (PHSceneSerializer2.getInstance().validateAPI(scene)) {
            return scene.getTransitionTime() == 0;
        }
        return false;
    }

    @Override
    public boolean canCreate() {
        return true;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canUpdate() {
        return false;
    }

    @Override
    public boolean canDelete() {
        return false;
    }

    @Override
    public boolean canFetchAll() {
        return false;
    }

    @Override
    public PHScene parseSceneDetails(String response, String sceneIdentifier) {
        return null;
    }

    @Override
    public boolean isVersion2Scene() {
        return false;
    }
}

