/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip.serialisation;

import com.philips.lighting.hue.sdk.clip.PHLightSerializer;
import com.philips.lighting.hue.sdk.clip.serialisation.PHCLIPParserBase;
import com.philips.lighting.hue.sdk.utilities.impl.PHLog;
import com.philips.lighting.model.PHBridgeResource;
import com.philips.lighting.model.PHLight;
import com.philips.lighting.model.PHLightState;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.json.hue.JSONArray;
import org.json.hue.JSONException;
import org.json.hue.JSONObject;

public class PHLightSerializer1
extends PHCLIPParserBase
implements PHLightSerializer {
    private static final String TAG = PHLightSerializer1.class.getSimpleName();
    private static PHLightSerializer1 lightSerialisation1;

    public static synchronized PHLightSerializer1 getInstance() {
        if (lightSerialisation1 == null) {
            lightSerialisation1 = new PHLightSerializer1();
        }
        return lightSerialisation1;
    }

    @Override
    public List<PHLight> parseLights(JSONObject rootObject) {
        JSONArray lightsArray;
        ArrayList<PHLight> lightsList = new ArrayList<PHLight>();
        JSONObject lights = rootObject.optJSONObject("lights");
        if (lights == null) {
            lights = rootObject;
        }
        if (lights != null && (lightsArray = lights.names()) != null) {
            for (int i = 0; i < lightsArray.length(); ++i) {
                String lightIdentifier = lightsArray.optString(i);
                try {
                    JSONObject lightObject = lights.optJSONObject(lightIdentifier);
                    if (lightObject == null) continue;
                    String type = lightObject.optString("type");
                    String name = lightObject.optString("name");
                    String modelId = lightObject.optString("modelid");
                    String swversion = lightObject.optString("swversion");
                    JSONObject stateObject = lightObject.optJSONObject("state");
                    PHLight newPHLight = new PHLight(name, lightIdentifier, swversion, modelId);
                    newPHLight.setLightType(type);
                    if (stateObject != null) {
                        PHLightState phLightState = this.parseLightState(stateObject);
                        if (phLightState != null) {
                            newPHLight.setLastKnownLightState(phLightState);
                        }
                    } else {
                        newPHLight.setLastKnownLightState(null);
                    }
                    lightsList.add(newPHLight);
                    continue;
                }
                catch (Exception e) {
                    this.reportParsingError(61, lightIdentifier, "Light unparsable due to error: " + e.getMessage(), lights.optJSONObject(lightIdentifier));
                }
            }
        }
        return lightsList;
    }

    @Override
    public List<PHBridgeResource> parseGetAllLightHeaders(String response) {
        ArrayList<PHBridgeResource> newLightHeaderList = new ArrayList<PHBridgeResource>();
        JSONObject jObject = null;
        try {
            jObject = new JSONObject(response);
            if (jObject != null) {
                JSONArray arrays = jObject.names();
                newLightHeaderList.clear();
                if (arrays != null) {
                    for (int i = 0; i < arrays.length(); ++i) {
                        String identifier = arrays.optString(i);
                        JSONObject obj = jObject.optJSONObject(identifier);
                        if (obj == null) continue;
                        String name = obj.optString("name");
                        PHBridgeResource newHeader = new PHBridgeResource(name, identifier);
                        newLightHeaderList.add(newHeader);
                    }
                }
            }
            return newLightHeaderList;
        }
        catch (JSONException e) {
            if (PHLog.isLoggable()) {
                PHLog.e(TAG, "JSONException: " + e);
            }
            return null;
        }
    }

    @Override
    public PHLight parseLightDetails(String response, String lightIdentifier) {
        block3: {
            JSONObject jObject = null;
            try {
                jObject = new JSONObject(response);
                if (jObject != null) {
                    String name = jObject.optString("name");
                    String type = jObject.optString("type");
                    String modelId = jObject.optString("modelid");
                    String swversion = jObject.optString("swversion");
                    PHLight foundLight = new PHLight(name, lightIdentifier, swversion, modelId);
                    foundLight.setLightType(type);
                    return foundLight;
                }
            }
            catch (JSONException e) {
                if (!PHLog.isLoggable()) break block3;
                PHLog.e(TAG, "JSONException: " + e);
            }
        }
        return null;
    }

    @Override
    public PHLightState parseLightState(JSONObject stateObject) {
        Boolean on = null;
        PHLightState lightState = new PHLightState();
        on = stateObject.isNull("on") ? null : Boolean.valueOf(stateObject.optBoolean("on"));
        Integer brightness = null;
        if (stateObject.has("bri")) {
            brightness = stateObject.optInt("bri");
        }
        Integer hue = null;
        if (stateObject.has("hue")) {
            hue = stateObject.optInt("hue");
        }
        Integer saturation = null;
        if (stateObject.has("sat")) {
            saturation = stateObject.optInt("sat");
        }
        JSONArray xyArray = null;
        if (stateObject.has("xy")) {
            xyArray = stateObject.optJSONArray("xy");
        }
        Float x = null;
        Float y = null;
        if (xyArray != null) {
            x = Float.valueOf((float)xyArray.optDouble(0));
            y = Float.valueOf((float)xyArray.optDouble(1));
        }
        Integer ct = null;
        if (stateObject.has("ct")) {
            ct = stateObject.optInt("ct");
        }
        Boolean reachable = null;
        reachable = stateObject.isNull("reachable") ? null : Boolean.valueOf(stateObject.optBoolean("reachable"));
        Integer briInc = null;
        if (stateObject.has("bri_inc")) {
            briInc = stateObject.optInt("bri_inc");
        }
        Integer ctInc = null;
        if (stateObject.has("ct_inc")) {
            ctInc = stateObject.optInt("ct_inc");
        }
        Integer hueInc = null;
        if (stateObject.has("hue_inc")) {
            hueInc = stateObject.optInt("hue_inc");
        }
        Integer satInc = null;
        if (stateObject.has("sat_inc")) {
            satInc = stateObject.optInt("sat_inc");
        }
        JSONArray xyIncArray = null;
        Float xInc = null;
        Float yInc = null;
        if (stateObject.has("xy_inc") && (xyIncArray = stateObject.optJSONArray("xy_inc")) != null) {
            xInc = Float.valueOf((float)xyIncArray.optDouble(0));
            yInc = Float.valueOf((float)xyIncArray.optDouble(1));
        }
        String alertType = stateObject.optString("alert");
        String effectMode = stateObject.optString("effect");
        String colorMode = stateObject.optString("colormode");
        lightState.setOn(on);
        lightState.setBrightness(brightness);
        lightState.setHue(hue);
        lightState.setSaturation(saturation);
        lightState.setX(x);
        lightState.setY(y);
        lightState.setCt(ct);
        lightState.setReachable(reachable);
        lightState.setAlertMode(PHLight.PHLightAlertMode.fromString(alertType));
        lightState.setEffectMode(PHLight.PHLightEffectMode.fromString(effectMode));
        lightState.setColorMode(PHLight.PHLightColorMode.fromString(colorMode));
        lightState.setIncrementBri(briInc);
        lightState.setIncrementCt(ctInc);
        lightState.setIncrementHue(hueInc);
        lightState.setIncrementSat(satInc);
        lightState.setIncrementX(xInc);
        lightState.setIncrementY(yInc);
        return lightState;
    }

    @Override
    public JSONObject createLightStatePacket(PHLightState state) throws JSONException {
        String effect;
        String alert;
        JSONObject toSend = new JSONObject();
        if (state.getHue() != null) {
            toSend.putOpt("hue", state.getHue());
        }
        if (state.isOn() != null) {
            toSend.putOpt("on", state.isOn());
        }
        if (state.getBrightness() != null) {
            toSend.putOpt("bri", state.getBrightness());
        }
        if (state.getSaturation() != null) {
            toSend.putOpt("sat", state.getSaturation());
        }
        if (state.getTransitionTime() != null) {
            toSend.putOpt("transitiontime", state.getTransitionTime());
        }
        if (state.getCt() != null) {
            toSend.putOpt("ct", state.getCt());
        }
        if (state.isReachable() != null) {
            toSend.putOpt("reachable", state.isReachable());
        }
        if (state.getX() != null && state.getY() != null) {
            JSONArray xyArray = new JSONArray();
            JSONObject tempX = new JSONObject(String.format(Locale.ENGLISH, "{\"tempX\": %.4f}", state.getX()));
            JSONObject tempY = new JSONObject(String.format(Locale.ENGLISH, "{\"tempY\": %.4f}", state.getY()));
            xyArray.put(tempX.get("tempX"));
            xyArray.put(tempY.get("tempY"));
            toSend.putOpt("xy", xyArray);
        }
        if (state.getAlertMode() != null && (alert = state.getAlertMode().getValue()) != null) {
            toSend.putOpt("alert", alert);
        }
        if (state.getEffectMode() != null && (effect = state.getEffectMode().getValue()) != null) {
            toSend.putOpt("effect", effect);
        }
        return toSend;
    }

    @Override
    public JSONObject updateLightStatePacket(PHLightState state) throws JSONException {
        JSONObject toSend = this.createLightStatePacket(state);
        if (toSend != null) {
            return toSend;
        }
        return null;
    }

    @Override
    public JSONObject updateLightPacket(PHLight light) throws JSONException {
        JSONObject toSend = new JSONObject();
        toSend.putOpt("name", light.getName());
        return toSend;
    }

    @Override
    public JSONObject createFindLightWithSerialsPacket(List<String> serials) throws JSONException {
        return null;
    }

    @Override
    public boolean validateAPI(PHLight light) {
        return true;
    }

    @Override
    public boolean validateAPI(PHLightState lightState) {
        return true;
    }

    @Override
    public boolean canCreate() {
        return false;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public boolean canDelete() {
        return false;
    }

    @Override
    public boolean canLightStateCreate() {
        return false;
    }

    @Override
    public boolean canLightStateRead() {
        return true;
    }

    @Override
    public boolean canLightStateUpdate() {
        return true;
    }

    @Override
    public boolean canLightStateDelete() {
        return false;
    }

    @Override
    public boolean canLightConfigurationCreate() {
        return false;
    }

    @Override
    public boolean canLightConfigurationRead() {
        return false;
    }

    @Override
    public boolean canLightConfigurationUpdate() {
        return false;
    }

    @Override
    public boolean canLightConfigurationDelete() {
        return false;
    }

    @Override
    public boolean canFetchAll() {
        return false;
    }
}

