/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip.serialisation;

import com.philips.lighting.hue.sdk.clip.serialisation.PHGroupSerializer1;
import com.philips.lighting.model.PHGroup;
import java.util.List;
import org.json.hue.JSONArray;
import org.json.hue.JSONException;
import org.json.hue.JSONObject;

public class PHGroupSerializer2
extends PHGroupSerializer1 {
    private static PHGroupSerializer2 groupSerializer2;

    public static synchronized PHGroupSerializer2 getInstance() {
        if (groupSerializer2 == null) {
            groupSerializer2 = new PHGroupSerializer2();
        }
        return groupSerializer2;
    }

    @Override
    public List<PHGroup> parseGroups(JSONObject rootObject) {
        JSONArray groupsArray;
        List<PHGroup> groupsList = super.parseGroups(rootObject);
        JSONObject groups = rootObject.optJSONObject("groups");
        if (groups == null) {
            groups = rootObject;
        }
        if (groups != null && (groupsArray = groups.names()) != null) {
            for (int i = 0; i < groupsArray.length(); ++i) {
                String groupIdentifier = groupsArray.optString(i);
                JSONObject groupObject = groups.optJSONObject(groupIdentifier);
                String modelId = groupObject.optString("modelid");
                String type = groupObject.optString("type");
                groupsList.get(i).setModelId(modelId);
                groupsList.get(i).setType(type);
            }
        }
        return groupsList;
    }

    @Override
    public JSONObject createGroupPacket(PHGroup group) throws JSONException {
        JSONObject toSend = super.createGroupPacket(group);
        toSend.putOpt("type", group.getType());
        return toSend;
    }
}

