/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip.serialisation;

import com.philips.lighting.hue.sdk.clip.PHGroupSerializer;
import com.philips.lighting.hue.sdk.clip.serialisation.PHCLIPParserBase;
import com.philips.lighting.hue.sdk.utilities.impl.PHLog;
import com.philips.lighting.model.PHBridgeResource;
import com.philips.lighting.model.PHGroup;
import java.util.ArrayList;
import java.util.List;
import org.json.hue.JSONArray;
import org.json.hue.JSONException;
import org.json.hue.JSONObject;

public class PHGroupSerializer1
extends PHCLIPParserBase
implements PHGroupSerializer {
    private static final String TAG = PHGroupSerializer1.class.getSimpleName();
    private static PHGroupSerializer1 groupSerialisation1;

    public static synchronized PHGroupSerializer1 getInstance() {
        if (groupSerialisation1 == null) {
            groupSerialisation1 = new PHGroupSerializer1();
        }
        return groupSerialisation1;
    }

    @Override
    public List<PHGroup> parseGroups(JSONObject rootObject) {
        JSONArray groupsArray;
        ArrayList<PHGroup> groupsList = new ArrayList<PHGroup>();
        JSONObject groups = rootObject.optJSONObject("groups");
        if (groups == null) {
            groups = rootObject;
        }
        if (groups != null && (groupsArray = groups.names()) != null) {
            for (int i = 0; i < groupsArray.length(); ++i) {
                String groupIdentifier = groupsArray.optString(i);
                try {
                    JSONObject groupObject = groups.optJSONObject(groupIdentifier);
                    if (groupObject == null) continue;
                    JSONArray lightsArray = groupObject.optJSONArray("lights");
                    String name = groupObject.optString("name");
                    PHGroup newPHGroup = new PHGroup(name, groupIdentifier);
                    if (lightsArray != null) {
                        ArrayList<String> lightsIdentifier = new ArrayList<String>();
                        for (int lightcounter = 0; lightcounter < lightsArray.length(); ++lightcounter) {
                            lightsIdentifier.add(lightsArray.optString(lightcounter));
                        }
                        newPHGroup.setLightIdentifiers(lightsIdentifier);
                    }
                    groupsList.add(newPHGroup);
                    continue;
                }
                catch (Exception e) {
                    this.reportParsingError(62, groupIdentifier, "Group unparsable due to error: " + e.getMessage(), groups.optJSONObject(groupIdentifier));
                }
            }
        }
        return groupsList;
    }

    public List<PHBridgeResource> parseGetAllGroup(String response) {
        ArrayList<PHBridgeResource> list = new ArrayList<PHBridgeResource>();
        try {
            JSONArray arrays;
            JSONObject jObject = new JSONObject(response);
            if (jObject != null && (arrays = jObject.names()) != null) {
                for (int i = 0; i < arrays.length(); ++i) {
                    String identifier = arrays.optString(i);
                    JSONObject obj = jObject.optJSONObject(identifier);
                    if (obj == null) continue;
                    String name = obj.optString("name");
                    PHBridgeResource newHeader = new PHBridgeResource(name, identifier);
                    list.add(newHeader);
                }
            }
            return list;
        }
        catch (JSONException e) {
            if (PHLog.isLoggable()) {
                PHLog.e(TAG, "JSONException: " + e);
            }
            return null;
        }
    }

    public PHGroup parseGetGroupDetails(String response, String groupIdentifier) {
        block4: {
            JSONObject jObject = null;
            try {
                jObject = new JSONObject(response);
                if (jObject != null) {
                    String name = jObject.optString("name");
                    JSONArray lights = jObject.optJSONArray("lights");
                    ArrayList<String> strLights = new ArrayList<String>();
                    for (int i = 0; i < lights.length(); ++i) {
                        strLights.add(lights.optString(i));
                    }
                    PHGroup foundGroup = new PHGroup(name, groupIdentifier);
                    foundGroup.setLightIdentifiers(strLights);
                    return foundGroup;
                }
            }
            catch (JSONException e) {
                if (!PHLog.isLoggable()) break block4;
                PHLog.e(TAG, "JSONException: " + e);
            }
        }
        return null;
    }

    @Override
    public JSONObject createGroupPacket(String name, List<String> lightIdentifiers) throws JSONException {
        JSONObject toSend = new JSONObject();
        JSONArray array = new JSONArray();
        for (int i = 0; i < lightIdentifiers.size(); ++i) {
            array.put(i, lightIdentifiers.get(i));
        }
        toSend.putOpt("name", name);
        toSend.putOpt("lights", array);
        return toSend;
    }

    @Override
    public JSONObject createGroupPacket(PHGroup group) throws JSONException {
        JSONObject toSend = new JSONObject();
        JSONArray array = new JSONArray();
        for (int i = 0; i < group.getLightIdentifiers().size(); ++i) {
            array.put(i, group.getLightIdentifiers().get(i));
        }
        toSend.putOpt("name", group.getName());
        toSend.putOpt("lights", array);
        return toSend;
    }

    @Override
    public JSONObject updateGroupPacket(PHGroup group) throws JSONException {
        JSONObject toSend = new JSONObject();
        toSend.put("name", group.getName());
        if (group.getLightIdentifiers() != null) {
            JSONArray array = new JSONArray();
            for (int i = 0; i < group.getLightIdentifiers().size(); ++i) {
                array.put(i, group.getLightIdentifiers().get(i));
            }
            toSend.putOpt("lights", array);
        }
        return toSend;
    }

    @Override
    public boolean validateAPI(PHGroup group) {
        return true;
    }

    @Override
    public boolean canCreate() {
        return true;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public boolean canDelete() {
        return true;
    }
}

