/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip.serialisation;

import com.philips.lighting.hue.sdk.clip.serialisation.PHBridgeConfigurationSerializer5;
import com.philips.lighting.model.PHBridgeConfiguration;
import com.philips.lighting.model.PHSoftwareUpdateDeviceTypes;
import com.philips.lighting.model.PHSoftwareUpdateStatus;
import org.json.hue.JSONArray;
import org.json.hue.JSONException;
import org.json.hue.JSONObject;

public class PHBridgeConfigurationSerializer6
extends PHBridgeConfigurationSerializer5 {
    private static PHBridgeConfigurationSerializer6 bridgeConfigSerialisation6;

    public static synchronized PHBridgeConfigurationSerializer6 getInstance() {
        if (bridgeConfigSerialisation6 == null) {
            bridgeConfigSerialisation6 = new PHBridgeConfigurationSerializer6();
        }
        return bridgeConfigSerialisation6;
    }

    @Override
    public PHBridgeConfiguration parseBridgeConfiguration(JSONObject rootObject) {
        PHBridgeConfiguration config = super.parseBridgeConfiguration(rootObject);
        if (config != null) {
            JSONObject configObject = null;
            configObject = rootObject.has("config") ? rootObject.getJSONObject("config") : rootObject;
            if (configObject.has("checkforupdate")) {
                boolean checkForUpdate = configObject.getBoolean("checkforupdate");
                config.setCheckForUpdate(checkForUpdate);
            }
            if (configObject.has("swupdate")) {
                JSONObject swconfig;
                PHSoftwareUpdateStatus softwareStatus = config.getSoftwareStatus();
                if (softwareStatus == null) {
                    softwareStatus = new PHSoftwareUpdateStatus();
                }
                if ((swconfig = configObject.getJSONObject("swupdate")).has("devicetypes")) {
                    int i;
                    JSONObject devicetypesConfig = swconfig.getJSONObject("devicetypes");
                    PHSoftwareUpdateDeviceTypes deviceTypes = new PHSoftwareUpdateDeviceTypes();
                    if (devicetypesConfig.has("lights")) {
                        JSONArray mainsLightsArray = devicetypesConfig.getJSONArray("lights");
                        for (i = 0; i < mainsLightsArray.length(); ++i) {
                            String mlid = mainsLightsArray.getString(i);
                            if (mlid == null) continue;
                            deviceTypes.addMainsLight(mlid);
                        }
                    }
                    if (devicetypesConfig.has("batterylights")) {
                        JSONArray batteryLightsArray = devicetypesConfig.getJSONArray("batterylights");
                        for (i = 0; i < batteryLightsArray.length(); ++i) {
                            String blid = batteryLightsArray.getString(i);
                            if (blid == null) continue;
                            deviceTypes.addBatteryLight(blid);
                        }
                    }
                    if (devicetypesConfig.has("mainssensors")) {
                        JSONArray mainsSensorsArray = devicetypesConfig.getJSONArray("mainssensors");
                        for (i = 0; i < mainsSensorsArray.length(); ++i) {
                            String msid = mainsSensorsArray.getString(i);
                            if (msid == null) continue;
                            deviceTypes.addMainsSensor(msid);
                        }
                    }
                    if (devicetypesConfig.has("batterysensors")) {
                        JSONArray batterySensorsArray = devicetypesConfig.getJSONArray("batterysensors");
                        for (i = 0; i < batterySensorsArray.length(); ++i) {
                            String bsid = batterySensorsArray.getString(i);
                            if (bsid == null) continue;
                            deviceTypes.addBatterySensor(bsid);
                        }
                    }
                    if (devicetypesConfig.has("slowsensors")) {
                        JSONArray slowSensorsArray = devicetypesConfig.getJSONArray("slowsensors");
                        for (i = 0; i < slowSensorsArray.length(); ++i) {
                            String ssid = slowSensorsArray.getString(i);
                            if (ssid == null) continue;
                            deviceTypes.addSlowSensor(ssid);
                        }
                    }
                    softwareStatus.setDeviceTypes(deviceTypes);
                }
                config.setSoftwareStatus(softwareStatus);
            }
        }
        return config;
    }

    @Override
    public JSONObject updateBridgeConfigurationPacket(PHBridgeConfiguration bridgeConfig) throws JSONException {
        JSONObject packet = super.updateBridgeConfigurationPacket(bridgeConfig);
        if (bridgeConfig.getCheckForUpdate() != null) {
            packet.put("checkforupdate", bridgeConfig.getCheckForUpdate());
        }
        return packet;
    }

    @Override
    public boolean validateAPI(PHBridgeConfiguration bridgeConfiguration) {
        return true;
    }
}

