/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip.serialisation;

import com.philips.lighting.hue.sdk.clip.serialisation.PHBridgeConfigurationSerializer1;
import com.philips.lighting.model.PHBridgeConfiguration;
import org.json.hue.JSONException;
import org.json.hue.JSONObject;

public class PHBridgeConfigurationSerializer2
extends PHBridgeConfigurationSerializer1 {
    private static PHBridgeConfigurationSerializer2 bridgeConfigSerialisation2;

    public static synchronized PHBridgeConfigurationSerializer2 getInstance() {
        if (bridgeConfigSerialisation2 == null) {
            bridgeConfigSerialisation2 = new PHBridgeConfigurationSerializer2();
        }
        return bridgeConfigSerialisation2;
    }

    @Override
    public PHBridgeConfiguration parseBridgeConfiguration(JSONObject rootObject) {
        PHBridgeConfiguration bridgeConfig = super.parseBridgeConfiguration(rootObject);
        try {
            JSONObject config = rootObject.optJSONObject("config");
            if (config == null) {
                config = rootObject;
            }
            if (config != null) {
                String timeZone = config.optString("timezone");
                String localTime = config.optString("localtime");
                String apiVersion = config.optString("apiversion");
                if (bridgeConfig != null) {
                    bridgeConfig.setTimeZone(timeZone);
                    bridgeConfig.setLocalTime(localTime);
                    bridgeConfig.setAPIVersion(apiVersion);
                }
            }
        }
        catch (Exception e) {
            this.reportParsingError(60, "", "Config unparsable due to error: " + e.getMessage(), rootObject.optJSONObject("config"));
        }
        return bridgeConfig;
    }

    @Override
    public JSONObject updateBridgeConfigurationPacket(PHBridgeConfiguration bridgeConfig) throws JSONException {
        JSONObject toSend = super.updateBridgeConfigurationPacket(bridgeConfig);
        if (bridgeConfig.getTimeZone() != null && bridgeConfig.getTimeZone().length() > 0) {
            toSend.putOpt("timezone", bridgeConfig.getTimeZone());
        }
        return toSend;
    }

    @Override
    public boolean validateAPI(PHBridgeConfiguration bridgeConfiguration) {
        if (bridgeConfiguration.getZigbeeChannel() != null) {
            return false;
        }
        if (bridgeConfiguration.isReboot()) {
            return false;
        }
        return bridgeConfiguration.getPortalState() == null;
    }
}

