package ru.org.amip.ambisync.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/**
 * Date: 28.02.14 Time: 7:34
 *
 * @author serge
 */
public class LampConfig {
  private static final Logger logger = LoggerFactory.getLogger(LampConfig.class);

  public static final String LAMPS_CONFIG = "../conf/sync-presets/lamps.json";

  private Map<String, Lamp> lamps = new LinkedHashMap<>();

  public static JsonObject convertFileToJSON(String fileName) throws FileNotFoundException {
    JsonObject jsonObject;

    JsonParser parser = new JsonParser();
    JsonElement jsonElement = parser.parse(new FileReader(fileName));
    jsonObject = jsonElement.getAsJsonObject();

    return jsonObject;
  }

  public Map<String, Lamp> load() {
    return load(null);
  }


  public Map<String, Lamp> load(String config) {
    if (config == null) config = LAMPS_CONFIG;
    else {
      config = "../conf/sync-presets/" + config + ".json";
    }

    try {
      final JsonObject o = convertFileToJSON(config);
      final Set<Map.Entry<String, JsonElement>> lamps = o.entrySet();
      for (Map.Entry<String, JsonElement> lamp : lamps) {
        final String name = lamp.getKey();

        Lamp l = new Lamp();
        final JsonObject sidesObject = (JsonObject) lamp.getValue();
        final Set<Map.Entry<String, JsonElement>> sides = sidesObject.entrySet();
        for (Map.Entry<String, JsonElement> side : sides) {
          String position = side.getKey();

          switch (position) {
            case "left":
            case "right":
            case "top":
            case "bottom":
              final JsonArray leds = side.getValue().getAsJsonArray();
              ArrayList<Integer> ledList = new ArrayList<Integer>();
              for (JsonElement led : leds) {
                ledList.add(led.getAsInt());
              }
              l.setLeds(position, ledList);
              break;
            case "brightness":
              l.setBrightness(side.getValue().getAsInt());
              break;
            case "immersion":
              l.setImmersion(side.getValue().getAsInt());
              break;
            case "transition":
              l.setTransition(side.getValue().getAsInt());
              break;
            case "model":
              l.setModel(side.getValue().getAsString());
              break;
          }
        }
        this.lamps.put(name, l);
      }

      logger.info("Loaded {} lamps from {}", lamps.size(), config);
    } catch (FileNotFoundException e) {
      logger.error("Cannot load lamps config file ({})!", config);
    }
    return lamps;
  }

  public static void main(String[] args) {
    new LampConfig().load();
  }
}
