package ru.org.amip.ambisync;

import com.philips.lighting.hue.sdk.PHHueSDK;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.org.amip.ambisync.config.Command;
import ru.org.amip.ambisync.web.AmbiWeb;
import spark.Spark;
import spark.servlet.SparkApplication;


public class Main {
  private static final Logger logger = LoggerFactory.getLogger(Main.class);

  public static PropertiesConfiguration conf;

  static {
    try {
      conf = new PropertiesConfiguration("../conf/application.conf");
    } catch (ConfigurationException e) {
      logger.error("Failed to load application config!");
    }
  }

  public static boolean saveConfig() {
    try {
      conf.save();
      conf.save("../conf/application.conf.bak"); //save backup
      return true;
    } catch (ConfigurationException e) {
      logger.error("Failed to save config: {}", e.getMessage());
      return false;
    }
  }

  public static final Thread SHUTDOWN_HOOK = new Thread() {
    @Override
    public void run() {
      Spark.stop();
      AmbiSync.getInstance().stopSync(false);
      try {
        AmbiSync.getInstance().getScheduler().shutdown(true);
      } catch (SchedulerException e) {
        logger.error("Can't shutdown scheduler", e);
      }
      try {
        Thread.sleep(1000);
      } catch (InterruptedException e) {
        e.printStackTrace();
      }
      Controller.getInstance().shutdown();
      logger.error("---- HAmbiSync v{} shutdown ----", Version.getVersion());
    }
  };

  public static void main(String[] args) {
    logger.error("---- HAmbiSync v{} (built: {}) startup ----", Version.getVersion(), Version.getTimeStamp());
    setUpShutdownHook();

    SparkApplication webapp = new AmbiWeb();
    webapp.init();

    PHHueSDK phHueSDK = PHHueSDK.create();

    Command.getInstance();

    Controller controller = Controller.getInstance();
    phHueSDK.getNotificationManager().registerSDKListener(controller.getListener());
    if (!controller.connectToLastKnownAccessPoint()) {
      controller.findBridges();
    }
  }

  private static void setUpShutdownHook() {
    Runtime.getRuntime().addShutdownHook(SHUTDOWN_HOOK);
  }
}
