package ru.org.amip.ambisync;

import org.boris.winrun4j.Service;
import org.boris.winrun4j.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceMain implements Service {
  private static final Logger logger = LoggerFactory.getLogger(ServiceMain.class);

  public int serviceMain(String[] args) throws ServiceException {
    logger.info("AmbySync is starting as system service...");
    Main.main(args);
    return 0;
  }

  public int serviceRequest(int control) throws ServiceException {
    switch (control) {
      case SERVICE_CONTROL_STOP:
      case SERVICE_CONTROL_SHUTDOWN:
        logger.info("AmbySync system service shutdown...");
        Runtime.getRuntime().removeShutdownHook(Main.SHUTDOWN_HOOK);
        final Thread thread = new Thread(Main.SHUTDOWN_HOOK);
        thread.start();
        try {
          thread.join(10000);
        } catch (InterruptedException e) {
          logger.error("Interrupted", e);
        }
        break;
      default:
        break;
    }
    return 0;
  }
}
