package ru.org.amip.ambisync;

import com.google.gson.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.org.amip.ambisync.config.Lamp;

import java.util.ArrayList;
import java.util.Map;

import static ru.org.amip.ambisync.Main.conf;

/**
 * Date: 16.03.2014 Time: 20:55
 *
 * @author serge
 */
public class AmbilightUtil {
  private static final Logger logger = LoggerFactory.getLogger(AmbilightUtil.class);

  public static RGB getAverageColor(Lamp l, JsonObject data) {
    final String layer = conf.getString("tv.ambi.layer");

    final Map<String, ArrayList<Integer>> sideLeds = l.getSideLeds();
    int r = 0, g = 0, b = 0, count = 0;
    for (Map.Entry<String, ArrayList<Integer>> entry : sideLeds.entrySet()) {
      String side = entry.getKey();
      final ArrayList<Integer> leds = entry.getValue();
      for (Integer led : leds) {
        final JsonObject jsLayer = data.get(layer).getAsJsonObject();
        if (jsLayer != null) {
          final JsonObject jsSide = jsLayer.get(side).getAsJsonObject();
          if (jsSide != null) {
            final JsonObject rgb = jsSide.get(led.toString()).getAsJsonObject();
            if (rgb != null) {
              r += rgb.get("r").getAsInt();
              g += rgb.get("g").getAsInt();
              b += rgb.get("b").getAsInt();
              count++;
            } else {
              logger.error("LED number '{}' in layer `{}` on side `{}` is not preset in TV JSON response", led, layer, side);
            }
          } else {
            logger.error("Side '{}' is not preset in TV JSON response", side);
          }
        } else {
          logger.error("Layer '{}' is not preset in TV JSON response", layer);
        }
      }
    }
    if (count == 0) {
      logger.error("Can't calculate average color, check your lamps/tv config!");
      return new RGB(0, 0, 0);
    }
    return new RGB(r / count, g / count, b / count);
  }
}
