/*
 * Copyright 2008, Sergey Baranov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package amip.api.examples.highlevel;

import amip.api.examples.util.Helpers;
import amip.api.highlevel.Client;
import amip.api.highlevel.EventListenerManager;
import amip.api.highlevel.Server;
import amip.api.highlevel.exceptions.ClientInitializationFailedException;
import amip.api.highlevel.exceptions.GeneralClientException;
import amip.api.highlevel.exceptions.ServerStartupFailedException;
import amip.api.highlevel.listeners.TimerEventListener;

/**
 * For debugging purposes. Sets timer listener and watches variable changes. Prints new value of the variable when
 * changed. Supply variable via command line argument, like <code>java VariableWatcher var_name</code>.
 */
public class VariableWatcher {
  public static void main(String[] args) throws ServerStartupFailedException, ClientInitializationFailedException, GeneralClientException {
    if (args.length == 0) {
      System.out.println("You must specify AMIP variable to watch");
      return;
    }

    final String var = args[0];

    System.out.println("Watching for changes of: " + var);

    final Client c = Client.getInstance();
    Server s = Server.getInstance();

    c.init();
    s.start();

    EventListenerManager manager = s.getEventListenersManager();
    manager.addEventListener(new TimerEventListener() {
      String value = "";

      public void eventReceived() {
        try {
          String newval = c.evaluate(var);
          if (newval == null) return;
          if (newval.compareToIgnoreCase(value) != 0) {
            value = newval;
            System.out.println(var + " = " + newval);
          }
        } catch (GeneralClientException e) {
          e.printStackTrace();
        }
      }
    });

    Helpers.setupTerminationHandlerAndWait(Thread.currentThread());

    manager.removeAllEventListeners();
    c.uninit();
    s.stop();
  }
}
