/*
 * Copyright 2008, Sergey Baranov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package amip.api.examples.highlevel;

import amip.api.examples.util.Helpers;
import amip.api.highlevel.Client;
import amip.api.highlevel.Playlist;
import amip.api.highlevel.Server;
import amip.api.highlevel.listeners.SyncCompleteEventListener;

import java.util.ArrayList;
import java.util.Iterator;

/**
 * Illustrates the async way to get the playlist. Every time playlist changes in the player it will be automatically
 * printed into console until Ctrl+C is pressed.
 */
public class GetPlaylistAsync {
  public static void main(String[] args) {
    Client c = Client.getInstance();
    Server s = Server.getInstance();

    try {
      c.init();
      s.start();

      final Playlist p = c.getPlaylist();
      p.setAutoSynchronize(true);

      p.addSyncCompleteListener(new SyncCompleteEventListener() {
        public void syncComplete() {
          int size = p.getSize();
          System.out.println("Current playlist size = " + size);
          ArrayList playList = p.getCopy();
          for (Iterator it = playList.iterator(); it.hasNext();) {
            String s = (String) it.next();
            System.out.println(s);
          }
        }
      });

      System.out.println("Synchronizing playlist...");
      p.sync();

      Helpers.setupTerminationHandlerAndWait(Thread.currentThread());

      s.getEventListenersManager().removeAllEventListeners();
    } catch (Exception e) {
      e.printStackTrace();
    } finally {
      c.uninit();
      s.stop();
    }
  }
}
