/*
 * Copyright 2008, Sergey Baranov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package amip.api.examples.highlevel;

import amip.api.highlevel.Client;
import amip.api.highlevel.exceptions.ClientInitializationFailedException;
import amip.api.highlevel.exceptions.GeneralClientException;

/**
 * If you need a part of playlist, or you know that list is small and you don't want to use Server, use approach
 * illustrated in this sample - evaluate("title " + i); If you need file names, use 'fn' instead of 'title'.
 * <p/>
 * Don't use it for large playlists, it may take about a second for 50 entries!
 */
public class EvalTitles {
  public static void main(String[] args) throws ClientInitializationFailedException, GeneralClientException {
    Client c = Client.getInstance();
    c.init();
    int size = Integer.parseInt(c.evaluate("var_ll"));
    for (int i = 1; i < size + 1; i++) {
      String s = c.evaluate("title " + i);
      System.out.println(s);
    }
    c.uninit();
  }
}
