/*
 * Copyright 2008, Sergey Baranov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package amip.api.examples.highlevel;

import amip.api.examples.util.Helpers;
import amip.api.highlevel.Client;
import amip.api.highlevel.EventListenerManager;
import amip.api.highlevel.Player;
import amip.api.highlevel.Server;
import amip.api.highlevel.exceptions.GeneralClientException;
import amip.api.highlevel.listeners.ChangeEventListener;
import amip.api.highlevel.listeners.StartEventListener;
import amip.api.highlevel.listeners.MessageEventListener;
import amip.api.wrapper.AMIPAPI;

public class StressTest {
  public static void main(String[] args) {
    if (!AMIPAPI.loadNativeLibs()) {
      System.err.println("Can't load the native libraries");
      return;
    }

    final Client c = Client.getInstance();
    Server s = Server.getInstance();
    s.setPort(Server.findFreeLocalPort());

    try {
      c.init();
      s.start();

      EventListenerManager elm = s.getEventListenersManager();
      elm.addEventListener(new StartEventListener() {
        public void eventReceived() {
          try {
            Thread.sleep(2000);
          } catch (InterruptedException e) {
            e.printStackTrace();
          }
          boolean ping = c.pingServer();
          printStatus(c);
          System.out.println("ping = " + ping);
          try {
            Player player = c.getPlayer();
            int status = player.getStatus();
            System.out.println("int status = " + status);
            if(status == Player.STATUS_PAUSED) {
              player.pause();
            } else if (status == Player.STATUS_STOPPED) {
              player.play();
            }
          } catch (GeneralClientException e) {
            e.printStackTrace();
          }
        }
      });

      elm.addEventListener(new ChangeEventListener() {
        public void eventReceived() {
          printStatus(c);
        }
      });

      elm.addMessageEventListener(new MessageEventListener() {
        public void messageReceived(String msg) {
          System.out.println("msg = " + msg);
        }
      });

      Helpers.setupTerminationHandlerAndWait(Thread.currentThread());

      s.getEventListenersManager().removeAllEventListeners();
    } catch (Exception e) {
      e.printStackTrace();
    } finally {
      c.uninit();
      s.stop();
    }
  }

  private static void printStatus(Client c) {
    String status = null;
    try {
      status = c.format("%tstat");
    } catch (GeneralClientException e) {
      e.printStackTrace();
    }
    System.out.println("status = " + status);
  }
}
