/*
 * Copyright 2008, Sergey Baranov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package amip.api.examples.highlevel;

import amip.api.highlevel.Client;
import amip.api.highlevel.Playlist;
import amip.api.highlevel.Server;
import amip.api.wrapper.AMIPAPI;

import java.util.ArrayList;
import java.util.Iterator;

public class GetPlaylist {
  public static void main(String[] args) {
    if(!AMIPAPI.loadNativeLibs()) {
      System.err.println("Can't load the native libraries");
      return;
    }

    Client c = Client.getInstance();
    Server s = Server.getInstance();
    s.setPort(Server.findFreeLocalPort());

    try {
      c.init();
      s.start();

      Playlist p = c.getPlaylist();
      ArrayList playList = p.syncAndGetCopy();

      for (Iterator it = playList.iterator(); it.hasNext();) {
        String l = (String) it.next();
        System.out.println(l);
      }

      s.getEventListenersManager().removeAllEventListeners();
    } catch (Exception e) {
      e.printStackTrace();
    } finally {
      c.uninit();
      s.stop();
    }
  }
}
